/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.ingestion.models;

import android.support.annotation.VisibleForTesting;
import com.microsoft.azure.mobile.ingestion.models.Device;
import com.microsoft.azure.mobile.ingestion.models.Log;
import com.microsoft.azure.mobile.ingestion.models.json.JSONDateUtils;
import com.microsoft.azure.mobile.ingestion.models.json.JSONUtils;
import java.util.Date;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;

public abstract class AbstractLog
implements Log {
    @VisibleForTesting
    static final String TIMESTAMP = "timestamp";
    @VisibleForTesting
    static final String SID = "sid";
    @VisibleForTesting
    static final String DEVICE = "device";
    private Date timestamp;
    private UUID sid;
    private Device device;

    @Override
    public Date getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public UUID getSid() {
        return this.sid;
    }

    @Override
    public void setSid(UUID sid) {
        this.sid = sid;
    }

    @Override
    public Device getDevice() {
        return this.device;
    }

    @Override
    public void setDevice(Device device) {
        this.device = device;
    }

    @Override
    public void write(JSONStringer writer) throws JSONException {
        JSONUtils.write(writer, "type", this.getType());
        writer.key(TIMESTAMP).value((Object)JSONDateUtils.toString(this.getTimestamp()));
        JSONUtils.write(writer, SID, this.getSid());
        if (this.getDevice() != null) {
            writer.key(DEVICE).object();
            this.getDevice().write(writer);
            writer.endObject();
        }
    }

    @Override
    public void read(JSONObject object) throws JSONException {
        if (!object.getString("type").equals(this.getType())) {
            throw new JSONException("Invalid type");
        }
        this.setTimestamp(JSONDateUtils.toDate(object.getString(TIMESTAMP)));
        if (object.has(SID)) {
            this.setSid(UUID.fromString(object.getString(SID)));
        }
        if (object.has(DEVICE)) {
            Device device = new Device();
            device.read(object.getJSONObject(DEVICE));
            this.setDevice(device);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractLog that = (AbstractLog)o;
        if (this.timestamp != null ? !this.timestamp.equals(that.timestamp) : that.timestamp != null) {
            return false;
        }
        if (this.sid != null ? !this.sid.equals(that.sid) : that.sid != null) {
            return false;
        }
        return this.device != null ? this.device.equals(that.device) : that.device == null;
    }

    public int hashCode() {
        int result = this.timestamp != null ? this.timestamp.hashCode() : 0;
        result = 31 * result + (this.sid != null ? this.sid.hashCode() : 0);
        result = 31 * result + (this.device != null ? this.device.hashCode() : 0);
        return result;
    }
}

