/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.ingestion;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.microsoft.azure.mobile.http.DefaultHttpClient;
import com.microsoft.azure.mobile.http.HttpClient;
import com.microsoft.azure.mobile.http.HttpClientNetworkStateHandler;
import com.microsoft.azure.mobile.http.HttpClientRetryer;
import com.microsoft.azure.mobile.http.HttpUtils;
import com.microsoft.azure.mobile.http.ServiceCall;
import com.microsoft.azure.mobile.http.ServiceCallback;
import com.microsoft.azure.mobile.ingestion.Ingestion;
import com.microsoft.azure.mobile.ingestion.models.LogContainer;
import com.microsoft.azure.mobile.ingestion.models.json.LogSerializer;
import com.microsoft.azure.mobile.utils.MobileCenterLog;
import com.microsoft.azure.mobile.utils.NetworkStateHelper;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.json.JSONException;

public class IngestionHttp
implements Ingestion {
    public static final String DEFAULT_LOG_URL = "https://in.mobile.azure.com";
    @VisibleForTesting
    static final String API_PATH = "/logs?api_version=1.0.0-preview20160914";
    @VisibleForTesting
    static final String INSTALL_ID = "Install-ID";
    @VisibleForTesting
    static final String APP_SECRET = "App-Secret";
    private final LogSerializer mLogSerializer;
    private final HttpClient mHttpClient;
    private String mLogUrl;

    public IngestionHttp(@NonNull Context context, @NonNull LogSerializer logSerializer) {
        this.mLogSerializer = logSerializer;
        HttpClientRetryer retryer = new HttpClientRetryer(new DefaultHttpClient());
        NetworkStateHelper networkStateHelper = NetworkStateHelper.getSharedInstance(context);
        this.mHttpClient = new HttpClientNetworkStateHandler(retryer, networkStateHelper);
        this.mLogUrl = DEFAULT_LOG_URL;
    }

    @Override
    public void setLogUrl(@NonNull String logUrl) {
        this.mLogUrl = logUrl;
    }

    @Override
    public ServiceCall sendAsync(String appSecret, UUID installId, LogContainer logContainer, ServiceCallback serviceCallback) throws IllegalArgumentException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(INSTALL_ID, installId.toString());
        headers.put(APP_SECRET, appSecret);
        IngestionCallTemplate callTemplate = new IngestionCallTemplate(this.mLogSerializer, logContainer);
        return this.mHttpClient.callAsync(this.mLogUrl + API_PATH, "POST", headers, callTemplate, serviceCallback);
    }

    @Override
    public void close() throws IOException {
        this.mHttpClient.close();
    }

    private static class IngestionCallTemplate
    implements HttpClient.CallTemplate {
        private final LogSerializer mLogSerializer;
        private final LogContainer mLogContainer;

        IngestionCallTemplate(LogSerializer logSerializer, LogContainer logContainer) {
            this.mLogSerializer = logSerializer;
            this.mLogContainer = logContainer;
        }

        @Override
        public String buildRequestBody() throws JSONException {
            return this.mLogSerializer.serializeContainer(this.mLogContainer);
        }

        @Override
        public void onBeforeCalling(URL url, Map<String, String> headers) {
            if (MobileCenterLog.getLogLevel() <= 2) {
                MobileCenterLog.verbose("MobileCenter", "Calling " + url + "...");
                HashMap<String, String> logHeaders = new HashMap<String, String>(headers);
                String appSecret = (String)logHeaders.get(IngestionHttp.APP_SECRET);
                if (appSecret != null) {
                    logHeaders.put(IngestionHttp.APP_SECRET, HttpUtils.hideSecret(appSecret));
                }
                MobileCenterLog.verbose("MobileCenter", "Headers: " + logHeaders);
            }
        }
    }
}

