/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.http;

import android.support.annotation.VisibleForTesting;
import com.microsoft.azure.mobile.http.HttpException;
import java.io.EOFException;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.RejectedExecutionException;
import java.util.regex.Pattern;
import javax.net.ssl.SSLException;

public class HttpUtils {
    @VisibleForTesting
    static final int MAX_CHARACTERS_DISPLAYED_FOR_SECRET = 8;
    private static final Class[] RECOVERABLE_EXCEPTIONS = new Class[]{EOFException.class, InterruptedIOException.class, SocketException.class, UnknownHostException.class, RejectedExecutionException.class};
    private static final Pattern CONNECTION_ISSUE_PATTERN = Pattern.compile("connection (time|reset)|failure in ssl library, usually a protocol error");

    @VisibleForTesting
    HttpUtils() {
    }

    public static boolean isRecoverableError(Throwable t) {
        String message;
        if (t instanceof HttpException) {
            HttpException exception = (HttpException)t;
            int code = exception.getStatusCode();
            return code >= 500 || code == 408 || code == 429;
        }
        for (Class type : RECOVERABLE_EXCEPTIONS) {
            if (!type.isAssignableFrom(t.getClass())) continue;
            return true;
        }
        Throwable cause = t.getCause();
        if (cause != null) {
            for (Class type : RECOVERABLE_EXCEPTIONS) {
                if (!type.isAssignableFrom(cause.getClass())) continue;
                return true;
            }
        }
        return t instanceof SSLException && (message = t.getMessage()) != null && CONNECTION_ISSUE_PATTERN.matcher(message.toLowerCase(Locale.US)).find();
    }

    public static String hideSecret(String secret) {
        if (secret == null || secret.isEmpty()) {
            return secret;
        }
        int hidingEndIndex = secret.length() - (secret.length() >= 8 ? 8 : 0);
        char[] fill = new char[hidingEndIndex];
        Arrays.fill(fill, '*');
        return new String(fill) + secret.substring(hidingEndIndex);
    }
}

