/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.http;

import com.microsoft.azure.mobile.http.HttpClient;
import com.microsoft.azure.mobile.http.HttpClientCallDecorator;
import com.microsoft.azure.mobile.http.HttpClientDecorator;
import com.microsoft.azure.mobile.http.ServiceCall;
import com.microsoft.azure.mobile.http.ServiceCallback;
import com.microsoft.azure.mobile.utils.MobileCenterLog;
import com.microsoft.azure.mobile.utils.NetworkStateHelper;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class HttpClientNetworkStateHandler
extends HttpClientDecorator
implements NetworkStateHelper.Listener {
    private final NetworkStateHelper mNetworkStateHelper;
    private final Set<Call> mCalls = new HashSet<Call>();

    public HttpClientNetworkStateHandler(HttpClient decoratedApi, NetworkStateHelper networkStateHelper) {
        super(decoratedApi);
        this.mNetworkStateHelper = networkStateHelper;
        this.mNetworkStateHelper.addListener(this);
    }

    @Override
    public synchronized ServiceCall callAsync(String url, String method, Map<String, String> headers, HttpClient.CallTemplate callTemplate, ServiceCallback serviceCallback) {
        Call call = new Call(this.mDecoratedApi, url, method, headers, callTemplate, serviceCallback);
        this.mCalls.add(call);
        if (this.mNetworkStateHelper.isNetworkConnected()) {
            call.run();
        } else {
            MobileCenterLog.debug("MobileCenter", "Call triggered with no network connectivity, waiting network to become available...");
        }
        return call;
    }

    @Override
    public synchronized void close() throws IOException {
        this.mNetworkStateHelper.removeListener(this);
        for (Call call : this.mCalls) {
            this.pauseCall(call);
        }
        this.mCalls.clear();
        super.close();
    }

    @Override
    public synchronized void onNetworkStateUpdated(boolean connected) {
        if (connected) {
            MobileCenterLog.debug("MobileCenter", "Network is available. " + this.mCalls.size() + " pending call(s) to submit now.");
        } else {
            MobileCenterLog.debug("MobileCenter", "Network is down. Pausing " + this.mCalls.size() + " network call(s).");
        }
        for (Call call : this.mCalls) {
            if (connected) {
                call.run();
                continue;
            }
            this.pauseCall(call);
        }
    }

    private synchronized void callRunAsync(Call call) {
        call.mServiceCall = call.mDecoratedApi.callAsync(call.mUrl, call.mMethod, call.mHeaders, call.mCallTemplate, call);
    }

    private synchronized void cancelCall(Call call) {
        this.mCalls.remove(call);
        this.pauseCall(call);
    }

    private synchronized void pauseCall(Call call) {
        if (call.mServiceCall != null) {
            call.mServiceCall.cancel();
        }
    }

    private synchronized void onCallSucceeded(Call call, String payload) {
        if (this.mCalls.contains(call)) {
            call.mServiceCallback.onCallSucceeded(payload);
            this.mCalls.remove(call);
        }
    }

    private synchronized void onCallFailed(Call call, Exception e) {
        if (this.mCalls.contains(call)) {
            call.mServiceCallback.onCallFailed(e);
            this.mCalls.remove(call);
        }
    }

    private class Call
    extends HttpClientCallDecorator
    implements Runnable,
    ServiceCallback {
        Call(HttpClient decoratedApi, String url, String method, Map<String, String> headers, HttpClient.CallTemplate callTemplate, ServiceCallback serviceCallback) {
            super(decoratedApi, url, method, headers, callTemplate, serviceCallback);
        }

        @Override
        public void run() {
            HttpClientNetworkStateHandler.this.callRunAsync(this);
        }

        @Override
        public void cancel() {
            HttpClientNetworkStateHandler.this.cancelCall(this);
        }

        @Override
        public void onCallSucceeded(String payload) {
            HttpClientNetworkStateHandler.this.onCallSucceeded(this, payload);
        }

        @Override
        public void onCallFailed(Exception e) {
            HttpClientNetworkStateHandler.this.onCallFailed(this, e);
        }
    }
}

