/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.http;

import android.net.TrafficStats;
import android.os.AsyncTask;
import android.support.annotation.VisibleForTesting;
import com.microsoft.azure.mobile.http.HttpClient;
import com.microsoft.azure.mobile.http.HttpException;
import com.microsoft.azure.mobile.http.ServiceCall;
import com.microsoft.azure.mobile.http.ServiceCallback;
import com.microsoft.azure.mobile.utils.HandlerUtils;
import com.microsoft.azure.mobile.utils.MobileCenterLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;

public class DefaultHttpClient
implements HttpClient {
    public static final String METHOD_GET = "GET";
    public static final String METHOD_POST = "POST";
    private static final int THREAD_STATS_TAG = -667034599;
    private static final String CONTENT_TYPE_VALUE = "application/json";
    private static final int DEFAULT_STRING_BUILDER_CAPACITY = 16;
    private static final String CONTENT_TYPE_KEY = "Content-Type";
    private static final String CHARSET_NAME = "UTF-8";
    private static final int READ_BUFFER_SIZE = 1024;
    private static final int CONNECT_TIMEOUT = 60000;
    private static final int READ_TIMEOUT = 20000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String dump(HttpURLConnection urlConnection) throws IOException {
        StringBuilder builder = new StringBuilder(Math.max(urlConnection.getContentLength(), 16));
        int status = urlConnection.getResponseCode();
        try (InputStream stream = status >= 200 && status < 400 ? urlConnection.getInputStream() : urlConnection.getErrorStream();){
            int len;
            InputStreamReader in = new InputStreamReader(stream, CHARSET_NAME);
            char[] buffer = new char[1024];
            while ((len = in.read(buffer)) > 0) {
                builder.append(buffer, 0, len);
            }
            String string = builder.toString();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String doCall(String urlString, String method, Map<String, String> headers, HttpClient.CallTemplate callTemplate) throws Exception {
        TrafficStats.setThreadStatsTag((int)-667034599);
        try {
            String string = DefaultHttpClient.doHttpCall(urlString, method, headers, callTemplate);
            return string;
        }
        finally {
            TrafficStats.clearThreadStatsTag();
        }
    }

    private static String doHttpCall(String urlString, String method, Map<String, String> headers, HttpClient.CallTemplate callTemplate) throws Exception {
        URL url = new URL(urlString);
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        try {
            urlConnection.setConnectTimeout(60000);
            urlConnection.setReadTimeout(20000);
            urlConnection.setRequestMethod(method);
            urlConnection.setRequestProperty(CONTENT_TYPE_KEY, CONTENT_TYPE_VALUE);
            for (Map.Entry<String, String> header : headers.entrySet()) {
                urlConnection.setRequestProperty(header.getKey(), header.getValue());
            }
            if (callTemplate != null) {
                callTemplate.onBeforeCalling(url, headers);
            }
            if (method.equals(METHOD_POST) && callTemplate != null) {
                String payload = callTemplate.buildRequestBody();
                MobileCenterLog.verbose("MobileCenter", payload);
                byte[] binaryPayload = payload.getBytes(CHARSET_NAME);
                urlConnection.setDoOutput(true);
                urlConnection.setFixedLengthStreamingMode(binaryPayload.length);
                OutputStream out = urlConnection.getOutputStream();
                out.write(binaryPayload);
                out.close();
            }
            int status = urlConnection.getResponseCode();
            String response = DefaultHttpClient.dump(urlConnection);
            MobileCenterLog.verbose("MobileCenter", "HTTP response status=" + status + " payload=" + response);
            if (status >= 200 && status < 300) {
                String string = response;
                return string;
            }
            throw new HttpException(status, response);
        }
        finally {
            urlConnection.disconnect();
        }
    }

    @Override
    public ServiceCall callAsync(String url, String method, Map<String, String> headers, HttpClient.CallTemplate callTemplate, final ServiceCallback serviceCallback) {
        final Call call = new Call(url, method, headers, callTemplate, serviceCallback);
        try {
            call.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        }
        catch (RejectedExecutionException e) {
            HandlerUtils.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    serviceCallback.onCallFailed(e);
                }
            });
        }
        return new ServiceCall(){

            @Override
            public void cancel() {
                if (!call.isCancelled()) {
                    call.cancel(true);
                }
            }
        };
    }

    @Override
    public void close() throws IOException {
    }

    @VisibleForTesting
    static class Call
    extends AsyncTask<Void, Void, Object> {
        private final String mUrl;
        private final String mMethod;
        private final Map<String, String> mHeaders;
        private final HttpClient.CallTemplate mCallTemplate;
        private final ServiceCallback mServiceCallback;

        public Call(String url, String method, Map<String, String> headers, HttpClient.CallTemplate callTemplate, ServiceCallback serviceCallback) {
            this.mUrl = url;
            this.mMethod = method;
            this.mHeaders = headers;
            this.mCallTemplate = callTemplate;
            this.mServiceCallback = serviceCallback;
        }

        protected Object doInBackground(Void ... params) {
            try {
                return DefaultHttpClient.doCall(this.mUrl, this.mMethod, this.mHeaders, this.mCallTemplate);
            }
            catch (Exception e) {
                return e;
            }
        }

        protected void onPostExecute(Object result) {
            if (result instanceof Exception) {
                this.mServiceCallback.onCallFailed((Exception)result);
            } else {
                this.mServiceCallback.onCallSucceeded(result.toString());
            }
        }
    }
}

