/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.support.annotation.WorkerThread;
import com.microsoft.azure.mobile.Constants;
import com.microsoft.azure.mobile.CustomProperties;
import com.microsoft.azure.mobile.MobileCenterHandler;
import com.microsoft.azure.mobile.MobileCenterService;
import com.microsoft.azure.mobile.channel.Channel;
import com.microsoft.azure.mobile.channel.DefaultChannel;
import com.microsoft.azure.mobile.ingestion.models.CustomPropertiesLog;
import com.microsoft.azure.mobile.ingestion.models.StartServiceLog;
import com.microsoft.azure.mobile.ingestion.models.WrapperSdk;
import com.microsoft.azure.mobile.ingestion.models.json.CustomPropertiesLogFactory;
import com.microsoft.azure.mobile.ingestion.models.json.DefaultLogSerializer;
import com.microsoft.azure.mobile.ingestion.models.json.LogFactory;
import com.microsoft.azure.mobile.ingestion.models.json.LogSerializer;
import com.microsoft.azure.mobile.ingestion.models.json.StartServiceLogFactory;
import com.microsoft.azure.mobile.utils.DeviceInfoHelper;
import com.microsoft.azure.mobile.utils.IdHelper;
import com.microsoft.azure.mobile.utils.MobileCenterLog;
import com.microsoft.azure.mobile.utils.ShutdownHelper;
import com.microsoft.azure.mobile.utils.async.DefaultMobileCenterFuture;
import com.microsoft.azure.mobile.utils.async.MobileCenterFuture;
import com.microsoft.azure.mobile.utils.storage.StorageHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class MobileCenter {
    public static final String LOG_TAG = "MobileCenter";
    @VisibleForTesting
    static final String CORE_GROUP = "group_core";
    private static final int SHUTDOWN_TIMEOUT = 5000;
    @SuppressLint(value={"StaticFieldLeak"})
    private static MobileCenter sInstance;
    private boolean mLogLevelConfigured;
    private String mLogUrl;
    private Application mApplication;
    private String mAppSecret;
    private UncaughtExceptionHandler mUncaughtExceptionHandler;
    private Set<MobileCenterService> mServices;
    private LogSerializer mLogSerializer;
    private Channel mChannel;
    private HandlerThread mHandlerThread;
    private Handler mHandler;
    private MobileCenterHandler mMobileCenterHandler;

    static synchronized MobileCenter getInstance() {
        if (sInstance == null) {
            sInstance = new MobileCenter();
        }
        return sInstance;
    }

    @VisibleForTesting
    static synchronized void unsetInstance() {
        sInstance = null;
    }

    public static void setWrapperSdk(WrapperSdk wrapperSdk) {
        MobileCenter.getInstance().setInstanceWrapperSdk(wrapperSdk);
    }

    @IntRange(from=2L, to=8L)
    public static int getLogLevel() {
        return MobileCenterLog.getLogLevel();
    }

    public static void setLogLevel(@IntRange(from=2L, to=8L) int logLevel) {
        MobileCenter.getInstance().setInstanceLogLevel(logLevel);
    }

    public static void setLogUrl(String logUrl) {
        MobileCenter.getInstance().setInstanceLogUrl(logUrl);
    }

    public static void setCustomProperties(CustomProperties customProperties) {
        MobileCenter.getInstance().setInstanceCustomProperties(customProperties);
    }

    public static boolean isConfigured() {
        return MobileCenter.getInstance().isInstanceConfigured();
    }

    public static void configure(Application application, String appSecret) {
        MobileCenter.getInstance().instanceConfigure(application, appSecret);
    }

    @SafeVarargs
    public static void start(Class<? extends MobileCenterService> ... services) {
        MobileCenter.getInstance().startServices(services);
    }

    @SafeVarargs
    public static void start(Application application, String appSecret, Class<? extends MobileCenterService> ... services) {
        MobileCenter.getInstance().configureAndStartServices(application, appSecret, services);
    }

    public static MobileCenterFuture<Boolean> isEnabled() {
        return MobileCenter.getInstance().isInstanceEnabledAsync();
    }

    public static MobileCenterFuture<Void> setEnabled(boolean enabled) {
        return MobileCenter.getInstance().setInstanceEnabledAsync(enabled);
    }

    public static MobileCenterFuture<UUID> getInstallId() {
        return MobileCenter.getInstance().getInstanceInstallId();
    }

    private synchronized boolean checkPrecondition() {
        if (this.isInstanceConfigured()) {
            return true;
        }
        MobileCenterLog.error(LOG_TAG, "Mobile Center hasn't been configured. You need to call MobileCenter.start with appSecret or MobileCenter.configure first.");
        return false;
    }

    private synchronized void setInstanceWrapperSdk(WrapperSdk wrapperSdk) {
        DeviceInfoHelper.setWrapperSdk(wrapperSdk);
        if (this.mChannel != null) {
            this.mChannel.invalidateDeviceCache();
        }
    }

    private synchronized void setInstanceLogLevel(int logLevel) {
        this.mLogLevelConfigured = true;
        MobileCenterLog.setLogLevel(logLevel);
    }

    private synchronized void setInstanceLogUrl(String logUrl) {
        this.mLogUrl = logUrl;
        if (this.mChannel != null) {
            this.mChannel.setLogUrl(logUrl);
        }
    }

    private synchronized void setInstanceCustomProperties(CustomProperties customProperties) {
        if (customProperties == null) {
            MobileCenterLog.error(LOG_TAG, "Custom properties may not be null.");
            return;
        }
        final Map<String, Object> properties = customProperties.getProperties();
        if (properties.size() == 0) {
            MobileCenterLog.error(LOG_TAG, "Custom properties may not be empty.");
            return;
        }
        this.handlerMobileCenterOperation(new Runnable(){

            @Override
            public void run() {
                MobileCenter.this.queueCustomProperties(properties);
            }
        }, null);
    }

    private synchronized boolean isInstanceConfigured() {
        return this.mApplication != null;
    }

    @SuppressLint(value={"VisibleForTests"})
    private synchronized boolean instanceConfigure(Application application, String appSecret) {
        if (application == null) {
            MobileCenterLog.error(LOG_TAG, "application may not be null");
            return false;
        }
        if (appSecret == null || appSecret.isEmpty()) {
            MobileCenterLog.error(LOG_TAG, "appSecret may not be null or empty");
            return false;
        }
        if (this.mHandler != null) {
            MobileCenterLog.warn(LOG_TAG, "Mobile Center may only be configured once.");
            return false;
        }
        if (!this.mLogLevelConfigured && (application.getApplicationInfo().flags & 2) == 2) {
            MobileCenterLog.setLogLevel(5);
        }
        this.mApplication = application;
        this.mAppSecret = appSecret;
        this.mHandlerThread = new HandlerThread("MobileCenter.Looper");
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper());
        this.mMobileCenterHandler = new MobileCenterHandler(){

            @Override
            public void post(@NonNull Runnable runnable, Runnable disabledRunnable) {
                MobileCenter.this.handlerMobileCenterOperation(runnable, disabledRunnable);
            }
        };
        this.mServices = new HashSet<MobileCenterService>();
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                MobileCenter.this.finishConfiguration();
            }
        });
        MobileCenterLog.logAssert(LOG_TAG, "Mobile Center SDK configured successfully.");
        return true;
    }

    private synchronized void handlerMobileCenterOperation(final Runnable runnable, final Runnable disabledRunnable) {
        if (this.checkPrecondition()) {
            Runnable wrapperRunnable = new Runnable(){

                @Override
                public void run() {
                    if (MobileCenter.this.isInstanceEnabled()) {
                        runnable.run();
                    } else if (disabledRunnable != null) {
                        disabledRunnable.run();
                    } else {
                        MobileCenterLog.error(MobileCenter.LOG_TAG, "Mobile Center SDK is disabled.");
                    }
                }
            };
            if (Thread.currentThread() == this.mHandlerThread) {
                runnable.run();
            } else {
                this.mHandler.post(wrapperRunnable);
            }
        }
    }

    @WorkerThread
    private void finishConfiguration() {
        Constants.loadFromContext((Context)this.mApplication);
        StorageHelper.initialize((Context)this.mApplication);
        boolean enabled = this.isInstanceEnabled();
        this.mUncaughtExceptionHandler = new UncaughtExceptionHandler();
        if (enabled) {
            this.mUncaughtExceptionHandler.register();
        }
        this.mLogSerializer = new DefaultLogSerializer();
        this.mLogSerializer.addLogFactory("start_service", new StartServiceLogFactory());
        this.mLogSerializer.addLogFactory("custom_properties", new CustomPropertiesLogFactory());
        this.mChannel = new DefaultChannel((Context)this.mApplication, this.mAppSecret, this.mLogSerializer, this.mHandler);
        this.mChannel.setEnabled(enabled);
        this.mChannel.addGroup(CORE_GROUP, 50, 3000L, 3, null);
        if (this.mLogUrl != null) {
            this.mChannel.setLogUrl(this.mLogUrl);
        }
        MobileCenterLog.debug(LOG_TAG, "Mobile Center storage initialized.");
    }

    @SafeVarargs
    private final synchronized void startServices(Class<? extends MobileCenterService> ... services) {
        if (services == null) {
            MobileCenterLog.error(LOG_TAG, "Cannot start services, services array is null. Failed to start services.");
            return;
        }
        if (this.mApplication == null) {
            String serviceNames = "";
            for (Class<? extends MobileCenterService> service : services) {
                serviceNames = serviceNames + "\t" + service.getName() + "\n";
            }
            MobileCenterLog.error(LOG_TAG, "Cannot start services, Mobile Center has not been configured. Failed to start the following services:\n" + serviceNames);
            return;
        }
        final ArrayList<MobileCenterService> startedServices = new ArrayList<MobileCenterService>();
        for (Class<? extends MobileCenterService> service : services) {
            if (service == null) {
                MobileCenterLog.warn(LOG_TAG, "Skipping null service, please check your varargs/array does not contain any null reference.");
                continue;
            }
            try {
                MobileCenterService serviceInstance = (MobileCenterService)service.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                if (this.mServices.contains(serviceInstance)) {
                    MobileCenterLog.warn(LOG_TAG, "Mobile Center has already started the service with class name: " + service.getName());
                    continue;
                }
                serviceInstance.onStarting(this.mMobileCenterHandler);
                this.mApplication.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)serviceInstance);
                this.mServices.add(serviceInstance);
                startedServices.add(serviceInstance);
            }
            catch (Exception e) {
                MobileCenterLog.error(LOG_TAG, "Failed to get service instance '" + service.getName() + "', skipping it.", e);
            }
        }
        if (startedServices.size() > 0) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    MobileCenter.this.finishStartServices(startedServices);
                }
            });
        }
    }

    @WorkerThread
    private void finishStartServices(Iterable<MobileCenterService> services) {
        ArrayList<String> serviceNames = new ArrayList<String>();
        for (MobileCenterService service : services) {
            Map<String, LogFactory> logFactories = service.getLogFactories();
            if (logFactories != null) {
                for (Map.Entry<String, LogFactory> logFactory : logFactories.entrySet()) {
                    this.mLogSerializer.addLogFactory(logFactory.getKey(), logFactory.getValue());
                }
            }
            service.onStarted((Context)this.mApplication, this.mAppSecret, this.mChannel);
            MobileCenterLog.info(LOG_TAG, service.getClass().getSimpleName() + " service started.");
            serviceNames.add(service.getServiceName());
        }
        if (this.isInstanceEnabled()) {
            StartServiceLog startServiceLog = new StartServiceLog();
            startServiceLog.setServices(serviceNames);
            this.mChannel.enqueue(startServiceLog, CORE_GROUP);
        }
    }

    @SafeVarargs
    private final synchronized void configureAndStartServices(Application application, String appSecret, Class<? extends MobileCenterService> ... services) {
        boolean configuredSuccessfully = this.instanceConfigure(application, appSecret);
        if (configuredSuccessfully) {
            this.startServices(services);
        }
    }

    @WorkerThread
    private void queueCustomProperties(@NonNull Map<String, Object> properties) {
        CustomPropertiesLog customPropertiesLog = new CustomPropertiesLog();
        customPropertiesLog.setProperties(properties);
        this.mChannel.enqueue(customPropertiesLog, CORE_GROUP);
    }

    private synchronized MobileCenterFuture<Boolean> isInstanceEnabledAsync() {
        final DefaultMobileCenterFuture<Boolean> future = new DefaultMobileCenterFuture<Boolean>();
        if (this.checkPrecondition()) {
            this.mMobileCenterHandler.post(new Runnable(){

                @Override
                public void run() {
                    future.complete(true);
                }
            }, new Runnable(){

                @Override
                public void run() {
                    future.complete(false);
                }
            });
        } else {
            future.complete(false);
        }
        return future;
    }

    private boolean isInstanceEnabled() {
        return StorageHelper.PreferencesStorage.getBoolean("enabled", true);
    }

    @WorkerThread
    private void setInstanceEnabled(boolean enabled) {
        boolean switchToEnabled;
        this.mChannel.setEnabled(enabled);
        boolean previouslyEnabled = this.isInstanceEnabled();
        boolean switchToDisabled = previouslyEnabled && !enabled;
        boolean bl = switchToEnabled = !previouslyEnabled && enabled;
        if (switchToEnabled) {
            this.mUncaughtExceptionHandler.register();
        } else if (switchToDisabled) {
            this.mUncaughtExceptionHandler.unregister();
        }
        if (enabled) {
            StorageHelper.PreferencesStorage.putBoolean("enabled", true);
        }
        for (MobileCenterService service : this.mServices) {
            if (service.isInstanceEnabled() == enabled) continue;
            service.setInstanceEnabled(enabled);
        }
        if (!enabled) {
            StorageHelper.PreferencesStorage.putBoolean("enabled", false);
        }
        if (switchToDisabled) {
            MobileCenterLog.info(LOG_TAG, "Mobile Center has been disabled.");
        } else if (switchToEnabled) {
            MobileCenterLog.info(LOG_TAG, "Mobile Center has been enabled.");
        } else {
            MobileCenterLog.info(LOG_TAG, "Mobile Center has already been " + (enabled ? "enabled" : "disabled") + ".");
        }
    }

    private synchronized MobileCenterFuture<Void> setInstanceEnabledAsync(final boolean enabled) {
        final DefaultMobileCenterFuture<Void> future = new DefaultMobileCenterFuture<Void>();
        if (this.checkPrecondition()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    MobileCenter.this.setInstanceEnabled(enabled);
                    future.complete(null);
                }
            });
        } else {
            future.complete(null);
        }
        return future;
    }

    private synchronized MobileCenterFuture<UUID> getInstanceInstallId() {
        final DefaultMobileCenterFuture<UUID> future = new DefaultMobileCenterFuture<UUID>();
        if (this.checkPrecondition()) {
            this.mMobileCenterHandler.post(new Runnable(){

                @Override
                public void run() {
                    future.complete(IdHelper.getInstallId());
                }
            }, new Runnable(){

                @Override
                public void run() {
                    future.complete(null);
                }
            });
        } else {
            future.complete(null);
        }
        return future;
    }

    @VisibleForTesting
    Set<MobileCenterService> getServices() {
        return this.mServices;
    }

    @VisibleForTesting
    Application getApplication() {
        return this.mApplication;
    }

    @VisibleForTesting
    UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.mUncaughtExceptionHandler;
    }

    @VisibleForTesting
    void setChannel(Channel channel) {
        this.mChannel = channel;
    }

    @VisibleForTesting
    class UncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private Thread.UncaughtExceptionHandler mDefaultUncaughtExceptionHandler;

        @Override
        public void uncaughtException(Thread thread, Throwable exception) {
            if (MobileCenter.this.isInstanceEnabled()) {
                final Semaphore semaphore = new Semaphore(0);
                MobileCenter.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (MobileCenter.this.mChannel != null) {
                            MobileCenter.this.mChannel.shutdown();
                        }
                        MobileCenterLog.debug(MobileCenter.LOG_TAG, "Channel completed shutdown.");
                        semaphore.release();
                    }
                });
                try {
                    if (!semaphore.tryAcquire(5000L, TimeUnit.MILLISECONDS)) {
                        MobileCenterLog.error(MobileCenter.LOG_TAG, "Timeout waiting for looper tasks to complete.");
                    }
                }
                catch (InterruptedException e) {
                    MobileCenterLog.warn(MobileCenter.LOG_TAG, "Interrupted while waiting looper to flush.", e);
                }
            }
            if (this.mDefaultUncaughtExceptionHandler != null) {
                this.mDefaultUncaughtExceptionHandler.uncaughtException(thread, exception);
            } else {
                ShutdownHelper.shutdown(10);
            }
        }

        @VisibleForTesting
        Thread.UncaughtExceptionHandler getDefaultUncaughtExceptionHandler() {
            return this.mDefaultUncaughtExceptionHandler;
        }

        void register() {
            this.mDefaultUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
            Thread.setDefaultUncaughtExceptionHandler(this);
        }

        void unregister() {
            Thread.setDefaultUncaughtExceptionHandler(this.mDefaultUncaughtExceptionHandler);
        }
    }
}

