/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile;

import android.support.annotation.VisibleForTesting;
import com.microsoft.azure.mobile.utils.MobileCenterLog;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class CustomProperties {
    @VisibleForTesting
    static final int MAX_PROPERTIES_COUNT = 60;
    @VisibleForTesting
    static final int MAX_PROPERTY_KEY_LENGTH = 128;
    @VisibleForTesting
    static final int MAX_PROPERTY_VALUE_LENGTH = 128;
    private static final Pattern KEY_PATTERN = Pattern.compile("^[a-zA-Z][a-zA-Z0-9]*$");
    private static final String VALUE_NULL_ERROR_MESSAGE = "Custom property value cannot be null, did you mean to call clear?";
    private final Map<String, Object> mProperties = new HashMap<String, Object>();

    Map<String, Object> getProperties() {
        return this.mProperties;
    }

    public CustomProperties set(String key, String value) {
        if (this.isValidKey(key) && this.isValidStringValue(key, value)) {
            this.addProperty(key, value);
        }
        return this;
    }

    public CustomProperties set(String key, Date value) {
        if (this.isValidKey(key)) {
            if (value != null) {
                this.addProperty(key, value);
            } else {
                MobileCenterLog.error("MobileCenter", VALUE_NULL_ERROR_MESSAGE);
            }
        }
        return this;
    }

    public CustomProperties set(String key, Number value) {
        if (this.isValidKey(key)) {
            if (value != null) {
                this.addProperty(key, value);
            } else {
                MobileCenterLog.error("MobileCenter", VALUE_NULL_ERROR_MESSAGE);
            }
        }
        return this;
    }

    public CustomProperties set(String key, boolean value) {
        if (this.isValidKey(key)) {
            this.addProperty(key, value);
        }
        return this;
    }

    public CustomProperties clear(String key) {
        if (this.isValidKey(key)) {
            this.addProperty(key, null);
        }
        return this;
    }

    private void addProperty(String key, Object value) {
        if (this.mProperties.containsKey(key) || this.mProperties.size() < 60) {
            this.mProperties.put(key, value);
        } else {
            MobileCenterLog.error("MobileCenter", "Custom properties cannot contain more than 60 items");
        }
    }

    private boolean isValidKey(String key) {
        if (key == null || !KEY_PATTERN.matcher(key).matches()) {
            MobileCenterLog.error("MobileCenter", "Custom property \"" + key + "\" must match \"" + KEY_PATTERN + "\"");
            return false;
        }
        if (key.length() > 128) {
            MobileCenterLog.error("MobileCenter", "Custom property \"" + key + "\" length cannot be longer than " + 128 + " characters.");
            return false;
        }
        if (this.mProperties.containsKey(key)) {
            MobileCenterLog.warn("MobileCenter", "Custom property \"" + key + "\" is already set or cleared and will be overridden.");
        }
        return true;
    }

    private boolean isValidStringValue(String key, String value) {
        if (value == null) {
            MobileCenterLog.error("MobileCenter", VALUE_NULL_ERROR_MESSAGE);
            return false;
        }
        if (value.length() > 128) {
            MobileCenterLog.error("MobileCenter", "Custom property \"" + key + "\" value length cannot be longer than " + 128 + " characters.");
            return false;
        }
        return true;
    }
}

