/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.utils.async;

import com.microsoft.azure.mobile.utils.HandlerUtils;
import com.microsoft.azure.mobile.utils.async.MobileCenterConsumer;
import com.microsoft.azure.mobile.utils.async.MobileCenterFuture;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class DefaultMobileCenterFuture<T>
implements MobileCenterFuture<T> {
    private final CountDownLatch mLatch = new CountDownLatch(1);
    private T mResult;
    private Collection<MobileCenterConsumer<T>> mConsumers;

    @Override
    public T get() {
        while (true) {
            try {
                this.mLatch.await();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        return this.mResult;
    }

    @Override
    public boolean isDone() {
        while (true) {
            try {
                return this.mLatch.await(0L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized void thenAccept(final MobileCenterConsumer<T> function) {
        if (this.isDone()) {
            HandlerUtils.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    function.accept(DefaultMobileCenterFuture.this.mResult);
                }
            });
        } else {
            if (this.mConsumers == null) {
                this.mConsumers = new LinkedList<MobileCenterConsumer<T>>();
            }
            this.mConsumers.add(function);
        }
    }

    public synchronized void complete(final T value) {
        if (!this.isDone()) {
            this.mResult = value;
            this.mLatch.countDown();
            if (this.mConsumers != null) {
                HandlerUtils.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        for (MobileCenterConsumer function : DefaultMobileCenterFuture.this.mConsumers) {
                            function.accept(value);
                        }
                        DefaultMobileCenterFuture.this.mConsumers = null;
                    }
                });
            }
        }
    }
}

