/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.utils;

import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.microsoft.azure.mobile.utils.MobileCenterLog;
import java.util.concurrent.RejectedExecutionException;

public class AsyncTaskUtils {
    @VisibleForTesting
    AsyncTaskUtils() {
    }

    @SafeVarargs
    @NonNull
    public static <Params, Type extends AsyncTask<Params, ?, ?>> Type execute(String logTag, @NonNull Type asyncTask, Params ... params) {
        try {
            return (Type)asyncTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])params);
        }
        catch (RejectedExecutionException e) {
            MobileCenterLog.warn(logTag, "THREAD_POOL_EXECUTOR saturated, fall back on SERIAL_EXECUTOR which has an unbounded queue", e);
            return (Type)asyncTask.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, (Object[])params);
        }
    }
}

