/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.ingestion.models;

import com.microsoft.azure.mobile.ingestion.models.AbstractLog;
import com.microsoft.azure.mobile.ingestion.models.json.JSONUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;

public class CustomPropertiesLog
extends AbstractLog {
    public static final String TYPE = "custom_properties";
    private static final String PROPERTIES = "properties";
    private static final String PROPERTY_TYPE = "type";
    private static final String PROPERTY_NAME = "name";
    private static final String PROPERTY_VALUE = "value";
    private static final String PROPERTY_TYPE_CLEAR = "clear";
    private static final String PROPERTY_TYPE_BOOLEAN = "boolean";
    private static final String PROPERTY_TYPE_NUMBER = "number";
    private static final String PROPERTY_TYPE_DATETIME = "date_time";
    private static final String PROPERTY_TYPE_STRING = "string";
    private static final ThreadLocal<DateFormat> DATETIME_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            return dateFormat;
        }
    };
    private Map<String, Object> properties;

    @Override
    public String getType() {
        return TYPE;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @Override
    public void read(JSONObject object) throws JSONException {
        super.read(object);
        this.setProperties(CustomPropertiesLog.readProperties(object));
    }

    @Override
    public void write(JSONStringer writer) throws JSONException {
        super.write(writer);
        CustomPropertiesLog.writeProperties(writer, this.getProperties());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CustomPropertiesLog that = (CustomPropertiesLog)o;
        return this.properties != null ? this.properties.equals(that.properties) : that.properties == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        return result;
    }

    private static Map<String, Object> readProperties(JSONObject object) throws JSONException {
        JSONArray jArray = object.getJSONArray(PROPERTIES);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (int i = 0; i < jArray.length(); ++i) {
            JSONObject jProperty = jArray.getJSONObject(i);
            String key = jProperty.getString(PROPERTY_NAME);
            Object value = CustomPropertiesLog.readPropertyValue(jProperty);
            properties.put(key, value);
        }
        return properties;
    }

    private static Object readPropertyValue(JSONObject object) throws JSONException {
        Object value;
        String type = object.getString(PROPERTY_TYPE);
        if (type.equals(PROPERTY_TYPE_CLEAR)) {
            value = null;
        } else if (type.equals(PROPERTY_TYPE_BOOLEAN)) {
            value = object.getBoolean(PROPERTY_VALUE);
        } else if (type.equals(PROPERTY_TYPE_NUMBER)) {
            value = object.get(PROPERTY_VALUE);
            if (!(value instanceof Number)) {
                throw new JSONException("Invalid value type");
            }
        } else if (type.equals(PROPERTY_TYPE_DATETIME)) {
            try {
                value = DATETIME_FORMAT.get().parse(object.getString(PROPERTY_VALUE));
            }
            catch (ParseException exception) {
                throw new JSONException("Cannot parse date");
            }
        } else if (type.equals(PROPERTY_TYPE_STRING)) {
            value = object.getString(PROPERTY_VALUE);
        } else {
            throw new JSONException("Invalid value type");
        }
        return value;
    }

    private static void writeProperties(JSONStringer writer, Map<String, Object> properties) throws JSONException {
        if (properties != null) {
            writer.key(PROPERTIES).array();
            for (Map.Entry<String, Object> property : properties.entrySet()) {
                writer.object();
                JSONUtils.write(writer, PROPERTY_NAME, property.getKey());
                CustomPropertiesLog.writePropertyValue(writer, property.getValue());
                writer.endObject();
            }
        } else {
            throw new JSONException("Properties cannot be null");
        }
        writer.endArray();
    }

    private static void writePropertyValue(JSONStringer writer, Object value) throws JSONException {
        if (value == null) {
            JSONUtils.write(writer, PROPERTY_TYPE, PROPERTY_TYPE_CLEAR);
        } else if (value instanceof Boolean) {
            JSONUtils.write(writer, PROPERTY_TYPE, PROPERTY_TYPE_BOOLEAN);
            JSONUtils.write(writer, PROPERTY_VALUE, value);
        } else if (value instanceof Number) {
            JSONUtils.write(writer, PROPERTY_TYPE, PROPERTY_TYPE_NUMBER);
            JSONUtils.write(writer, PROPERTY_VALUE, value);
        } else if (value instanceof Date) {
            JSONUtils.write(writer, PROPERTY_TYPE, PROPERTY_TYPE_DATETIME);
            JSONUtils.write(writer, PROPERTY_VALUE, DATETIME_FORMAT.get().format((Date)value));
        } else if (value instanceof String) {
            JSONUtils.write(writer, PROPERTY_TYPE, PROPERTY_TYPE_STRING);
            JSONUtils.write(writer, PROPERTY_VALUE, value);
        } else {
            throw new JSONException("Invalid value type");
        }
    }
}

