/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.http;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import java.io.IOException;

public class HttpException
extends IOException {
    private final int statusCode;
    private final String payload;

    public HttpException(int status) {
        this(status, "");
    }

    public HttpException(int status, @NonNull String payload) {
        super(HttpException.getDetailMessage(status, payload));
        this.payload = payload;
        this.statusCode = status;
    }

    @NonNull
    private static String getDetailMessage(int status, @NonNull String payload) {
        if (TextUtils.isEmpty((CharSequence)payload)) {
            return String.valueOf(status);
        }
        return status + " - " + payload;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    @NonNull
    public String getPayload() {
        return this.payload;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpException that = (HttpException)o;
        return this.statusCode == that.statusCode && this.payload.equals(that.payload);
    }

    public int hashCode() {
        int result = this.statusCode;
        result = 31 * result + this.payload.hashCode();
        return result;
    }
}

