/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.channel;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.microsoft.azure.mobile.CancellationException;
import com.microsoft.azure.mobile.channel.Channel;
import com.microsoft.azure.mobile.http.HttpUtils;
import com.microsoft.azure.mobile.http.ServiceCallback;
import com.microsoft.azure.mobile.ingestion.Ingestion;
import com.microsoft.azure.mobile.ingestion.IngestionHttp;
import com.microsoft.azure.mobile.ingestion.models.Device;
import com.microsoft.azure.mobile.ingestion.models.Log;
import com.microsoft.azure.mobile.ingestion.models.LogContainer;
import com.microsoft.azure.mobile.ingestion.models.json.LogSerializer;
import com.microsoft.azure.mobile.persistence.DatabasePersistence;
import com.microsoft.azure.mobile.persistence.Persistence;
import com.microsoft.azure.mobile.utils.DeviceInfoHelper;
import com.microsoft.azure.mobile.utils.HandlerUtils;
import com.microsoft.azure.mobile.utils.IdHelper;
import com.microsoft.azure.mobile.utils.MobileCenterLog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class DefaultChannel
implements Channel {
    @VisibleForTesting
    static final int CLEAR_BATCH_SIZE = 100;
    private final Context mContext;
    private final String mAppSecret;
    private final UUID mInstallId;
    private final Handler mIngestionHandler;
    private final Map<String, GroupState> mGroupStates;
    private final Collection<Channel.Listener> mListeners;
    private final Persistence mPersistence;
    private final Ingestion mIngestion;
    private final Handler mMobileCenterHandler;
    private boolean mEnabled;
    private boolean mDiscardLogs;
    private Device mDevice;
    private int mCurrentState;

    public DefaultChannel(@NonNull Context context, @NonNull String appSecret, @NonNull LogSerializer logSerializer, @NonNull Handler mobileCenterHandler) {
        this(context, appSecret, DefaultChannel.buildDefaultPersistence(logSerializer), new IngestionHttp(context, logSerializer), mobileCenterHandler);
    }

    @VisibleForTesting
    DefaultChannel(@NonNull Context context, @NonNull String appSecret, @NonNull Persistence persistence, @NonNull Ingestion ingestion, @NonNull Handler mobileCenterHandler) {
        this.mContext = context;
        this.mAppSecret = appSecret;
        this.mInstallId = IdHelper.getInstallId();
        this.mIngestionHandler = new Handler(Looper.getMainLooper());
        this.mGroupStates = new HashMap<String, GroupState>();
        this.mListeners = new HashSet<Channel.Listener>();
        this.mPersistence = persistence;
        this.mIngestion = ingestion;
        this.mMobileCenterHandler = mobileCenterHandler;
        this.mEnabled = true;
    }

    private static Persistence buildDefaultPersistence(@NonNull LogSerializer logSerializer) {
        DatabasePersistence persistence = new DatabasePersistence();
        persistence.setLogSerializer(logSerializer);
        return persistence;
    }

    private synchronized boolean checkStateDidNotChange(GroupState groupState, int stateSnapshot) {
        return stateSnapshot == this.mCurrentState && groupState == this.mGroupStates.get(groupState.mName);
    }

    @Override
    public synchronized void addGroup(String groupName, int maxLogsPerBatch, long batchTimeInterval, int maxParallelBatches, Channel.GroupListener groupListener) {
        MobileCenterLog.debug("MobileCenter", "addGroup(" + groupName + ")");
        GroupState groupState = new GroupState(groupName, maxLogsPerBatch, batchTimeInterval, maxParallelBatches, groupListener);
        this.mGroupStates.put(groupName, groupState);
        groupState.mPendingLogCount = this.mPersistence.countLogs(groupName);
        this.checkPendingLogs(groupState.mName);
    }

    @Override
    public synchronized void removeGroup(String groupName) {
        GroupState groupState = this.mGroupStates.remove(groupName);
        if (groupState != null) {
            this.cancelTimer(groupState);
        }
    }

    @Override
    public synchronized boolean isEnabled() {
        return this.mEnabled;
    }

    @Override
    public synchronized void setEnabled(boolean enabled) {
        if (this.mEnabled == enabled) {
            return;
        }
        if (enabled) {
            this.mEnabled = true;
            this.mDiscardLogs = false;
            ++this.mCurrentState;
            for (String groupName : this.mGroupStates.keySet()) {
                this.checkPendingLogs(groupName);
            }
        } else {
            this.suspend(true, new CancellationException());
        }
    }

    @Override
    public void setLogUrl(String logUrl) {
        this.mIngestion.setLogUrl(logUrl);
    }

    @Override
    public synchronized void clear(String groupName) {
        this.mPersistence.deleteLogs(groupName);
    }

    @Override
    public synchronized void invalidateDeviceCache() {
        this.mDevice = null;
    }

    private void suspend(boolean deleteLogs, Exception exception) {
        this.mEnabled = false;
        this.mDiscardLogs = deleteLogs;
        ++this.mCurrentState;
        for (GroupState groupState : this.mGroupStates.values()) {
            this.cancelTimer(groupState);
            Iterator<Map.Entry<String, List<Log>>> iterator = groupState.mSendingBatches.entrySet().iterator();
            while (iterator.hasNext()) {
                Channel.GroupListener groupListener;
                Map.Entry<String, List<Log>> entry = iterator.next();
                List<Log> removedLogsForBatchId = groupState.mSendingBatches.get(entry.getKey());
                iterator.remove();
                if (!deleteLogs || (groupListener = groupState.mListener) == null) continue;
                for (Log log : removedLogsForBatchId) {
                    groupListener.onFailure(log, exception);
                }
            }
        }
        try {
            this.mIngestion.close();
        }
        catch (IOException e) {
            MobileCenterLog.error("MobileCenter", "Failed to close ingestion", e);
        }
        if (deleteLogs) {
            for (GroupState groupState : this.mGroupStates.values()) {
                this.deleteLogsOnSuspended(groupState);
            }
        } else {
            this.mPersistence.clearPendingLogState();
        }
    }

    private void deleteLogsOnSuspended(GroupState groupState) {
        ArrayList<Log> logs = new ArrayList<Log>();
        this.mPersistence.getLogs(groupState.mName, 100, logs);
        if (logs.size() > 0 && groupState.mListener != null) {
            for (Log log : logs) {
                groupState.mListener.onBeforeSending(log);
                groupState.mListener.onFailure(log, new CancellationException());
            }
        }
        if (logs.size() >= 100 && groupState.mListener != null) {
            this.deleteLogsOnSuspended(groupState);
        } else {
            this.mPersistence.deleteLogs(groupState.mName);
        }
    }

    private void cancelTimer(GroupState groupState) {
        if (groupState.mScheduled) {
            groupState.mScheduled = false;
            this.mIngestionHandler.removeCallbacks(groupState.mRunnable);
        }
    }

    @VisibleForTesting
    synchronized int getCounter(@NonNull String groupName) {
        return this.mGroupStates.get((Object)groupName).mPendingLogCount;
    }

    private synchronized void triggerIngestion(@NonNull String groupName) {
        if (!this.mEnabled) {
            return;
        }
        final GroupState groupState = this.mGroupStates.get(groupName);
        MobileCenterLog.debug("MobileCenter", "triggerIngestion(" + groupName + ") pendingLogCount=" + groupState.mPendingLogCount);
        this.cancelTimer(groupState);
        if (groupState.mSendingBatches.size() == groupState.mMaxParallelBatches) {
            MobileCenterLog.debug("MobileCenter", "Already sending " + groupState.mMaxParallelBatches + " batches of analytics data to the server.");
            return;
        }
        final ArrayList<Log> batch = new ArrayList<Log>(groupState.mMaxLogsPerBatch);
        final int stateSnapshot = this.mCurrentState;
        final String batchId = this.mPersistence.getLogs(groupName, groupState.mMaxLogsPerBatch, batch);
        if (batchId == null) {
            return;
        }
        if (groupState.mListener != null) {
            for (Log log : batch) {
                groupState.mListener.onBeforeSending(log);
            }
        }
        groupState.mPendingLogCount -= batch.size();
        MobileCenterLog.debug("MobileCenter", "ingestLogs(" + groupState.mName + "," + batchId + ") pendingLogCount=" + groupState.mPendingLogCount);
        groupState.mSendingBatches.put(batchId, batch);
        HandlerUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                DefaultChannel.this.sendLogs(groupState, stateSnapshot, batch, batchId);
            }
        });
    }

    @MainThread
    private synchronized void sendLogs(final GroupState groupState, final int currentState, List<Log> batch, final String batchId) {
        if (this.checkStateDidNotChange(groupState, currentState)) {
            LogContainer logContainer = new LogContainer();
            logContainer.setLogs(batch);
            this.mIngestion.sendAsync(this.mAppSecret, this.mInstallId, logContainer, new ServiceCallback(){

                @Override
                public void onCallSucceeded(String payload) {
                    DefaultChannel.this.mMobileCenterHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            DefaultChannel.this.handleSendingSuccess(groupState, currentState, batchId);
                        }
                    });
                }

                @Override
                public void onCallFailed(final Exception e) {
                    DefaultChannel.this.mMobileCenterHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            DefaultChannel.this.handleSendingFailure(groupState, currentState, batchId, e);
                        }
                    });
                }
            });
            this.mMobileCenterHandler.post(new Runnable(){

                @Override
                public void run() {
                    DefaultChannel.this.checkPendingLogsAfterPost(groupState, currentState);
                }
            });
        }
    }

    private void checkPendingLogsAfterPost(@NonNull GroupState groupState, int currentState) {
        if (this.checkStateDidNotChange(groupState, currentState)) {
            this.checkPendingLogs(groupState.mName);
        }
    }

    private synchronized void handleSendingSuccess(@NonNull GroupState groupState, int currentState, @NonNull String batchId) {
        if (this.checkStateDidNotChange(groupState, currentState)) {
            String groupName = groupState.mName;
            this.mPersistence.deleteLogs(groupName, batchId);
            List<Log> removedLogsForBatchId = groupState.mSendingBatches.remove(batchId);
            Channel.GroupListener groupListener = groupState.mListener;
            if (groupListener != null) {
                for (Log log : removedLogsForBatchId) {
                    groupListener.onSuccess(log);
                }
            }
            this.checkPendingLogs(groupName);
        }
    }

    private synchronized void handleSendingFailure(@NonNull GroupState groupState, int currentState, @NonNull String batchId, @NonNull Exception e) {
        if (this.checkStateDidNotChange(groupState, currentState)) {
            String groupName = groupState.mName;
            MobileCenterLog.error("MobileCenter", "Sending logs groupName=" + groupName + " id=" + batchId + " failed", e);
            List<Log> removedLogsForBatchId = groupState.mSendingBatches.remove(batchId);
            boolean recoverableError = HttpUtils.isRecoverableError(e);
            if (recoverableError) {
                groupState.mPendingLogCount += removedLogsForBatchId.size();
            } else {
                Channel.GroupListener groupListener = groupState.mListener;
                if (groupListener != null) {
                    for (Log log : removedLogsForBatchId) {
                        groupListener.onFailure(log, e);
                    }
                }
            }
            this.suspend(!recoverableError, e);
        }
    }

    @Override
    public synchronized void enqueue(@NonNull Log log, @NonNull String groupName) {
        GroupState groupState = this.mGroupStates.get(groupName);
        if (groupState == null) {
            MobileCenterLog.error("MobileCenter", "Invalid group name:" + groupName);
            return;
        }
        if (this.mDiscardLogs) {
            MobileCenterLog.warn("MobileCenter", "Channel is disabled, log are discarded.");
            if (groupState.mListener != null) {
                groupState.mListener.onBeforeSending(log);
                groupState.mListener.onFailure(log, new CancellationException());
            }
            return;
        }
        for (Channel.Listener listener : this.mListeners) {
            listener.onEnqueuingLog(log, groupName);
        }
        if (log.getDevice() == null) {
            if (this.mDevice == null) {
                try {
                    this.mDevice = DeviceInfoHelper.getDeviceInfo(this.mContext);
                }
                catch (DeviceInfoHelper.DeviceInfoException e) {
                    MobileCenterLog.error("MobileCenter", "Device log cannot be generated", e);
                    return;
                }
            }
            log.setDevice(this.mDevice);
        }
        if (log.getToffset() == 0L) {
            log.setToffset(System.currentTimeMillis());
        }
        try {
            this.mPersistence.putLog(groupName, log);
            ++groupState.mPendingLogCount;
            MobileCenterLog.debug("MobileCenter", "enqueue(" + groupState.mName + ") pendingLogCount=" + groupState.mPendingLogCount);
            if (this.mEnabled) {
                this.checkPendingLogs(groupState.mName);
            } else {
                MobileCenterLog.warn("MobileCenter", "Channel is temporarily disabled, log was saved to disk.");
            }
        }
        catch (Persistence.PersistenceException e) {
            MobileCenterLog.error("MobileCenter", "Error persisting log with exception: " + e.toString());
        }
    }

    private synchronized void checkPendingLogs(@NonNull String groupName) {
        GroupState groupState = this.mGroupStates.get(groupName);
        long pendingLogCount = groupState.mPendingLogCount;
        MobileCenterLog.debug("MobileCenter", "checkPendingLogs(" + groupName + ") pendingLogCount=" + pendingLogCount);
        if (pendingLogCount >= (long)groupState.mMaxLogsPerBatch) {
            this.triggerIngestion(groupName);
        } else if (pendingLogCount > 0L && !groupState.mScheduled) {
            groupState.mScheduled = true;
            this.mIngestionHandler.postDelayed(groupState.mRunnable, groupState.mBatchTimeInterval);
        }
    }

    @Override
    public synchronized void addListener(Channel.Listener listener) {
        this.mListeners.add(listener);
    }

    @Override
    public synchronized void removeListener(Channel.Listener listener) {
        this.mListeners.remove(listener);
    }

    @Override
    public synchronized void shutdown() {
        this.suspend(false, new CancellationException());
    }

    private class GroupState {
        final String mName;
        final int mMaxLogsPerBatch;
        final long mBatchTimeInterval;
        final int mMaxParallelBatches;
        final Map<String, List<Log>> mSendingBatches = new HashMap<String, List<Log>>();
        final Channel.GroupListener mListener;
        int mPendingLogCount;
        boolean mScheduled;
        final Runnable mRunnable = new Runnable(){

            @Override
            public void run() {
                GroupState.this.mScheduled = false;
                DefaultChannel.this.mMobileCenterHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        DefaultChannel.this.triggerIngestion(GroupState.this.mName);
                    }
                });
            }
        };

        GroupState(String name, int maxLogsPerBatch, long batchTimeInterval, int maxParallelBatches, Channel.GroupListener listener) {
            this.mName = name;
            this.mMaxLogsPerBatch = maxLogsPerBatch;
            this.mBatchTimeInterval = batchTimeInterval;
            this.mMaxParallelBatches = maxParallelBatches;
            this.mListener = listener;
        }
    }
}

