/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile;

import android.content.Context;
import com.microsoft.azure.mobile.utils.MobileCenterLog;
import java.io.File;

public class Constants {
    public static final int DEFAULT_TRIGGER_INTERVAL = 3000;
    static final int DEFAULT_TRIGGER_COUNT = 50;
    static final int DEFAULT_TRIGGER_MAX_PARALLEL_REQUESTS = 3;
    public static String FILES_PATH = null;
    public static boolean APPLICATION_DEBUGGABLE = false;

    public static void loadFromContext(Context context) {
        Constants.loadFilesPath(context);
        Constants.setDebuggableFlag(context);
    }

    private static void loadFilesPath(Context context) {
        if (context != null) {
            try {
                File file = context.getFilesDir();
                FILES_PATH = file.getAbsolutePath();
            }
            catch (Exception e) {
                MobileCenterLog.error("MobileCenter", "Exception thrown when accessing the application filesystem", e);
            }
        }
    }

    private static void setDebuggableFlag(Context context) {
        if (context != null && context.getApplicationInfo() != null) {
            APPLICATION_DEBUGGABLE = (context.getApplicationInfo().flags & 2) > 0;
        }
    }
}

