/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.push;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.messaging.RemoteMessage;
import com.microsoft.azure.mobile.AbstractMobileCenterService;
import com.microsoft.azure.mobile.channel.Channel;
import com.microsoft.azure.mobile.ingestion.models.Log;
import com.microsoft.azure.mobile.ingestion.models.json.LogFactory;
import com.microsoft.azure.mobile.push.FirebaseAnalyticsUtils;
import com.microsoft.azure.mobile.push.PushListener;
import com.microsoft.azure.mobile.push.PushNotification;
import com.microsoft.azure.mobile.push.ingestion.models.PushInstallationLog;
import com.microsoft.azure.mobile.push.ingestion.models.json.PushInstallationLogFactory;
import com.microsoft.azure.mobile.utils.HandlerUtils;
import com.microsoft.azure.mobile.utils.MobileCenterLog;
import com.microsoft.azure.mobile.utils.storage.StorageHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Push
extends AbstractMobileCenterService {
    @VisibleForTesting
    static final String EXTRA_GOOGLE_MESSAGE_ID = "google.message_id";
    @VisibleForTesting
    static final Set<String> EXTRA_STANDARD_KEYS = new HashSet<String>(){
        {
            this.add(Push.EXTRA_GOOGLE_MESSAGE_ID);
            this.add("google.sent_time");
            this.add("collapse_key");
            this.add("from");
        }
    };
    private static final String SERVICE_NAME = "Push";
    private static final String LOG_TAG = "MobileCenterPush";
    private static final String PUSH_GROUP = "group_push";
    private static final String PREFERENCE_PREFIX = "Push.";
    @VisibleForTesting
    static final String PREFERENCE_KEY_PUSH_TOKEN = "Push.push_token";
    private static boolean sFirebaseAnalyticsEnabled;
    @SuppressLint(value={"StaticFieldLeak"})
    private static Push sInstance;
    private final Map<String, LogFactory> mFactories = new HashMap<String, LogFactory>();
    private String mPushToken;
    private PushListener mInstanceListener;
    private String mLastGoogleMessageId;
    private Activity mActivity;

    private Push() {
        this.mFactories.put("push_installation", new PushInstallationLogFactory());
    }

    public static synchronized Push getInstance() {
        if (sInstance == null) {
            sInstance = new Push();
        }
        return sInstance;
    }

    @VisibleForTesting
    static synchronized void unsetInstance() {
        sInstance = null;
    }

    public static boolean isEnabled() {
        return Push.getInstance().isInstanceEnabled();
    }

    public static void setEnabled(boolean enabled) {
        Push.getInstance().setInstanceEnabled(enabled);
    }

    public static void setListener(PushListener pushListener) {
        Push.getInstance().setInstanceListener(pushListener);
    }

    public static void enableFirebaseAnalytics(@NonNull Context context) {
        MobileCenterLog.debug((String)LOG_TAG, (String)"Enabling firebase analytics collection.");
        Push.setFirebaseAnalyticsEnabled(context, true);
    }

    private static void setFirebaseAnalyticsEnabled(@NonNull Context context, boolean enabled) {
        FirebaseAnalyticsUtils.setEnabled(context, enabled);
        sFirebaseAnalyticsEnabled = enabled;
    }

    private void enqueuePushInstallationLog(@NonNull String pushToken) {
        PushInstallationLog log = new PushInstallationLog();
        log.setPushToken(pushToken);
        this.mChannel.enqueue((Log)log, PUSH_GROUP);
    }

    synchronized void onTokenRefresh(@NonNull String pushToken) {
        if (this.isInactive()) {
            return;
        }
        if (this.mPushToken != null && this.mPushToken.equals(pushToken)) {
            return;
        }
        MobileCenterLog.debug((String)LOG_TAG, (String)("Push token: " + pushToken));
        StorageHelper.PreferencesStorage.putString((String)PREFERENCE_KEY_PUSH_TOKEN, (String)pushToken);
        this.enqueuePushInstallationLog(pushToken);
        this.mPushToken = pushToken;
    }

    private synchronized void applyEnabledState(boolean enabled) {
        if (enabled && this.mChannel != null) {
            String token = FirebaseInstanceId.getInstance().getToken();
            if (token != null) {
                this.onTokenRefresh(token);
            }
        } else {
            this.mPushToken = null;
        }
    }

    protected String getGroupName() {
        return PUSH_GROUP;
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    protected String getLoggerTag() {
        return LOG_TAG;
    }

    protected int getTriggerCount() {
        return 1;
    }

    public Map<String, LogFactory> getLogFactories() {
        return this.mFactories;
    }

    public synchronized void onStarted(@NonNull Context context, @NonNull String appSecret, @NonNull Channel channel) {
        super.onStarted(context, appSecret, channel);
        this.applyEnabledState(this.isInstanceEnabled());
        if (!sFirebaseAnalyticsEnabled) {
            MobileCenterLog.debug((String)LOG_TAG, (String)"Disabling firebase analytics collection by default.");
            Push.setFirebaseAnalyticsEnabled(context, false);
        }
    }

    public synchronized void setInstanceEnabled(boolean enabled) {
        super.setInstanceEnabled(enabled);
        this.applyEnabledState(enabled);
    }

    private synchronized void setInstanceListener(PushListener instanceListener) {
        this.mInstanceListener = instanceListener;
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        this.checkPushInActivityIntent(activity);
    }

    public void onActivityStarted(Activity activity) {
        this.checkPushInActivityIntent(activity);
    }

    public void onActivityResumed(Activity activity) {
        this.checkPushInActivityIntent(activity);
    }

    public void onActivityPaused(Activity activity) {
        this.mActivity = null;
    }

    private synchronized void checkPushInActivityIntent(Activity activity) {
        String googleMessageId;
        Bundle extras;
        this.mActivity = activity;
        if (Push.isEnabled() && this.mInstanceListener != null && (extras = activity.getIntent().getExtras()) != null && (googleMessageId = extras.getString(EXTRA_GOOGLE_MESSAGE_ID)) != null && !googleMessageId.equals(this.mLastGoogleMessageId)) {
            MobileCenterLog.info((String)LOG_TAG, (String)("Clicked push message from background id=" + googleMessageId));
            this.mLastGoogleMessageId = googleMessageId;
            HashMap<String, String> customData = new HashMap<String, String>();
            HashMap<String, Object> allData = new HashMap<String, Object>();
            for (String extra : extras.keySet()) {
                allData.put(extra, extras.get(extra));
                if (EXTRA_STANDARD_KEYS.contains(extra)) continue;
                customData.put(extra, extras.getString(extra));
            }
            MobileCenterLog.debug((String)LOG_TAG, (String)("Push intent extra=" + allData));
            this.mInstanceListener.onPushNotificationReceived(activity, new PushNotification(null, null, customData));
        }
    }

    synchronized void onMessageReceived(RemoteMessage remoteMessage) {
        MobileCenterLog.info((String)LOG_TAG, (String)("Received push message in foreground id=" + remoteMessage.getMessageId()));
        if (Push.isEnabled() && this.mInstanceListener != null) {
            String title = null;
            String message = null;
            RemoteMessage.Notification notification = remoteMessage.getNotification();
            if (notification != null) {
                title = notification.getTitle();
                message = notification.getBody();
            }
            final PushNotification pushNotification = new PushNotification(title, message, remoteMessage.getData());
            HandlerUtils.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    Push.this.deliverForegroundPushNotification(pushNotification);
                }
            });
        }
    }

    private synchronized void deliverForegroundPushNotification(PushNotification pushNotification) {
        if (Push.isEnabled() && this.mInstanceListener != null) {
            this.mInstanceListener.onPushNotificationReceived(this.mActivity, pushNotification);
        }
    }
}

