/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.crashes.utils;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.os.Process;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.microsoft.azure.mobile.Constants;
import com.microsoft.azure.mobile.crashes.ingestion.models.Exception;
import com.microsoft.azure.mobile.crashes.ingestion.models.ManagedErrorLog;
import com.microsoft.azure.mobile.crashes.ingestion.models.StackFrame;
import com.microsoft.azure.mobile.crashes.model.ErrorReport;
import com.microsoft.azure.mobile.utils.DeviceInfoHelper;
import com.microsoft.azure.mobile.utils.MobileCenterLog;
import com.microsoft.azure.mobile.utils.UUIDUtils;
import com.microsoft.azure.mobile.utils.storage.StorageHelper;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ErrorLogHelper {
    public static final String ERROR_LOG_FILE_EXTENSION = ".json";
    public static final String THROWABLE_FILE_EXTENSION = ".throwable";
    @VisibleForTesting
    public static final int FRAME_LIMIT = 256;
    @VisibleForTesting
    static final String ERROR_DIRECTORY = "error";
    private static final int FRAME_LIMIT_HALF = 128;
    private static File sErrorLogDirectory;

    @NonNull
    public static ManagedErrorLog createErrorLog(@NonNull Context context, @NonNull Thread thread, @NonNull Throwable throwable, @NonNull Map<Thread, StackTraceElement[]> allStackTraces, long initializeTimestamp, boolean fatal) {
        return ErrorLogHelper.createErrorLog(context, thread, ErrorLogHelper.getModelExceptionFromThrowable(throwable), allStackTraces, initializeTimestamp, fatal);
    }

    @NonNull
    public static ManagedErrorLog createErrorLog(@NonNull Context context, @NonNull Thread thread, @NonNull Exception exception, @NonNull Map<Thread, StackTraceElement[]> allStackTraces, long initializeTimestamp, boolean fatal) {
        ManagedErrorLog errorLog = new ManagedErrorLog();
        errorLog.setId(UUIDUtils.randomUUID());
        errorLog.setToffset(System.currentTimeMillis());
        try {
            errorLog.setDevice(DeviceInfoHelper.getDeviceInfo((Context)context));
        }
        catch (DeviceInfoHelper.DeviceInfoException e) {
            MobileCenterLog.error((String)"MobileCenterCrashes", (String)"Could not attach device properties snapshot to error log, will attach at sending time", (Throwable)e);
        }
        errorLog.setProcessId(Process.myPid());
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        if (activityManager != null) {
            for (ActivityManager.RunningAppProcessInfo info : activityManager.getRunningAppProcesses()) {
                if (info.pid != Process.myPid()) continue;
                errorLog.setProcessName(info.processName);
            }
        }
        errorLog.setArchitecture(ErrorLogHelper.getArchitecture());
        errorLog.setErrorThreadId(thread.getId());
        errorLog.setErrorThreadName(thread.getName());
        errorLog.setFatal(fatal);
        errorLog.setAppLaunchTOffset(SystemClock.elapsedRealtime() - initializeTimestamp);
        errorLog.setException(exception);
        ArrayList<com.microsoft.azure.mobile.crashes.ingestion.models.Thread> threads = new ArrayList<com.microsoft.azure.mobile.crashes.ingestion.models.Thread>(allStackTraces.size());
        for (Map.Entry<Thread, StackTraceElement[]> entry : allStackTraces.entrySet()) {
            com.microsoft.azure.mobile.crashes.ingestion.models.Thread javaThread = new com.microsoft.azure.mobile.crashes.ingestion.models.Thread();
            javaThread.setId(entry.getKey().getId());
            javaThread.setName(entry.getKey().getName());
            javaThread.setFrames(ErrorLogHelper.getModelFramesFromStackTrace(entry.getValue()));
            threads.add(javaThread);
        }
        errorLog.setThreads(threads);
        return errorLog;
    }

    @TargetApi(value=21)
    private static String getArchitecture() {
        if (Build.VERSION.SDK_INT >= 21) {
            return Build.SUPPORTED_ABIS[0];
        }
        return Build.CPU_ABI;
    }

    @NonNull
    public static File getErrorStorageDirectory() {
        if (sErrorLogDirectory == null) {
            sErrorLogDirectory = new File(Constants.FILES_PATH, ERROR_DIRECTORY);
            StorageHelper.InternalStorage.mkdir((String)sErrorLogDirectory.getAbsolutePath());
        }
        return sErrorLogDirectory;
    }

    @NonNull
    public static File[] getStoredErrorLogFiles() {
        File[] files = ErrorLogHelper.getErrorStorageDirectory().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(ErrorLogHelper.ERROR_LOG_FILE_EXTENSION);
            }
        });
        return files != null && files.length > 0 ? files : new File[]{};
    }

    @Nullable
    public static File getLastErrorLogFile() {
        return StorageHelper.InternalStorage.lastModifiedFile((File)ErrorLogHelper.getErrorStorageDirectory(), (FilenameFilter)new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(ErrorLogHelper.ERROR_LOG_FILE_EXTENSION);
            }
        });
    }

    @Nullable
    public static File getStoredThrowableFile(@NonNull UUID id) {
        return ErrorLogHelper.getStoredFile(id, THROWABLE_FILE_EXTENSION);
    }

    public static void removeStoredThrowableFile(@NonNull UUID id) {
        File file = ErrorLogHelper.getStoredThrowableFile(id);
        if (file != null) {
            MobileCenterLog.info((String)"MobileCenterCrashes", (String)("Deleting throwable file " + file.getName()));
            StorageHelper.InternalStorage.delete((File)file);
        }
    }

    @Nullable
    static File getStoredErrorLogFile(@NonNull UUID id) {
        return ErrorLogHelper.getStoredFile(id, ERROR_LOG_FILE_EXTENSION);
    }

    public static void removeStoredErrorLogFile(@NonNull UUID id) {
        File file = ErrorLogHelper.getStoredErrorLogFile(id);
        if (file != null) {
            MobileCenterLog.info((String)"MobileCenterCrashes", (String)("Deleting error log file " + file.getName()));
            StorageHelper.InternalStorage.delete((File)file);
        }
    }

    @NonNull
    public static ErrorReport getErrorReportFromErrorLog(@NonNull ManagedErrorLog log, Throwable throwable) {
        ErrorReport report = new ErrorReport();
        report.setId(log.getId().toString());
        report.setThreadName(log.getErrorThreadName());
        report.setThrowable(throwable);
        report.setAppStartTime(new Date(log.getToffset() - log.getAppLaunchTOffset()));
        report.setAppErrorTime(new Date(log.getToffset()));
        report.setDevice(log.getDevice());
        return report;
    }

    @VisibleForTesting
    static void setErrorLogDirectory(File file) {
        sErrorLogDirectory = file;
    }

    @Nullable
    private static File getStoredFile(final @NonNull UUID id, final @NonNull String extension) {
        File[] files = ErrorLogHelper.getErrorStorageDirectory().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.startsWith(id.toString()) && filename.endsWith(extension);
            }
        });
        return files != null && files.length > 0 ? files[0] : null;
    }

    @NonNull
    private static Exception getModelExceptionFromThrowable(@NonNull Throwable t) {
        Exception topException = null;
        Exception parentException = null;
        for (Throwable cause = t; cause != null; cause = cause.getCause()) {
            Exception exception = new Exception();
            exception.setType(cause.getClass().getName());
            exception.setMessage(cause.getMessage());
            exception.setFrames(ErrorLogHelper.getModelFramesFromStackTrace(cause));
            if (topException == null) {
                topException = exception;
            } else {
                parentException.setInnerExceptions(Collections.singletonList(exception));
            }
            parentException = exception;
        }
        return topException;
    }

    @NonNull
    private static List<StackFrame> getModelFramesFromStackTrace(@NonNull Throwable throwable) {
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        if (stackTrace.length > 256) {
            StackTraceElement[] stackTraceTruncated = new StackTraceElement[256];
            System.arraycopy(stackTrace, 0, stackTraceTruncated, 0, 128);
            System.arraycopy(stackTrace, stackTrace.length - 128, stackTraceTruncated, 128, 128);
            throwable.setStackTrace(stackTraceTruncated);
            MobileCenterLog.warn((String)"MobileCenterCrashes", (String)("Crash frames truncated from " + stackTrace.length + " to " + stackTraceTruncated.length + " frames."));
            stackTrace = stackTraceTruncated;
        }
        return ErrorLogHelper.getModelFramesFromStackTrace(stackTrace);
    }

    @NonNull
    private static List<StackFrame> getModelFramesFromStackTrace(@NonNull StackTraceElement[] stackTrace) {
        ArrayList<StackFrame> stackFrames = new ArrayList<StackFrame>();
        for (StackTraceElement stackTraceElement : stackTrace) {
            stackFrames.add(ErrorLogHelper.getModelStackFrame(stackTraceElement));
        }
        return stackFrames;
    }

    @NonNull
    private static StackFrame getModelStackFrame(StackTraceElement stackTraceElement) {
        StackFrame stackFrame = new StackFrame();
        stackFrame.setClassName(stackTraceElement.getClassName());
        stackFrame.setMethodName(stackTraceElement.getMethodName());
        stackFrame.setLineNumber(stackTraceElement.getLineNumber());
        stackFrame.setFileName(stackTraceElement.getFileName());
        return stackFrame;
    }
}

