/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.crashes.model;

import android.util.Base64;
import com.microsoft.azure.mobile.ingestion.models.Model;
import com.microsoft.azure.mobile.ingestion.models.json.JSONUtils;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;

public class ErrorBinaryAttachment
implements Model {
    private static final String CONTENT_TYPE = "content_type";
    private static final String FILE_NAME = "file_name";
    private static final String DATA = "data";
    private String contentType;
    private String fileName;
    private byte[] data;

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void read(JSONObject object) throws JSONException {
        this.setContentType(object.getString(CONTENT_TYPE));
        this.setFileName(object.optString(FILE_NAME, null));
        if (object.optString(DATA, null) == null) {
            this.setData(null);
        } else {
            this.setData(Base64.decode((String)object.getString(DATA), (int)0));
        }
    }

    public void write(JSONStringer writer) throws JSONException {
        writer.key(CONTENT_TYPE).value((Object)this.getContentType());
        JSONUtils.write((JSONStringer)writer, (String)FILE_NAME, (Object)this.getFileName());
        if (this.getData() != null) {
            JSONUtils.write((JSONStringer)writer, (String)DATA, (Object)Base64.encodeToString((byte[])this.getData(), (int)2));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorBinaryAttachment that = (ErrorBinaryAttachment)o;
        if (this.contentType != null ? !this.contentType.equals(that.contentType) : that.contentType != null) {
            return false;
        }
        if (this.fileName != null ? !this.fileName.equals(that.fileName) : that.fileName != null) {
            return false;
        }
        return Arrays.equals(this.data, that.data);
    }

    public int hashCode() {
        int result = this.contentType != null ? this.contentType.hashCode() : 0;
        result = 31 * result + (this.fileName != null ? this.fileName.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }
}

