/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.crashes;

import android.support.annotation.VisibleForTesting;
import com.microsoft.azure.mobile.crashes.Crashes;
import com.microsoft.azure.mobile.utils.ShutdownHelper;

class UncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private boolean mIgnoreDefaultExceptionHandler = false;
    private Thread.UncaughtExceptionHandler mDefaultUncaughtExceptionHandler;

    UncaughtExceptionHandler() {
    }

    @Override
    public void uncaughtException(Thread thread, Throwable exception) {
        if (!Crashes.isEnabled()) {
            if (this.mDefaultUncaughtExceptionHandler != null) {
                this.mDefaultUncaughtExceptionHandler.uncaughtException(thread, exception);
            }
        } else {
            Crashes.getInstance().saveUncaughtException(thread, exception);
            if (this.mDefaultUncaughtExceptionHandler != null) {
                this.mDefaultUncaughtExceptionHandler.uncaughtException(thread, exception);
            } else {
                ShutdownHelper.shutdown((int)10);
            }
        }
    }

    @VisibleForTesting
    void setIgnoreDefaultExceptionHandler(boolean ignoreDefaultExceptionHandler) {
        this.mIgnoreDefaultExceptionHandler = ignoreDefaultExceptionHandler;
        if (ignoreDefaultExceptionHandler) {
            this.mDefaultUncaughtExceptionHandler = null;
        }
    }

    @VisibleForTesting
    Thread.UncaughtExceptionHandler getDefaultUncaughtExceptionHandler() {
        return this.mDefaultUncaughtExceptionHandler;
    }

    void register() {
        this.mDefaultUncaughtExceptionHandler = !this.mIgnoreDefaultExceptionHandler ? Thread.getDefaultUncaughtExceptionHandler() : null;
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    void unregister() {
        Thread.setDefaultUncaughtExceptionHandler(this.mDefaultUncaughtExceptionHandler);
    }
}

