/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.crashes;

import android.support.annotation.VisibleForTesting;
import com.microsoft.azure.mobile.crashes.model.ErrorAttachment;
import com.microsoft.azure.mobile.crashes.model.ErrorBinaryAttachment;
import com.microsoft.azure.mobile.utils.MobileCenterLog;

final class ErrorAttachments {
    @VisibleForTesting
    ErrorAttachments() {
    }

    public static ErrorAttachment attachmentWithText(String text) {
        return ErrorAttachments.attachment(text, null, null, null);
    }

    public static ErrorAttachment attachmentWithBinary(byte[] data, String fileName, String contentType) {
        return ErrorAttachments.attachment(null, data, fileName, contentType);
    }

    public static ErrorAttachment attachment(String text, byte[] data, String fileName, String contentType) {
        if (text == null && data == null) {
            MobileCenterLog.warn((String)"MobileCenter", (String)"Null content passed to attachment method, returning null");
            return null;
        }
        ErrorAttachment attachment = new ErrorAttachment();
        attachment.setTextAttachment(text);
        if (data != null) {
            ErrorBinaryAttachment binaryAttachment = new ErrorBinaryAttachment();
            binaryAttachment.setData(data);
            binaryAttachment.setFileName(fileName);
            binaryAttachment.setContentType(contentType);
            attachment.setBinaryAttachment(binaryAttachment);
        } else if (fileName != null || contentType != null) {
            MobileCenterLog.warn((String)"MobileCenter", (String)"Binary attachment file name and content ignored as data is null");
        }
        return attachment;
    }
}

