/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.crashes;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.annotation.WorkerThread;
import com.microsoft.azure.mobile.AbstractMobileCenterService;
import com.microsoft.azure.mobile.Constants;
import com.microsoft.azure.mobile.ResultCallback;
import com.microsoft.azure.mobile.channel.Channel;
import com.microsoft.azure.mobile.crashes.AbstractCrashesListener;
import com.microsoft.azure.mobile.crashes.CrashesListener;
import com.microsoft.azure.mobile.crashes.UncaughtExceptionHandler;
import com.microsoft.azure.mobile.crashes.WrapperSdkExceptionManager;
import com.microsoft.azure.mobile.crashes.ingestion.models.Exception;
import com.microsoft.azure.mobile.crashes.ingestion.models.ManagedErrorLog;
import com.microsoft.azure.mobile.crashes.ingestion.models.json.ManagedErrorLogFactory;
import com.microsoft.azure.mobile.crashes.model.ErrorReport;
import com.microsoft.azure.mobile.crashes.model.TestCrashException;
import com.microsoft.azure.mobile.crashes.utils.ErrorLogHelper;
import com.microsoft.azure.mobile.ingestion.models.Log;
import com.microsoft.azure.mobile.ingestion.models.json.DefaultLogSerializer;
import com.microsoft.azure.mobile.ingestion.models.json.LogFactory;
import com.microsoft.azure.mobile.ingestion.models.json.LogSerializer;
import com.microsoft.azure.mobile.utils.HandlerUtils;
import com.microsoft.azure.mobile.utils.MobileCenterLog;
import com.microsoft.azure.mobile.utils.storage.StorageHelper;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import org.json.JSONException;

public class Crashes
extends AbstractMobileCenterService {
    public static final int SEND = 0;
    public static final int DONT_SEND = 1;
    public static final int ALWAYS_SEND = 2;
    @VisibleForTesting
    public static final String PREF_KEY_ALWAYS_SEND = "com.microsoft.azure.mobile.crashes.always.send";
    @VisibleForTesting
    static final String ERROR_GROUP = "group_errors";
    private static final String THREAD_NAME = "CrashesThread";
    private static final String SERVICE_NAME = "Crashes";
    public static final String LOG_TAG = "MobileCenterCrashes";
    private static final CrashesListener DEFAULT_ERROR_REPORTING_LISTENER = new DefaultCrashesListener();
    @SuppressLint(value={"StaticFieldLeak"})
    private static Crashes sInstance = null;
    private final Handler mHandler;
    private final Map<String, LogFactory> mFactories;
    private final Map<UUID, ErrorLogReport> mUnprocessedErrorReports;
    private final Map<UUID, ErrorLogReport> mErrorReportCache;
    private final List<ResultCallback<ErrorReport>> mLastCrashErrorReportCallbacks = new ArrayList<ResultCallback<ErrorReport>>();
    private CountDownLatch mCountDownLatch;
    private LogSerializer mLogSerializer;
    private Context mContext;
    private long mInitializeTimestamp;
    private UncaughtExceptionHandler mUncaughtExceptionHandler;
    private CrashesListener mCrashesListener;
    private WrapperSdkListener mWrapperSdkListener;
    private ErrorReport mLastSessionErrorReport;

    private Crashes() {
        this.mFactories = new HashMap<String, LogFactory>();
        this.mFactories.put("managed_error", ManagedErrorLogFactory.getInstance());
        this.mLogSerializer = new DefaultLogSerializer();
        this.mLogSerializer.addLogFactory("managed_error", (LogFactory)ManagedErrorLogFactory.getInstance());
        this.mCrashesListener = DEFAULT_ERROR_REPORTING_LISTENER;
        this.mUnprocessedErrorReports = new LinkedHashMap<UUID, ErrorLogReport>();
        this.mErrorReportCache = new LinkedHashMap<UUID, ErrorLogReport>();
        HandlerThread thread = new HandlerThread(THREAD_NAME);
        thread.start();
        this.mHandler = new Handler(thread.getLooper());
    }

    @NonNull
    public static synchronized Crashes getInstance() {
        if (sInstance == null) {
            sInstance = new Crashes();
        }
        return sInstance;
    }

    @VisibleForTesting
    static synchronized void unsetInstance() {
        sInstance = null;
    }

    public static boolean isEnabled() {
        return Crashes.getInstance().isInstanceEnabled();
    }

    public static void setEnabled(boolean enabled) {
        Crashes.getInstance().setInstanceEnabled(enabled);
    }

    static void trackException(@NonNull Throwable throwable) {
        Crashes.getInstance().queueException(throwable);
    }

    public static void generateTestCrash() {
        if (Constants.APPLICATION_DEBUGGABLE) {
            throw new TestCrashException();
        }
        MobileCenterLog.warn((String)LOG_TAG, (String)"The application is not debuggable so SDK won't generate test crash");
    }

    public static void setListener(CrashesListener listener) {
        Crashes.getInstance().setInstanceListener(listener);
    }

    public static void notifyUserConfirmation(int userConfirmation) {
        Crashes.getInstance().handleUserConfirmation(userConfirmation);
    }

    public static boolean hasCrashedInLastSession() {
        return Crashes.getInstance().hasInstanceCrashedInLastSession();
    }

    @Nullable
    @WorkerThread
    static ErrorReport getLastSessionCrashReport() {
        return Crashes.getInstance().getInstanceLastSessionCrashReport();
    }

    public static void getLastSessionCrashReport(ResultCallback<ErrorReport> callback) {
        Crashes.getInstance().getInstanceLastSessionCrashReport(callback);
    }

    private synchronized boolean hasInstanceCrashedInLastSession() {
        return this.mLastSessionErrorReport != null || this.mCountDownLatch != null && this.mCountDownLatch.getCount() > 0L;
    }

    private synchronized ErrorReport getInstanceLastSessionCrashReport() {
        if (this.mCountDownLatch != null) {
            MobileCenterLog.debug((String)LOG_TAG, (String)"Waiting for Crashes service to complete crash report for the last session.");
            try {
                this.mCountDownLatch.await();
            }
            catch (InterruptedException e) {
                MobileCenterLog.debug((String)LOG_TAG, (String)"Could not get crash report for the last session.", (Throwable)e);
            }
        }
        return this.mLastSessionErrorReport;
    }

    private synchronized void getInstanceLastSessionCrashReport(final ResultCallback<ErrorReport> callback) {
        if (this.mCountDownLatch == null || this.mCountDownLatch.getCount() <= 0L) {
            HandlerUtils.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    callback.onResult((Object)Crashes.this.mLastSessionErrorReport);
                }
            });
        } else {
            this.mLastCrashErrorReportCallbacks.add(callback);
            MobileCenterLog.info((String)LOG_TAG, (String)"Crashes for the last session have not been processed yet. The SDK will call listener when it completes processing.");
        }
    }

    public synchronized void setInstanceEnabled(boolean enabled) {
        super.setInstanceEnabled(enabled);
        this.initialize();
        if (!enabled) {
            this.mHandler.getLooper().quit();
            for (File file : ErrorLogHelper.getErrorStorageDirectory().listFiles()) {
                MobileCenterLog.debug((String)LOG_TAG, (String)("Deleting file " + file));
                if (file.delete()) continue;
                MobileCenterLog.warn((String)LOG_TAG, (String)("Failed to delete file " + file));
            }
            MobileCenterLog.info((String)LOG_TAG, (String)"Deleted crashes local files");
        }
    }

    public synchronized void onStarted(@NonNull Context context, @NonNull String appSecret, @NonNull Channel channel) {
        super.onStarted(context, appSecret, channel);
        this.mContext = context;
        this.initialize();
        if (this.isInstanceEnabled()) {
            this.processPendingErrors();
        }
    }

    public Map<String, LogFactory> getLogFactories() {
        return this.mFactories;
    }

    synchronized void trackException(@NonNull Exception exception) {
        if (this.isInactive()) {
            return;
        }
        ManagedErrorLog errorLog = ErrorLogHelper.createErrorLog(this.mContext, Thread.currentThread(), exception, Thread.getAllStackTraces(), this.getInitializeTimestamp(), false);
        this.mChannel.enqueue((Log)errorLog, ERROR_GROUP);
    }

    protected String getGroupName() {
        return ERROR_GROUP;
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    protected String getLoggerTag() {
        return LOG_TAG;
    }

    protected int getTriggerCount() {
        return 1;
    }

    protected Channel.GroupListener getChannelListener() {
        return new Channel.GroupListener(){

            private void processCallback(Log log, final CallbackProcessor callbackProcessor) {
                if (log instanceof ManagedErrorLog) {
                    ManagedErrorLog errorLog = (ManagedErrorLog)log;
                    if (errorLog.getFatal().booleanValue()) {
                        final ErrorReport report = Crashes.this.buildErrorReport(errorLog);
                        UUID id = errorLog.getId();
                        if (report != null) {
                            if (callbackProcessor.shouldDeleteThrowable()) {
                                Crashes.this.removeStoredThrowable(id);
                            }
                            HandlerUtils.runOnUiThread((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    callbackProcessor.onCallBack(report);
                                }
                            });
                        } else {
                            MobileCenterLog.warn((String)Crashes.LOG_TAG, (String)("Cannot find crash report for the error log: " + id));
                        }
                    }
                } else {
                    MobileCenterLog.warn((String)Crashes.LOG_TAG, (String)("A different type of log comes to crashes: " + log.getClass().getName()));
                }
            }

            public void onBeforeSending(Log log) {
                this.processCallback(log, new CallbackProcessor(){

                    @Override
                    public boolean shouldDeleteThrowable() {
                        return false;
                    }

                    @Override
                    public void onCallBack(ErrorReport report) {
                        Crashes.this.mCrashesListener.onBeforeSending(report);
                    }
                });
            }

            public void onSuccess(Log log) {
                this.processCallback(log, new CallbackProcessor(){

                    @Override
                    public boolean shouldDeleteThrowable() {
                        return true;
                    }

                    @Override
                    public void onCallBack(ErrorReport report) {
                        Crashes.this.mCrashesListener.onSendingSucceeded(report);
                    }
                });
            }

            public void onFailure(Log log, final java.lang.Exception e) {
                this.processCallback(log, new CallbackProcessor(){

                    @Override
                    public boolean shouldDeleteThrowable() {
                        return true;
                    }

                    @Override
                    public void onCallBack(ErrorReport report) {
                        Crashes.this.mCrashesListener.onSendingFailed(report, e);
                    }
                });
            }
        };
    }

    @VisibleForTesting
    synchronized long getInitializeTimestamp() {
        return this.mInitializeTimestamp;
    }

    @VisibleForTesting
    Handler getHandler() {
        return this.mHandler;
    }

    private synchronized void queueException(@NonNull Throwable throwable) {
        if (this.isInactive()) {
            return;
        }
        ManagedErrorLog errorLog = ErrorLogHelper.createErrorLog(this.mContext, Thread.currentThread(), throwable, Thread.getAllStackTraces(), this.getInitializeTimestamp(), false);
        this.mChannel.enqueue((Log)errorLog, ERROR_GROUP);
    }

    private void initialize() {
        boolean enabled = this.isInstanceEnabled();
        long l = this.mInitializeTimestamp = enabled ? SystemClock.elapsedRealtime() : -1L;
        if (!enabled) {
            if (this.mUncaughtExceptionHandler != null) {
                this.mUncaughtExceptionHandler.unregister();
                this.mUncaughtExceptionHandler = null;
            }
        } else if (this.mContext != null && this.mUncaughtExceptionHandler == null) {
            this.mUncaughtExceptionHandler = new UncaughtExceptionHandler();
            this.mUncaughtExceptionHandler.register();
            final File logFile = ErrorLogHelper.getLastErrorLogFile();
            if (logFile != null) {
                MobileCenterLog.debug((String)LOG_TAG, (String)"Processing crash report for the last session.");
                this.mCountDownLatch = new CountDownLatch(1);
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        String logFileContents = StorageHelper.InternalStorage.read((File)logFile);
                        if (logFileContents == null) {
                            MobileCenterLog.error((String)Crashes.LOG_TAG, (String)"Error reading last session error log.");
                        } else {
                            try {
                                ManagedErrorLog log = (ManagedErrorLog)Crashes.this.mLogSerializer.deserializeLog(logFileContents);
                                Crashes.this.mLastSessionErrorReport = Crashes.this.buildErrorReport(log);
                                MobileCenterLog.debug((String)Crashes.LOG_TAG, (String)"Processed crash report for the last session.");
                            }
                            catch (JSONException e) {
                                MobileCenterLog.error((String)Crashes.LOG_TAG, (String)"Error parsing last session error log.", (Throwable)e);
                            }
                        }
                        Crashes.this.mCountDownLatch.countDown();
                        HandlerUtils.runOnUiThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                Iterator iterator = Crashes.this.mLastCrashErrorReportCallbacks.iterator();
                                while (iterator.hasNext()) {
                                    ResultCallback callback = (ResultCallback)iterator.next();
                                    iterator.remove();
                                    callback.onResult((Object)Crashes.this.mLastSessionErrorReport);
                                }
                            }
                        });
                    }
                });
            }
        }
    }

    private boolean shouldStopProcessingPendingErrors() {
        if (!this.isInstanceEnabled()) {
            MobileCenterLog.info((String)LOG_TAG, (String)"Crashes service is disabled while processing errors. Cancel processing all pending errors.");
            return true;
        }
        return false;
    }

    private void processPendingErrors() {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                for (File logFile : ErrorLogHelper.getStoredErrorLogFiles()) {
                    if (Crashes.this.shouldStopProcessingPendingErrors()) {
                        return;
                    }
                    MobileCenterLog.debug((String)Crashes.LOG_TAG, (String)("Process pending error file: " + logFile));
                    String logfileContents = StorageHelper.InternalStorage.read((File)logFile);
                    if (logfileContents == null) continue;
                    try {
                        ManagedErrorLog log = (ManagedErrorLog)Crashes.this.mLogSerializer.deserializeLog(logfileContents);
                        UUID id = log.getId();
                        ErrorReport report = Crashes.this.buildErrorReport(log);
                        if (report == null) {
                            Crashes.this.removeAllStoredErrorLogFiles(id);
                            continue;
                        }
                        if (Crashes.this.mCrashesListener.shouldProcess(report)) {
                            MobileCenterLog.debug((String)Crashes.LOG_TAG, (String)("CrashesListener.shouldProcess returned true, continue processing log: " + id.toString()));
                            Crashes.this.mUnprocessedErrorReports.put(id, Crashes.this.mErrorReportCache.get(id));
                            continue;
                        }
                        MobileCenterLog.debug((String)Crashes.LOG_TAG, (String)("CrashesListener.shouldProcess returned false, clean up and ignore log: " + id.toString()));
                        Crashes.this.removeAllStoredErrorLogFiles(id);
                    }
                    catch (JSONException e) {
                        MobileCenterLog.error((String)Crashes.LOG_TAG, (String)"Error parsing error log", (Throwable)e);
                    }
                }
                if (Crashes.this.shouldStopProcessingPendingErrors()) {
                    return;
                }
                Crashes.this.processUserConfirmation();
            }
        });
    }

    private void processUserConfirmation() {
        HandlerUtils.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                boolean shouldAwaitUserConfirmation = true;
                if (Crashes.this.mUnprocessedErrorReports.size() > 0 && (StorageHelper.PreferencesStorage.getBoolean((String)Crashes.PREF_KEY_ALWAYS_SEND, (boolean)false) || !(shouldAwaitUserConfirmation = Crashes.this.mCrashesListener.shouldAwaitUserConfirmation()))) {
                    if (!shouldAwaitUserConfirmation) {
                        MobileCenterLog.debug((String)Crashes.LOG_TAG, (String)"CrashesListener.shouldAwaitUserConfirmation returned false, continue sending logs");
                    } else {
                        MobileCenterLog.debug((String)Crashes.LOG_TAG, (String)"The flag for user confirmation is set to ALWAYS_SEND, continue sending logs");
                    }
                    Crashes.this.handleUserConfirmation(0);
                }
            }
        });
    }

    private void removeAllStoredErrorLogFiles(UUID id) {
        ErrorLogHelper.removeStoredErrorLogFile(id);
        this.removeStoredThrowable(id);
    }

    private void removeStoredThrowable(UUID id) {
        this.mErrorReportCache.remove(id);
        WrapperSdkExceptionManager.deleteWrapperExceptionData(id);
        ErrorLogHelper.removeStoredThrowableFile(id);
    }

    @VisibleForTesting
    UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.mUncaughtExceptionHandler;
    }

    @VisibleForTesting
    void setUncaughtExceptionHandler(UncaughtExceptionHandler handler) {
        this.mUncaughtExceptionHandler = handler;
    }

    @VisibleForTesting
    @Nullable
    ErrorReport buildErrorReport(ManagedErrorLog log) {
        UUID id = log.getId();
        if (this.mErrorReportCache.containsKey(id)) {
            return this.mErrorReportCache.get(id).report;
        }
        File file = ErrorLogHelper.getStoredThrowableFile(id);
        if (file != null) {
            try {
                Throwable throwable = (Throwable)StorageHelper.InternalStorage.readObject((File)file);
                ErrorReport report = ErrorLogHelper.getErrorReportFromErrorLog(log, throwable);
                this.mErrorReportCache.put(id, new ErrorLogReport(log, report));
                return report;
            }
            catch (ClassNotFoundException ignored) {
                MobileCenterLog.error((String)LOG_TAG, (String)("Cannot read throwable file " + file.getName()), (Throwable)ignored);
            }
            catch (IOException ignored) {
                MobileCenterLog.error((String)LOG_TAG, (String)("Cannot access serialized throwable file " + file.getName()), (Throwable)ignored);
            }
        }
        return null;
    }

    @VisibleForTesting
    CrashesListener getInstanceListener() {
        return this.mCrashesListener;
    }

    @VisibleForTesting
    synchronized void setInstanceListener(CrashesListener listener) {
        if (listener == null) {
            listener = DEFAULT_ERROR_REPORTING_LISTENER;
        }
        this.mCrashesListener = listener;
    }

    public void setWrapperSdkListener(WrapperSdkListener wrapperSdkListener) {
        this.mWrapperSdkListener = wrapperSdkListener;
    }

    @VisibleForTesting
    private synchronized void handleUserConfirmation(final int userConfirmation) {
        if (this.mChannel == null) {
            MobileCenterLog.error((String)LOG_TAG, (String)"Crashes service not initialized, discarding calls.");
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (userConfirmation == 1) {
                    Iterator iterator = Crashes.this.mUnprocessedErrorReports.keySet().iterator();
                    while (iterator.hasNext()) {
                        UUID id = (UUID)iterator.next();
                        iterator.remove();
                        Crashes.this.removeAllStoredErrorLogFiles(id);
                    }
                } else {
                    if (userConfirmation == 2) {
                        StorageHelper.PreferencesStorage.putBoolean((String)Crashes.PREF_KEY_ALWAYS_SEND, (boolean)true);
                    }
                    Iterator unprocessedIterator = Crashes.this.mUnprocessedErrorReports.entrySet().iterator();
                    while (unprocessedIterator.hasNext() && !Crashes.this.shouldStopProcessingPendingErrors()) {
                        Map.Entry unprocessedEntry = unprocessedIterator.next();
                        ErrorLogReport errorLogReport = (ErrorLogReport)unprocessedEntry.getValue();
                        Crashes.this.mChannel.enqueue((Log)errorLogReport.log, Crashes.ERROR_GROUP);
                        unprocessedIterator.remove();
                        ErrorLogHelper.removeStoredErrorLogFile((UUID)unprocessedEntry.getKey());
                    }
                }
                if (Crashes.this.isInstanceEnabled()) {
                    Crashes.this.mHandler.getLooper().quit();
                }
            }
        };
        if (Looper.myLooper() == Looper.getMainLooper()) {
            this.mHandler.post(runnable);
        } else {
            runnable.run();
        }
    }

    @VisibleForTesting
    void setLogSerializer(LogSerializer logSerializer) {
        this.mLogSerializer = logSerializer;
    }

    void saveUncaughtException(Thread thread, Throwable exception) {
        ManagedErrorLog errorLog = ErrorLogHelper.createErrorLog(this.mContext, thread, exception, Thread.getAllStackTraces(), this.mInitializeTimestamp, true);
        try {
            File errorStorageDirectory = ErrorLogHelper.getErrorStorageDirectory();
            String filename = errorLog.getId().toString();
            MobileCenterLog.debug((String)LOG_TAG, (String)"Saving uncaught exception:", (Throwable)exception);
            this.saveErrorLog(errorLog, errorStorageDirectory, filename);
            File throwableFile = new File(errorStorageDirectory, filename + ".throwable");
            StorageHelper.InternalStorage.writeObject((File)throwableFile, (Serializable)exception);
            MobileCenterLog.debug((String)LOG_TAG, (String)("Saved Throwable as is for client side inspection in " + throwableFile));
            if (this.mWrapperSdkListener != null) {
                this.mWrapperSdkListener.onCrashCaptured(errorLog);
            }
        }
        catch (JSONException e) {
            MobileCenterLog.error((String)LOG_TAG, (String)"Error serializing error log to JSON", (Throwable)e);
        }
        catch (IOException e) {
            MobileCenterLog.error((String)LOG_TAG, (String)"Error writing error log to file", (Throwable)e);
        }
    }

    void saveErrorLog(ManagedErrorLog errorLog, File errorStorageDirectory, String filename) throws JSONException, IOException {
        File errorLogFile = new File(errorStorageDirectory, filename + ".json");
        String errorLogString = this.mLogSerializer.serializeLog((Log)errorLog);
        StorageHelper.InternalStorage.write((File)errorLogFile, (String)errorLogString);
        MobileCenterLog.debug((String)LOG_TAG, (String)("Saved JSON content for ingestion into " + errorLogFile));
    }

    private static class ErrorLogReport {
        private final ManagedErrorLog log;
        private final ErrorReport report;

        private ErrorLogReport(ManagedErrorLog log, ErrorReport report) {
            this.log = log;
            this.report = report;
        }
    }

    private static class DefaultCrashesListener
    extends AbstractCrashesListener {
        private DefaultCrashesListener() {
        }
    }

    public static interface WrapperSdkListener {
        public void onCrashCaptured(ManagedErrorLog var1);
    }

    private static interface CallbackProcessor {
        public boolean shouldDeleteThrowable();

        public void onCallBack(ErrorReport var1);
    }
}

