/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.crashes.ingestion.models;

import com.microsoft.azure.mobile.ingestion.models.Model;
import com.microsoft.azure.mobile.ingestion.models.json.JSONUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;

public class StackFrame
implements Model {
    private static final String CLASS_NAME = "class_name";
    private static final String METHOD_NAME = "method_name";
    private static final String LINE_NUMBER = "line_number";
    private static final String FILE_NAME = "file_name";
    private String className;
    private String methodName;
    private Integer lineNumber;
    private String fileName;

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(Integer lineNumber) {
        this.lineNumber = lineNumber;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void read(JSONObject object) throws JSONException {
        this.setClassName(object.optString(CLASS_NAME, null));
        this.setMethodName(object.optString(METHOD_NAME, null));
        this.setLineNumber(JSONUtils.readInteger((JSONObject)object, (String)LINE_NUMBER));
        this.setFileName(object.optString(FILE_NAME, null));
    }

    public void write(JSONStringer writer) throws JSONException {
        JSONUtils.write((JSONStringer)writer, (String)CLASS_NAME, (Object)this.getClassName());
        JSONUtils.write((JSONStringer)writer, (String)METHOD_NAME, (Object)this.getMethodName());
        JSONUtils.write((JSONStringer)writer, (String)LINE_NUMBER, (Object)this.getLineNumber());
        JSONUtils.write((JSONStringer)writer, (String)FILE_NAME, (Object)this.getFileName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StackFrame that = (StackFrame)o;
        if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
            return false;
        }
        if (this.methodName != null ? !this.methodName.equals(that.methodName) : that.methodName != null) {
            return false;
        }
        if (this.lineNumber != null ? !this.lineNumber.equals(that.lineNumber) : that.lineNumber != null) {
            return false;
        }
        return this.fileName != null ? this.fileName.equals(that.fileName) : that.fileName == null;
    }

    public int hashCode() {
        int result = this.className != null ? this.className.hashCode() : 0;
        result = 31 * result + (this.methodName != null ? this.methodName.hashCode() : 0);
        result = 31 * result + (this.lineNumber != null ? this.lineNumber.hashCode() : 0);
        result = 31 * result + (this.fileName != null ? this.fileName.hashCode() : 0);
        return result;
    }
}

