/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.crashes;

import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.microsoft.azure.mobile.crashes.Crashes;
import com.microsoft.azure.mobile.crashes.ingestion.models.Exception;
import com.microsoft.azure.mobile.crashes.utils.ErrorLogHelper;
import com.microsoft.azure.mobile.utils.MobileCenterLog;
import com.microsoft.azure.mobile.utils.storage.StorageHelper;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class WrapperSdkExceptionManager {
    @VisibleForTesting
    static final Map<String, byte[]> sWrapperExceptionDataContainer = new HashMap<String, byte[]>();
    private static final String DATA_FILE_EXTENSION = ".dat";

    @VisibleForTesting
    WrapperSdkExceptionManager() {
    }

    public static UUID saveWrapperException(Thread thread, Exception modelException, byte[] rawSerializedException) {
        try {
            UUID errorId = Crashes.getInstance().saveUncaughtException(thread, null, modelException);
            if (errorId != null) {
                sWrapperExceptionDataContainer.put(errorId.toString(), rawSerializedException);
                File dataFile = WrapperSdkExceptionManager.getFile(errorId);
                StorageHelper.InternalStorage.writeObject((File)dataFile, (Serializable)rawSerializedException);
                MobileCenterLog.debug((String)"MobileCenterCrashes", (String)("Saved raw wrapper exception data into " + dataFile));
            }
            return errorId;
        }
        catch (java.lang.Exception e) {
            MobileCenterLog.error((String)"MobileCenterCrashes", (String)"Failed to save wrapper exception data to file", (Throwable)e);
            return null;
        }
    }

    public static void deleteWrapperExceptionData(UUID errorId) {
        if (errorId == null) {
            MobileCenterLog.error((String)"MobileCenterCrashes", (String)"Failed to delete wrapper exception data: null errorId");
            return;
        }
        File dataFile = WrapperSdkExceptionManager.getFile(errorId);
        if (dataFile.exists()) {
            byte[] loadResult = WrapperSdkExceptionManager.loadWrapperExceptionData(errorId);
            if (loadResult == null) {
                MobileCenterLog.error((String)"MobileCenterCrashes", (String)"Failed to delete wrapper exception data: data not found");
            }
            StorageHelper.InternalStorage.delete((File)dataFile);
        }
    }

    public static byte[] loadWrapperExceptionData(UUID errorId) {
        if (errorId == null) {
            MobileCenterLog.error((String)"MobileCenterCrashes", (String)"Failed to load wrapper exception data: null errorId");
            return null;
        }
        byte[] dataBytes = sWrapperExceptionDataContainer.get(errorId.toString());
        if (dataBytes != null) {
            return dataBytes;
        }
        File dataFile = WrapperSdkExceptionManager.getFile(errorId);
        try {
            dataBytes = (byte[])StorageHelper.InternalStorage.readObject((File)dataFile);
            if (dataBytes != null) {
                sWrapperExceptionDataContainer.put(errorId.toString(), dataBytes);
            }
            return dataBytes;
        }
        catch (IOException | ClassNotFoundException e) {
            MobileCenterLog.error((String)"MobileCenterCrashes", (String)("Cannot access wrapper exception data file " + dataFile.getName()), (Throwable)e);
            return null;
        }
    }

    private static File getFile(@NonNull UUID errorId) {
        File errorStorageDirectory = ErrorLogHelper.getErrorStorageDirectory();
        String filename = errorId.toString() + DATA_FILE_EXTENSION;
        return new File(errorStorageDirectory, filename);
    }
}

