/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.crashes;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.microsoft.azure.mobile.AbstractMobileCenterService;
import com.microsoft.azure.mobile.Constants;
import com.microsoft.azure.mobile.channel.Channel;
import com.microsoft.azure.mobile.crashes.AbstractCrashesListener;
import com.microsoft.azure.mobile.crashes.CrashesListener;
import com.microsoft.azure.mobile.crashes.UncaughtExceptionHandler;
import com.microsoft.azure.mobile.crashes.WrapperSdkExceptionManager;
import com.microsoft.azure.mobile.crashes.ingestion.models.ErrorAttachmentLog;
import com.microsoft.azure.mobile.crashes.ingestion.models.Exception;
import com.microsoft.azure.mobile.crashes.ingestion.models.ManagedErrorLog;
import com.microsoft.azure.mobile.crashes.ingestion.models.json.ErrorAttachmentLogFactory;
import com.microsoft.azure.mobile.crashes.ingestion.models.json.ManagedErrorLogFactory;
import com.microsoft.azure.mobile.crashes.model.ErrorReport;
import com.microsoft.azure.mobile.crashes.model.TestCrashException;
import com.microsoft.azure.mobile.crashes.utils.ErrorLogHelper;
import com.microsoft.azure.mobile.ingestion.models.Log;
import com.microsoft.azure.mobile.ingestion.models.json.DefaultLogSerializer;
import com.microsoft.azure.mobile.ingestion.models.json.LogFactory;
import com.microsoft.azure.mobile.ingestion.models.json.LogSerializer;
import com.microsoft.azure.mobile.utils.HandlerUtils;
import com.microsoft.azure.mobile.utils.MobileCenterLog;
import com.microsoft.azure.mobile.utils.async.DefaultMobileCenterFuture;
import com.microsoft.azure.mobile.utils.async.MobileCenterFuture;
import com.microsoft.azure.mobile.utils.storage.StorageHelper;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.json.JSONException;

public class Crashes
extends AbstractMobileCenterService {
    public static final int SEND = 0;
    public static final int DONT_SEND = 1;
    public static final int ALWAYS_SEND = 2;
    @VisibleForTesting
    public static final String PREF_KEY_ALWAYS_SEND = "com.microsoft.azure.mobile.crashes.always.send";
    @VisibleForTesting
    static final String ERROR_GROUP = "group_errors";
    private static final String SERVICE_NAME = "Crashes";
    public static final String LOG_TAG = "MobileCenterCrashes";
    private static final int MAX_ATTACHMENT_PER_CRASH = 2;
    private static final CrashesListener DEFAULT_ERROR_REPORTING_LISTENER = new DefaultCrashesListener();
    @SuppressLint(value={"StaticFieldLeak"})
    private static Crashes sInstance = null;
    private final Map<String, LogFactory> mFactories = new HashMap<String, LogFactory>();
    private final Map<UUID, ErrorLogReport> mUnprocessedErrorReports;
    private final Map<UUID, ErrorLogReport> mErrorReportCache;
    private LogSerializer mLogSerializer;
    private Context mContext;
    private long mInitializeTimestamp;
    private UncaughtExceptionHandler mUncaughtExceptionHandler;
    private CrashesListener mCrashesListener;
    private ErrorReport mLastSessionErrorReport;
    private boolean mSavedUncaughtException;

    private Crashes() {
        this.mFactories.put("managed_error", ManagedErrorLogFactory.getInstance());
        this.mFactories.put("error_attachment", ErrorAttachmentLogFactory.getInstance());
        this.mLogSerializer = new DefaultLogSerializer();
        this.mLogSerializer.addLogFactory("managed_error", (LogFactory)ManagedErrorLogFactory.getInstance());
        this.mLogSerializer.addLogFactory("error_attachment", (LogFactory)ErrorAttachmentLogFactory.getInstance());
        this.mCrashesListener = DEFAULT_ERROR_REPORTING_LISTENER;
        this.mUnprocessedErrorReports = new LinkedHashMap<UUID, ErrorLogReport>();
        this.mErrorReportCache = new LinkedHashMap<UUID, ErrorLogReport>();
    }

    @NonNull
    public static synchronized Crashes getInstance() {
        if (sInstance == null) {
            sInstance = new Crashes();
        }
        return sInstance;
    }

    @VisibleForTesting
    static synchronized void unsetInstance() {
        sInstance = null;
    }

    public static MobileCenterFuture<Boolean> isEnabled() {
        return Crashes.getInstance().isInstanceEnabledAsync();
    }

    public static MobileCenterFuture<Void> setEnabled(boolean enabled) {
        return Crashes.getInstance().setInstanceEnabledAsync(enabled);
    }

    static void trackException(@NonNull Throwable throwable) {
        Crashes.getInstance().queueException(throwable);
    }

    public static void generateTestCrash() {
        if (Constants.APPLICATION_DEBUGGABLE) {
            throw new TestCrashException();
        }
        MobileCenterLog.warn((String)LOG_TAG, (String)"The application is not debuggable so SDK won't generate test crash");
    }

    public static void setListener(CrashesListener listener) {
        Crashes.getInstance().setInstanceListener(listener);
    }

    public static void notifyUserConfirmation(int userConfirmation) {
        Crashes.getInstance().handleUserConfirmation(userConfirmation);
    }

    public static MobileCenterFuture<Boolean> hasCrashedInLastSession() {
        return Crashes.getInstance().hasInstanceCrashedInLastSession();
    }

    public static MobileCenterFuture<ErrorReport> getLastSessionCrashReport() {
        return Crashes.getInstance().getInstanceLastSessionCrashReport();
    }

    private synchronized MobileCenterFuture<Boolean> hasInstanceCrashedInLastSession() {
        final DefaultMobileCenterFuture future = new DefaultMobileCenterFuture();
        this.postAsyncGetter(new Runnable(){

            @Override
            public void run() {
                future.complete((Object)(Crashes.this.mLastSessionErrorReport != null ? 1 : 0));
            }
        }, future, false);
        return future;
    }

    private synchronized MobileCenterFuture<ErrorReport> getInstanceLastSessionCrashReport() {
        final DefaultMobileCenterFuture future = new DefaultMobileCenterFuture();
        this.postAsyncGetter(new Runnable(){

            @Override
            public void run() {
                future.complete((Object)Crashes.this.mLastSessionErrorReport);
            }
        }, future, null);
        return future;
    }

    protected synchronized void applyEnabledState(boolean enabled) {
        this.initialize();
        if (!enabled) {
            for (File file : ErrorLogHelper.getErrorStorageDirectory().listFiles()) {
                MobileCenterLog.debug((String)LOG_TAG, (String)("Deleting file " + file));
                if (file.delete()) continue;
                MobileCenterLog.warn((String)LOG_TAG, (String)("Failed to delete file " + file));
            }
            MobileCenterLog.info((String)LOG_TAG, (String)"Deleted crashes local files");
        }
    }

    public synchronized void onStarted(@NonNull Context context, @NonNull String appSecret, @NonNull Channel channel) {
        super.onStarted(context, appSecret, channel);
        this.mContext = context;
        if (this.isInstanceEnabled()) {
            this.processPendingErrors();
        } else {
            this.initialize();
        }
    }

    public Map<String, LogFactory> getLogFactories() {
        return this.mFactories;
    }

    protected synchronized void trackException(final @NonNull Exception exception) {
        this.post(new Runnable(){

            @Override
            public void run() {
                ManagedErrorLog errorLog = ErrorLogHelper.createErrorLog(Crashes.this.mContext, Thread.currentThread(), exception, Thread.getAllStackTraces(), Crashes.this.getInitializeTimestamp(), false);
                Crashes.this.mChannel.enqueue((Log)errorLog, Crashes.ERROR_GROUP);
            }
        });
    }

    protected String getGroupName() {
        return ERROR_GROUP;
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    protected String getLoggerTag() {
        return LOG_TAG;
    }

    protected int getTriggerCount() {
        return 1;
    }

    protected Channel.GroupListener getChannelListener() {
        return new Channel.GroupListener(){

            private void processCallback(final Log log, final CallbackProcessor callbackProcessor) {
                Crashes.this.post(new Runnable(){

                    @Override
                    public void run() {
                        if (log instanceof ManagedErrorLog) {
                            ManagedErrorLog errorLog = (ManagedErrorLog)log;
                            if (errorLog.getFatal().booleanValue()) {
                                final ErrorReport report = Crashes.this.buildErrorReport(errorLog);
                                UUID id = errorLog.getId();
                                if (report != null) {
                                    if (callbackProcessor.shouldDeleteThrowable()) {
                                        Crashes.this.removeStoredThrowable(id);
                                    }
                                    HandlerUtils.runOnUiThread((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            callbackProcessor.onCallBack(report);
                                        }
                                    });
                                } else {
                                    MobileCenterLog.warn((String)Crashes.LOG_TAG, (String)("Cannot find crash report for the error log: " + id));
                                }
                            }
                        } else if (!(log instanceof ErrorAttachmentLog)) {
                            MobileCenterLog.warn((String)Crashes.LOG_TAG, (String)("A different type of log comes to crashes: " + log.getClass().getName()));
                        }
                    }
                });
            }

            public void onBeforeSending(Log log) {
                this.processCallback(log, new CallbackProcessor(){

                    @Override
                    public boolean shouldDeleteThrowable() {
                        return false;
                    }

                    @Override
                    public void onCallBack(ErrorReport report) {
                        Crashes.this.mCrashesListener.onBeforeSending(report);
                    }
                });
            }

            public void onSuccess(Log log) {
                this.processCallback(log, new CallbackProcessor(){

                    @Override
                    public boolean shouldDeleteThrowable() {
                        return true;
                    }

                    @Override
                    public void onCallBack(ErrorReport report) {
                        Crashes.this.mCrashesListener.onSendingSucceeded(report);
                    }
                });
            }

            public void onFailure(Log log, final java.lang.Exception e) {
                this.processCallback(log, new CallbackProcessor(){

                    @Override
                    public boolean shouldDeleteThrowable() {
                        return true;
                    }

                    @Override
                    public void onCallBack(ErrorReport report) {
                        Crashes.this.mCrashesListener.onSendingFailed(report, e);
                    }
                });
            }
        };
    }

    @VisibleForTesting
    synchronized long getInitializeTimestamp() {
        return this.mInitializeTimestamp;
    }

    private synchronized void queueException(final @NonNull Throwable throwable) {
        this.post(new Runnable(){

            @Override
            public void run() {
                ManagedErrorLog errorLog = ErrorLogHelper.createErrorLog(Crashes.this.mContext, Thread.currentThread(), throwable, Thread.getAllStackTraces(), Crashes.this.getInitializeTimestamp(), false);
                Crashes.this.mChannel.enqueue((Log)errorLog, Crashes.ERROR_GROUP);
            }
        });
    }

    private void initialize() {
        boolean enabled = this.isInstanceEnabled();
        long l = this.mInitializeTimestamp = enabled ? SystemClock.elapsedRealtime() : -1L;
        if (!enabled) {
            if (this.mUncaughtExceptionHandler != null) {
                this.mUncaughtExceptionHandler.unregister();
                this.mUncaughtExceptionHandler = null;
            }
        } else {
            this.mUncaughtExceptionHandler = new UncaughtExceptionHandler();
            this.mUncaughtExceptionHandler.register();
            File logFile = ErrorLogHelper.getLastErrorLogFile();
            if (logFile != null) {
                MobileCenterLog.debug((String)LOG_TAG, (String)"Processing crash report for the last session.");
                String logFileContents = StorageHelper.InternalStorage.read((File)logFile);
                if (logFileContents == null) {
                    MobileCenterLog.error((String)LOG_TAG, (String)"Error reading last session error log.");
                } else {
                    try {
                        ManagedErrorLog log = (ManagedErrorLog)this.mLogSerializer.deserializeLog(logFileContents);
                        this.mLastSessionErrorReport = this.buildErrorReport(log);
                        MobileCenterLog.debug((String)LOG_TAG, (String)"Processed crash report for the last session.");
                    }
                    catch (JSONException e) {
                        MobileCenterLog.error((String)LOG_TAG, (String)"Error parsing last session error log.", (Throwable)e);
                    }
                }
            }
        }
    }

    private boolean shouldStopProcessingPendingErrors() {
        if (!this.isInstanceEnabled()) {
            MobileCenterLog.info((String)LOG_TAG, (String)"Crashes service is disabled while processing errors. Cancel processing all pending errors.");
            return true;
        }
        return false;
    }

    private void processPendingErrors() {
        for (File logFile : ErrorLogHelper.getStoredErrorLogFiles()) {
            if (this.shouldStopProcessingPendingErrors()) {
                return;
            }
            MobileCenterLog.debug((String)LOG_TAG, (String)("Process pending error file: " + logFile));
            String logfileContents = StorageHelper.InternalStorage.read((File)logFile);
            if (logfileContents == null) continue;
            try {
                ManagedErrorLog log = (ManagedErrorLog)this.mLogSerializer.deserializeLog(logfileContents);
                UUID id = log.getId();
                ErrorReport report = this.buildErrorReport(log);
                if (report == null) {
                    this.removeAllStoredErrorLogFiles(id);
                    continue;
                }
                if (this.mCrashesListener.shouldProcess(report)) {
                    MobileCenterLog.debug((String)LOG_TAG, (String)("CrashesListener.shouldProcess returned true, continue processing log: " + id.toString()));
                    this.mUnprocessedErrorReports.put(id, this.mErrorReportCache.get(id));
                    continue;
                }
                MobileCenterLog.debug((String)LOG_TAG, (String)("CrashesListener.shouldProcess returned false, clean up and ignore log: " + id.toString()));
                this.removeAllStoredErrorLogFiles(id);
            }
            catch (JSONException e) {
                MobileCenterLog.error((String)LOG_TAG, (String)"Error parsing error log", (Throwable)e);
            }
        }
        if (this.shouldStopProcessingPendingErrors()) {
            return;
        }
        this.processUserConfirmation();
    }

    private void processUserConfirmation() {
        HandlerUtils.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                boolean shouldAwaitUserConfirmation = true;
                if (Crashes.this.mUnprocessedErrorReports.size() > 0 && (StorageHelper.PreferencesStorage.getBoolean((String)Crashes.PREF_KEY_ALWAYS_SEND, (boolean)false) || !(shouldAwaitUserConfirmation = Crashes.this.mCrashesListener.shouldAwaitUserConfirmation()))) {
                    if (!shouldAwaitUserConfirmation) {
                        MobileCenterLog.debug((String)Crashes.LOG_TAG, (String)"CrashesListener.shouldAwaitUserConfirmation returned false, continue sending logs");
                    } else {
                        MobileCenterLog.debug((String)Crashes.LOG_TAG, (String)"The flag for user confirmation is set to ALWAYS_SEND, continue sending logs");
                    }
                    Crashes.this.handleUserConfirmation(0);
                }
            }
        });
    }

    private void removeAllStoredErrorLogFiles(UUID id) {
        ErrorLogHelper.removeStoredErrorLogFile(id);
        this.removeStoredThrowable(id);
    }

    private void removeStoredThrowable(UUID id) {
        this.mErrorReportCache.remove(id);
        WrapperSdkExceptionManager.deleteWrapperExceptionData(id);
        ErrorLogHelper.removeStoredThrowableFile(id);
    }

    @VisibleForTesting
    UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.mUncaughtExceptionHandler;
    }

    @VisibleForTesting
    void setUncaughtExceptionHandler(UncaughtExceptionHandler handler) {
        this.mUncaughtExceptionHandler = handler;
    }

    @VisibleForTesting
    @Nullable
    ErrorReport buildErrorReport(ManagedErrorLog log) {
        UUID id = log.getId();
        if (this.mErrorReportCache.containsKey(id)) {
            return this.mErrorReportCache.get(id).report;
        }
        File file = ErrorLogHelper.getStoredThrowableFile(id);
        if (file != null) {
            try {
                Throwable throwable = null;
                if (file.length() > 0L) {
                    throwable = (Throwable)StorageHelper.InternalStorage.readObject((File)file);
                }
                ErrorReport report = ErrorLogHelper.getErrorReportFromErrorLog(log, throwable);
                this.mErrorReportCache.put(id, new ErrorLogReport(log, report));
                return report;
            }
            catch (ClassNotFoundException ignored) {
                MobileCenterLog.error((String)LOG_TAG, (String)("Cannot read throwable file " + file.getName()), (Throwable)ignored);
            }
            catch (IOException ignored) {
                MobileCenterLog.error((String)LOG_TAG, (String)("Cannot access serialized throwable file " + file.getName()), (Throwable)ignored);
            }
        }
        return null;
    }

    @VisibleForTesting
    CrashesListener getInstanceListener() {
        return this.mCrashesListener;
    }

    @VisibleForTesting
    synchronized void setInstanceListener(CrashesListener listener) {
        if (listener == null) {
            listener = DEFAULT_ERROR_REPORTING_LISTENER;
        }
        this.mCrashesListener = listener;
    }

    @VisibleForTesting
    private synchronized void handleUserConfirmation(final int userConfirmation) {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (userConfirmation == 1) {
                    Iterator iterator = Crashes.this.mUnprocessedErrorReports.keySet().iterator();
                    while (iterator.hasNext()) {
                        UUID id = (UUID)iterator.next();
                        iterator.remove();
                        Crashes.this.removeAllStoredErrorLogFiles(id);
                    }
                } else {
                    if (userConfirmation == 2) {
                        StorageHelper.PreferencesStorage.putBoolean((String)Crashes.PREF_KEY_ALWAYS_SEND, (boolean)true);
                    }
                    Iterator unprocessedIterator = Crashes.this.mUnprocessedErrorReports.entrySet().iterator();
                    while (unprocessedIterator.hasNext() && !Crashes.this.shouldStopProcessingPendingErrors()) {
                        Map.Entry unprocessedEntry = unprocessedIterator.next();
                        ErrorLogReport errorLogReport = (ErrorLogReport)unprocessedEntry.getValue();
                        Crashes.this.mChannel.enqueue((Log)errorLogReport.log, Crashes.ERROR_GROUP);
                        Iterable<ErrorAttachmentLog> attachments = Crashes.this.mCrashesListener.getErrorAttachments(errorLogReport.report);
                        Crashes.this.handleErrorAttachmentLogs(attachments, errorLogReport);
                        unprocessedIterator.remove();
                        ErrorLogHelper.removeStoredErrorLogFile((UUID)unprocessedEntry.getKey());
                    }
                }
            }
        });
    }

    private void handleErrorAttachmentLogs(Iterable<ErrorAttachmentLog> attachments, ErrorLogReport errorLogReport) {
        if (attachments == null) {
            MobileCenterLog.debug((String)LOG_TAG, (String)("CrashesListener.getErrorAttachments returned null, no additional information will be attached to log: " + errorLogReport.log.getId().toString()));
        } else {
            int totalErrorAttachments = 0;
            for (ErrorAttachmentLog attachment : attachments) {
                if (attachment != null) {
                    attachment.setId(UUID.randomUUID());
                    attachment.setErrorId(errorLogReport.log.getId());
                    if (attachment.isValid()) {
                        ++totalErrorAttachments;
                        this.mChannel.enqueue((Log)attachment, ERROR_GROUP);
                        continue;
                    }
                    MobileCenterLog.error((String)LOG_TAG, (String)"Not all required fields are present in ErrorAttachmentLog.");
                    continue;
                }
                MobileCenterLog.warn((String)LOG_TAG, (String)"Skipping null ErrorAttachmentLog in CrashesListener.getErrorAttachments.");
            }
            if (totalErrorAttachments > 2) {
                MobileCenterLog.warn((String)LOG_TAG, (String)"A limit of 2 attachments per error report might be enforced by server.");
            }
        }
    }

    @VisibleForTesting
    void setLogSerializer(LogSerializer logSerializer) {
        this.mLogSerializer = logSerializer;
    }

    void saveUncaughtException(Thread thread, Throwable throwable) {
        try {
            this.saveUncaughtException(thread, throwable, ErrorLogHelper.getModelExceptionFromThrowable(throwable));
        }
        catch (JSONException e) {
            MobileCenterLog.error((String)LOG_TAG, (String)"Error serializing error log to JSON", (Throwable)e);
        }
        catch (IOException e) {
            MobileCenterLog.error((String)LOG_TAG, (String)"Error writing error log to file", (Throwable)e);
        }
    }

    UUID saveUncaughtException(Thread thread, Throwable throwable, Exception modelException) throws JSONException, IOException {
        if (this.mSavedUncaughtException) {
            return null;
        }
        this.mSavedUncaughtException = true;
        ManagedErrorLog errorLog = ErrorLogHelper.createErrorLog(this.mContext, thread, modelException, Thread.getAllStackTraces(), this.mInitializeTimestamp, true);
        File errorStorageDirectory = ErrorLogHelper.getErrorStorageDirectory();
        UUID errorLogId = errorLog.getId();
        String filename = errorLogId.toString();
        MobileCenterLog.debug((String)LOG_TAG, (String)"Saving uncaught exception.");
        File errorLogFile = new File(errorStorageDirectory, filename + ".json");
        String errorLogString = this.mLogSerializer.serializeLog((Log)errorLog);
        StorageHelper.InternalStorage.write((File)errorLogFile, (String)errorLogString);
        MobileCenterLog.debug((String)LOG_TAG, (String)("Saved JSON content for ingestion into " + errorLogFile));
        File throwableFile = new File(errorStorageDirectory, filename + ".throwable");
        if (throwable != null) {
            StorageHelper.InternalStorage.writeObject((File)throwableFile, (Serializable)throwable);
            MobileCenterLog.debug((String)LOG_TAG, (String)("Saved Throwable as is for client side inspection in " + throwableFile));
        } else {
            if (!throwableFile.createNewFile()) {
                throw new IOException(throwableFile.getName());
            }
            MobileCenterLog.debug((String)LOG_TAG, (String)("Saved empty Throwable file in " + throwableFile));
        }
        return errorLogId;
    }

    private static class ErrorLogReport {
        private final ManagedErrorLog log;
        private final ErrorReport report;

        private ErrorLogReport(ManagedErrorLog log, ErrorReport report) {
            this.log = log;
            this.report = report;
        }
    }

    private static class DefaultCrashesListener
    extends AbstractCrashesListener {
        private DefaultCrashesListener() {
        }
    }

    private static interface CallbackProcessor {
        public boolean shouldDeleteThrowable();

        public void onCallBack(ErrorReport var1);
    }
}

