/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.auth;

import com.microsoft.azure.kusto.data.auth.CloudInfo;
import com.microsoft.azure.kusto.data.auth.TokenProviderBase;
import com.microsoft.azure.kusto.data.exceptions.DataClientException;
import com.microsoft.azure.kusto.data.exceptions.DataServiceException;
import com.microsoft.azure.kusto.data.instrumentation.MonitoredActivity;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.http.client.HttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CloudDependentTokenProviderBase
extends TokenProviderBase {
    private static final String ERROR_INVALID_SERVICE_RESOURCE_URL = "Error determining scope due to invalid Kusto Service Resource URL";
    protected final Set<String> scopes = new HashSet<String>();
    private boolean initialized = false;
    private CloudInfo cloudInfo;

    CloudDependentTokenProviderBase(@NotNull String clusterUrl, @Nullable HttpClient httpClient) throws URISyntaxException {
        super(clusterUrl, httpClient);
    }

    @Override
    synchronized void initialize() throws DataClientException, DataServiceException {
        if (this.initialized) {
            return;
        }
        this.cloudInfo = MonitoredActivity.invoke(() -> CloudInfo.retrieveCloudInfoForCluster(this.clusterUrl, this.httpClient), "CloudDependentTokenProviderBase.retrieveCloudInfo", this.getTracingAttributes());
        this.initializeWithCloudInfo(this.cloudInfo);
        this.initialized = true;
    }

    protected void initializeWithCloudInfo(CloudInfo cloudInfo) throws DataClientException, DataServiceException {
        try {
            this.scopes.add(cloudInfo.determineScope());
        }
        catch (URISyntaxException e) {
            throw new DataServiceException(this.clusterUrl, ERROR_INVALID_SERVICE_RESOURCE_URL, e, true);
        }
    }

    @Override
    public Map<String, String> getTracingAttributes() {
        Map<String, String> attributes = super.getTracingAttributes();
        if (this.cloudInfo != null) {
            attributes.putAll(this.cloudInfo.getTracingAttributes());
        }
        attributes.put("http.url", this.clusterUrl);
        return attributes;
    }
}

