/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data;

import com.microsoft.azure.kusto.data.KustoResultColumnPopulator;
import com.microsoft.azure.kusto.data.KustoResultSetTable;
import com.microsoft.azure.kusto.data.KustoType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;

public class KustoResultMapper<R> {
    final List<KustoResultColumnPopulator<R, ?, ?>> columns;
    final Supplier<R> objConstructor;

    public static <R> Builder<R> newBuilder(Supplier<R> objConstructor) {
        return new Builder<R>(objConstructor);
    }

    private KustoResultMapper(List<KustoResultColumnPopulator<R, ?, ?>> columns, Supplier<R> objConstructor) {
        this.columns = columns;
        this.objConstructor = objConstructor;
    }

    public R extractSingle(KustoResultSetTable resultSet) {
        Object ret = null;
        if (resultSet.next()) {
            ret = this.objConstructor.get();
            for (KustoResultColumnPopulator<Object, ?, ?> kustoResultColumnPopulator : this.columns) {
                kustoResultColumnPopulator.populateFrom(ret, resultSet);
            }
        }
        return ret;
    }

    public List<R> extractList(KustoResultSetTable resultSet) {
        ArrayList<R> ret = new ArrayList<R>(resultSet.count());
        int[] columnOrdinals = new int[this.columns.size()];
        for (int i = 0; i < this.columns.size(); ++i) {
            columnOrdinals[i] = this.columns.get(i).columnIndexInResultSet(resultSet);
        }
        while (resultSet.next()) {
            R resultObject = this.objConstructor.get();
            for (int i = 0; i < this.columns.size(); ++i) {
                KustoResultColumnPopulator<R, ?, ?> col = this.columns.get(i);
                col.populateFrom(resultObject, resultSet, columnOrdinals[i]);
            }
            ret.add(resultObject);
        }
        return ret;
    }

    public static class Builder<R> {
        final List<KustoResultColumnPopulator<R, ?, ?>> queryResultColumns = new ArrayList();
        final Supplier<R> objConstructor;

        public Builder(Supplier<R> objConstructor) {
            this.objConstructor = objConstructor;
        }

        public <C> Builder<R> addColumn(KustoType<C> type, String name, boolean isNullable, BiConsumer<R, C> setter) {
            this.queryResultColumns.add(KustoResultColumnPopulator.of(name, type, isNullable, setter));
            return this;
        }

        public <C> Builder<R> addColumn(KustoType<C> type, String name, int ordinal, boolean isNullable, BiConsumer<R, C> setter) {
            this.queryResultColumns.add(KustoResultColumnPopulator.of(name, ordinal, type, isNullable, setter));
            return this;
        }

        public <C> Builder<R> addColumn(KustoType<C> type, int ordinal, boolean isNullable, BiConsumer<R, C> setter) {
            this.queryResultColumns.add(KustoResultColumnPopulator.of(ordinal, type, isNullable, setter));
            return this;
        }

        public KustoResultMapper<R> build() {
            return new KustoResultMapper(this.queryResultColumns, this.objConstructor);
        }
    }
}

