/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.configuration;

import java.util.Map;

public class DeploymentSlotConfig {
    private final String subscriptionId;
    private final String resourceGroup;
    private final String appName;
    private final String name;
    private final String configurationSource;
    private final Map<String, String> appSettings;

    DeploymentSlotConfig(String subscriptionId, String resourceGroup, String appName, String name, String configurationSource, Map<String, String> appSettings) {
        this.subscriptionId = subscriptionId;
        this.resourceGroup = resourceGroup;
        this.appName = appName;
        this.name = name;
        this.configurationSource = configurationSource;
        this.appSettings = appSettings;
    }

    public static DeploymentSlotConfigBuilder builder() {
        return new DeploymentSlotConfigBuilder();
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getResourceGroup() {
        return this.resourceGroup;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getName() {
        return this.name;
    }

    public String getConfigurationSource() {
        return this.configurationSource;
    }

    public Map<String, String> getAppSettings() {
        return this.appSettings;
    }

    public static class DeploymentSlotConfigBuilder {
        private String subscriptionId;
        private String resourceGroup;
        private String appName;
        private String name;
        private String configurationSource;
        private Map<String, String> appSettings;

        DeploymentSlotConfigBuilder() {
        }

        public DeploymentSlotConfigBuilder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public DeploymentSlotConfigBuilder resourceGroup(String resourceGroup) {
            this.resourceGroup = resourceGroup;
            return this;
        }

        public DeploymentSlotConfigBuilder appName(String appName) {
            this.appName = appName;
            return this;
        }

        public DeploymentSlotConfigBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DeploymentSlotConfigBuilder configurationSource(String configurationSource) {
            this.configurationSource = configurationSource;
            return this;
        }

        public DeploymentSlotConfigBuilder appSettings(Map<String, String> appSettings) {
            this.appSettings = appSettings;
            return this;
        }

        public DeploymentSlotConfig build() {
            return new DeploymentSlotConfig(this.subscriptionId, this.resourceGroup, this.appName, this.name, this.configurationSource, this.appSettings);
        }

        public String toString() {
            return "DeploymentSlotConfig.DeploymentSlotConfigBuilder(subscriptionId=" + this.subscriptionId + ", resourceGroup=" + this.resourceGroup + ", appName=" + this.appName + ", name=" + this.name + ", configurationSource=" + this.configurationSource + ", appSettings=" + this.appSettings + ")";
        }
    }
}

