/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.configuration;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.microsoft.azure.maven.model.DeploymentResource;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class Deployment {
    private static final String DEFAULT_DIRECTORY = "${project.basedir}/target";
    private static final String DEFAULT_INCLUDE = "*.%s";
    private static final String DEFAULT_DEPLOYTYPE = "jar";
    protected List<DeploymentResource> resources = Collections.emptyList();

    public List<DeploymentResource> getResources() {
        return this.resources;
    }

    public void setResources(List<DeploymentResource> value) {
        this.resources = value;
    }

    public static Deployment getDefaultDeploymentConfiguration(String deployType) {
        Deployment result = new Deployment();
        DeploymentResource resource = new DeploymentResource();
        resource.setDirectory(DEFAULT_DIRECTORY);
        resource.addInclude(String.format(DEFAULT_INCLUDE, StringUtils.firstNonBlank((CharSequence[])new String[]{deployType, DEFAULT_DEPLOYTYPE})));
        result.setResources(Collections.singletonList(resource));
        return result;
    }
}

