/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp;

import com.microsoft.azure.maven.auth.AzureAuthFailureException;
import com.microsoft.azure.maven.queryer.MavenPluginQueryer;
import com.microsoft.azure.maven.queryer.QueryFactory;
import com.microsoft.azure.maven.utils.MavenConfigUtils;
import com.microsoft.azure.maven.webapp.AbstractWebAppMojo;
import com.microsoft.azure.maven.webapp.WebAppConfiguration;
import com.microsoft.azure.maven.webapp.configuration.Deployment;
import com.microsoft.azure.maven.webapp.configuration.SchemaVersion;
import com.microsoft.azure.maven.webapp.handlers.WebAppPomHandler;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceAppBase;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceServiceSubscription;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.appservice.config.AppServiceConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.PricingTier;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.model.WebAppDockerRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.WebAppRuntime;
import com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.utils.AppServiceConfigUtils;
import com.microsoft.azure.toolkit.lib.appservice.webapp.AzureWebApp;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebApp;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppServiceSubscription;
import com.microsoft.azure.toolkit.lib.auth.AzureToolkitAuthenticationException;
import com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.utils.Utils;
import com.microsoft.azure.toolkit.lib.legacy.appservice.AppServiceUtils;
import com.microsoft.azure.toolkit.lib.legacy.appservice.DeploymentSlotSetting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="config")
public class ConfigMojo
extends AbstractWebAppMojo {
    private static final Logger log;
    private static final String WEB_CONTAINER = "webContainer";
    private static final String JAVA_VERSION = "javaVersion";
    private static final String COMMON_PROMPT = "Define value for %s [%s]:";
    private static final String PRICING_TIER_PROMPT = "Define value for pricingTier [%s]:";
    private static final String NOT_EMPTY_REGEX = "[\\s\\S]+";
    private static final String BOOLEAN_REGEX = "[YyNn]";
    public static final String SUBSCRIPTION_ID_PATTERN = "[a-fA-F0-9\\-]{30,36}";
    public static final String APP_NAME_PATTERN = "[a-zA-Z0-9\\-]{2,60}";
    public static final String RESOURCE_GROUP_PATTERN = "[a-zA-Z0-9\\.\\_\\-\\(\\)]{1,90}";
    public static final String SLOT_NAME_PATTERN = "[A-Za-z0-9-]{1,60}";
    private static final String CONFIG_ONLY_SUPPORT_V2 = "Config only support V2 schema";
    private static final String CHANGE_OS_WARNING = "The plugin may not work if you change the os of an existing webapp.";
    private static final String CONFIGURATION_NO_RUNTIME = "No runtime configuration, skip it.";
    private static final String SAVING_TO_POM = "Saving configuration to pom.";
    private static final String PRICE_TIER_NOT_AVAIL = "The price tier \"%s\" is not available for current OS or runtime, use \"%s\" instead.";
    private static final String NO_JAVA_WEB_APPS = "There are no Java Web Apps in current subscription, please follow the following steps to create a new one.";
    private static final String LONG_LOADING_HINT = "It may take a few minutes to load all Java Web Apps, please be patient.";
    private static final String[] configTypes;
    private static final String SETTING_REGISTRY_USERNAME = "DOCKER_REGISTRY_SERVER_USERNAME";
    private static final String SERVER_ID_TEMPLATE = "Please add a server in Maven settings.xml related to username: %s and put the serverId here";
    private static final List<String> WEB_APP_PROPERTIES;
    public static final String WEB_APP_STACKS_API = "https://aka.ms/maven_webapp_runtime";
    private MavenPluginQueryer queryer;
    private WebAppPomHandler pomHandler;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @AzureOperation(name="user/webapp.config")
    protected void doExecute() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            if (!(Utils.isJarPackagingProject((String)this.project.getPackaging()) || Utils.isEarPackagingProject((String)this.project.getPackaging()) || Utils.isWarPackagingProject((String)this.project.getPackaging()))) {
                throw new UnsupportedOperationException(String.format("The project (%s) with packaging %s is not supported for azure app service.", this.project.getName(), this.project.getPackaging()));
            }
            this.queryer = QueryFactory.getQueryer((Settings)this.settings);
            try {
                WebAppConfiguration configuration;
                this.pomHandler = new WebAppPomHandler(this.project.getFile().getAbsolutePath());
                WebAppConfiguration webAppConfiguration = configuration = this.pomHandler.getConfiguration() == null ? null : this.getWebAppConfiguration();
                if (!this.isV2Configuration(configuration)) {
                    log.warn(CONFIG_ONLY_SUPPORT_V2);
                } else {
                    this.config(configuration);
                }
            }
            catch (AzureExecutionException | IOException | IllegalAccessException | MojoFailureException | DocumentException e) {
                throw new AzureToolkitRuntimeException(e.getMessage(), e);
            }
            finally {
                this.queryer.close();
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private boolean isV2Configuration(WebAppConfiguration configuration) {
        return configuration == null || this.schemaVersion.equalsIgnoreCase(SchemaVersion.V2.toString());
    }

    private boolean isProjectConfigured() {
        String pluginIdentifier = this.plugin.getPluginLookupKey();
        Xpp3Dom configuration = MavenConfigUtils.getPluginConfiguration((MavenProject)this.getProject(), (String)pluginIdentifier);
        if (configuration == null) {
            return false;
        }
        for (Xpp3Dom child : configuration.getChildren()) {
            if (!WEB_APP_PROPERTIES.contains(child.getName())) continue;
            return true;
        }
        return false;
    }

    protected void config(WebAppConfiguration configuration) throws MojoFailureException, IOException, IllegalAccessException, DocumentException {
        WebAppConfiguration result;
        do {
            if (configuration == null || !this.isProjectConfigured()) {
                try {
                    String createNewConfiguration = this.queryer.assureInputFromUser("confirm", "Y", BOOLEAN_REGEX, "Create new run configuration (Y/N)", null);
                    if (StringUtils.equalsIgnoreCase((CharSequence)createNewConfiguration, (CharSequence)"Y")) {
                        result = this.initConfig();
                    }
                    result = Optional.ofNullable(this.chooseExistingWebappForConfiguration()).orElseGet(this::initConfig);
                }
                catch (AzureAuthFailureException e) {
                    throw new AzureToolkitRuntimeException(String.format("Cannot get Web App list due to error: %s.", e.getMessage()), (Throwable)e);
                }
            } else {
                result = this.updateConfiguration((WebAppConfiguration)configuration.toBuilder().build());
            }
        } while (!this.confirmConfiguration(result));
        log.info(SAVING_TO_POM);
        this.pomHandler.updatePluginConfiguration(result, configuration, this.project, this.plugin);
    }

    protected boolean confirmConfiguration(WebAppConfiguration configuration) {
        System.out.println("Please confirm webapp properties");
        if (StringUtils.isNotBlank((CharSequence)configuration.getSubscriptionId())) {
            System.out.println("Subscription Id : " + configuration.getSubscriptionId());
        }
        System.out.println("AppName : " + configuration.getAppName());
        System.out.println("ResourceGroup : " + configuration.getResourceGroup());
        System.out.println("Region : " + configuration.getRegion());
        if (configuration.getPricingTier() != null) {
            System.out.println("PricingTier : " + configuration.getPricingTier());
        }
        if (configuration.getOs() == null) {
            System.out.println(CONFIGURATION_NO_RUNTIME);
        } else {
            System.out.println("OS : " + configuration.getOs());
            switch (configuration.getOs()) {
                case WINDOWS: 
                case LINUX: {
                    System.out.println("Java Version: " + configuration.getJavaVersion());
                    System.out.println("Web server stack: " + configuration.getWebContainer());
                    break;
                }
                case DOCKER: {
                    System.out.println("Image : " + configuration.getImage());
                    if (StringUtils.isNotBlank((CharSequence)configuration.getServerId())) {
                        System.out.println("ServerId : " + configuration.getServerId());
                    }
                    if (!StringUtils.isNotBlank((CharSequence)configuration.getRegistryUrl())) break;
                    System.out.println("RegistryUrl : " + configuration.getRegistryUrl());
                    break;
                }
                default: {
                    throw new AzureToolkitRuntimeException("The value of <os> is unknown.");
                }
            }
        }
        System.out.println("Deploy to slot : " + (configuration.getDeploymentSlotSetting() != null));
        if (configuration.getDeploymentSlotSetting() != null) {
            DeploymentSlotSetting slotSetting = configuration.getDeploymentSlotSetting();
            System.out.println("Slot name : " + slotSetting.getName());
            System.out.println("ConfigurationSource : " + slotSetting.getConfigurationSource());
        }
        String result = this.queryer.assureInputFromUser("confirm", "Y", BOOLEAN_REGEX, "Confirm (Y/N)", null);
        return "Y".equalsIgnoreCase(result);
    }

    protected WebAppConfiguration initConfig() {
        WebAppConfiguration result = this.getDefaultConfiguration();
        return this.setRuntimeConfiguration(result, false);
    }

    private WebAppConfiguration getDefaultConfiguration() {
        WebAppConfiguration.WebAppConfigurationBuilder<?, ?> builder = WebAppConfiguration.builder();
        String defaultName = this.getProject().getArtifactId() + "-" + System.currentTimeMillis();
        String resourceGroup = defaultName + "-rg";
        String defaultSchemaVersion = "v2";
        Region defaultRegion = WebAppConfiguration.getDefaultRegion();
        return ((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)builder.appName(defaultName)).subscriptionId(this.subscriptionId)).resourceGroup(resourceGroup)).region(defaultRegion)).resources(Deployment.getDefaultDeploymentConfiguration(this.getProject().getPackaging()).getResources())).schemaVersion("v2")).subscriptionId(this.subscriptionId)).build();
    }

    protected WebAppConfiguration updateConfiguration(WebAppConfiguration configuration) {
        String selection;
        switch (selection = this.queryer.assureInputFromUser("selection", configTypes[0], Arrays.asList(configTypes), String.format("Please choose which part to config [%s]:", configTypes[0]))) {
            case "Application": {
                return this.getWebAppConfiguration(configuration);
            }
            case "Runtime": {
                log.warn(CHANGE_OS_WARNING);
                return this.setRuntimeConfiguration(configuration, true);
            }
            case "DeploymentSlot": {
                return this.getSlotConfiguration(configuration);
            }
        }
        throw new AzureToolkitRuntimeException("Unknown webapp setting");
    }

    private WebAppConfiguration getWebAppConfiguration(WebAppConfiguration configuration) {
        WebAppConfiguration.WebAppConfigurationBuilder<?, ?> builder = configuration.toBuilder();
        String defaultSubscriptionId = StringUtils.isNotBlank((CharSequence)configuration.subscriptionId) ? configuration.subscriptionId : null;
        String subscriptionId = StringUtils.isNotBlank((CharSequence)defaultSubscriptionId) ? this.queryer.assureInputFromUser("subscriptionId", defaultSubscriptionId, SUBSCRIPTION_ID_PATTERN, null, null) : null;
        String defaultAppName = this.getDefaultValue(configuration.appName, this.getProject().getArtifactId(), APP_NAME_PATTERN);
        String appName = this.queryer.assureInputFromUser("appName", defaultAppName, APP_NAME_PATTERN, null, null);
        String defaultResourceGroup = this.getDefaultValue(configuration.resourceGroup, String.format("%s-rg", appName), RESOURCE_GROUP_PATTERN);
        String resourceGroup = this.queryer.assureInputFromUser("resourceGroup", defaultResourceGroup, RESOURCE_GROUP_PATTERN, null, null);
        String defaultRegion = configuration.getRegionOrDefault();
        String region = this.queryer.assureInputFromUser("region", defaultRegion, NOT_EMPTY_REGEX, null, null);
        PricingTier defaultTier = PricingTier.fromString((String)configuration.getPricingTier());
        if (Objects.isNull(defaultTier)) {
            defaultTier = ConfigMojo.isJBossRuntime(configuration.getWebContainer()) ? WebAppConfiguration.DEFAULT_JBOSS_PRICING_TIER : WebAppConfiguration.DEFAULT_PRICINGTIER;
        }
        ArrayList validTiers = new ArrayList(WebAppRuntime.getPricingTiers((OperatingSystem)configuration.getOs(), (String)configuration.getWebContainer()));
        List validTierTexts = validTiers.stream().map(PricingTier::getSize).collect(Collectors.toList());
        if (!validTiers.contains(defaultTier)) {
            log.warn(String.format("'%s' is not supported for runtime('%s')", defaultTier.getSize(), configuration.getWebContainer()));
            defaultTier = validTiers.contains(PricingTier.PREMIUM_P1V2) ? PricingTier.PREMIUM_P1V2 : (PricingTier)validTiers.get(0);
        }
        String pricingTier = this.queryer.assureInputFromUser("pricingTier", defaultTier.getSize(), validTierTexts, String.format(PRICING_TIER_PROMPT, defaultTier.getSize()));
        return ((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)builder.subscriptionId(subscriptionId)).appName(appName)).resourceGroup(resourceGroup)).region(Region.fromName((String)region))).pricingTier(pricingTier)).build();
    }

    private static boolean isJBossRuntime(String container) {
        return container != null && StringUtils.startsWithIgnoreCase((CharSequence)container, (CharSequence)"JBOSS");
    }

    private WebAppConfiguration getSlotConfiguration(WebAppConfiguration configuration) {
        WebAppConfiguration.WebAppConfigurationBuilder<?, ?> builder = configuration.toBuilder();
        DeploymentSlotSetting deploymentSlotSetting = configuration.getDeploymentSlotSetting();
        String defaultIsSlotDeploy = deploymentSlotSetting == null ? "N" : "Y";
        String isSlotDeploy = this.queryer.assureInputFromUser("isSlotDeploy", defaultIsSlotDeploy, BOOLEAN_REGEX, "Deploy to slot?(Y/N)", null);
        if (StringUtils.equalsIgnoreCase((CharSequence)isSlotDeploy, (CharSequence)"n")) {
            return ((WebAppConfiguration.WebAppConfigurationBuilder)builder.deploymentSlotSetting(null)).build();
        }
        String defaultSlotName = deploymentSlotSetting == null ? String.format("%s-slot", configuration.getAppName()) : deploymentSlotSetting.getName();
        String slotName = this.queryer.assureInputFromUser("slotName", defaultSlotName, SLOT_NAME_PATTERN, null, null);
        String defaultConfigurationSource = deploymentSlotSetting == null ? null : deploymentSlotSetting.getConfigurationSource();
        String configurationSource = this.queryer.assureInputFromUser("configurationSource", defaultConfigurationSource, null, null, null);
        DeploymentSlotSetting result = new DeploymentSlotSetting();
        result.setName(slotName);
        result.setConfigurationSource(configurationSource);
        return ((WebAppConfiguration.WebAppConfigurationBuilder)builder.deploymentSlotSetting(result)).build();
    }

    private WebAppConfiguration setRuntimeConfiguration(WebAppConfiguration configuration, boolean updating) {
        WebAppDockerRuntime runtime;
        WebAppConfiguration.WebAppConfigurationBuilder<?, ?> builder = configuration.toBuilder();
        OperatingSystem defaultOs = (OperatingSystem)ObjectUtils.defaultIfNull((Object)configuration.getOs(), (Object)OperatingSystem.LINUX);
        String osUserInput = this.queryer.assureInputFromUser("OS", (Enum)defaultOs, String.format("Define value for OS [%s]:", defaultOs));
        OperatingSystem os = OperatingSystem.fromString((String)osUserInput);
        Optional.ofNullable(os).orElseThrow(() -> new AzureToolkitRuntimeException("The value of <os> is unknown."));
        builder.os(os);
        Object object = runtime = os == OperatingSystem.DOCKER ? this.setupRuntimeForDocker(builder, configuration) : this.setupRuntimeForWindowsOrLinux(os, builder, configuration, updating);
        if (!updating || ConfigMojo.pricingTierNotSupport(configuration.getPricingTier(), (WebAppRuntime)runtime)) {
            PricingTier defaultTier = runtime.isJBoss() ? WebAppConfiguration.DEFAULT_JBOSS_PRICING_TIER : WebAppConfiguration.DEFAULT_PRICINGTIER;
            List validTiers = runtime.getPricingTiers();
            List validTierTexts = validTiers.stream().map(PricingTier::getSize).collect(Collectors.toList());
            if (!validTiers.contains(defaultTier)) {
                log.warn(String.format("'%s' is not supported in current os('%s') and runtime('%s')", defaultTier.getSize(), osUserInput, runtime.getContainerUserText()));
                defaultTier = validTiers.contains(PricingTier.PREMIUM_P1V2) ? PricingTier.PREMIUM_P1V2 : (PricingTier)validTiers.get(0);
            }
            String pricingTier = this.queryer.assureInputFromUser("pricingTier", defaultTier.getSize(), validTierTexts, String.format(PRICING_TIER_PROMPT, defaultTier.getSize()));
            builder.pricingTier(pricingTier);
        }
        return builder.build();
    }

    private static boolean pricingTierNotSupport(String pricingTier, WebAppRuntime runtime) {
        if (StringUtils.isBlank((CharSequence)pricingTier)) {
            return false;
        }
        PricingTier tier = PricingTier.fromString((String)pricingTier);
        if (tier == null) {
            return true;
        }
        List tiers = runtime.getPricingTiers();
        return !tiers.contains(tier);
    }

    private WebAppRuntime setupRuntimeForWindowsOrLinux(OperatingSystem os, WebAppConfiguration.WebAppConfigurationBuilder<?, ?> builder, WebAppConfiguration configuration, boolean updating) {
        String containerUserInput;
        String javaVersionUserInput;
        List runtimes = WebAppRuntime.getMajorRuntimes().stream().filter(runtime -> runtime.getOperatingSystem() == os).collect(Collectors.toList());
        runtimes = this.getValidRuntimes(runtimes, Runtime::getJavaMajorVersionNumber, Runtime::getJavaVersionUserText);
        List validJavaVersionUserTexts = runtimes.stream().map(Runtime::getJavaVersionUserText).distinct().collect(Collectors.toList());
        String defaultJavaVersion = configuration.getJavaVersion();
        if (StringUtils.isNotBlank((CharSequence)defaultJavaVersion)) {
            String string = defaultJavaVersion = StringUtils.startsWithIgnoreCase((CharSequence)defaultJavaVersion, (CharSequence)"java") ? StringUtils.capitalize((String)defaultJavaVersion) : String.format("Java %s", defaultJavaVersion);
        }
        if (StringUtils.isBlank((CharSequence)defaultJavaVersion) || !validJavaVersionUserTexts.contains(defaultJavaVersion)) {
            if (updating && StringUtils.isNotBlank((CharSequence)defaultJavaVersion)) {
                log.warn(String.format("'%s' may not be a valid Java runtime. Refer to %s please.", defaultJavaVersion, WEB_APP_STACKS_API));
            }
            if (validJavaVersionUserTexts.isEmpty()) {
                throw new AzureToolkitRuntimeException("No valid runtime found, please check your configuration and try again.");
            }
            defaultJavaVersion = (String)validJavaVersionUserTexts.get(0);
        }
        if (!validJavaVersionUserTexts.contains(javaVersionUserInput = this.queryer.assureInputFromUser(JAVA_VERSION, defaultJavaVersion, validJavaVersionUserTexts, String.format(COMMON_PROMPT, JAVA_VERSION, defaultJavaVersion)))) {
            String message = String.format("'%s' may not be a valid Java runtime, recommended values are %s. Refer to %s please.", javaVersionUserInput, String.join((CharSequence)", ", validJavaVersionUserTexts), WEB_APP_STACKS_API);
            throw new AzureToolkitRuntimeException(message);
        }
        builder.javaVersion(javaVersionUserInput);
        boolean isJarPackaging = Utils.isJarPackagingProject((String)this.project.getPackaging());
        if (isJarPackaging) {
            log.info("Skip web container selection for \"jar\" project.");
            builder.webContainer(WebAppRuntime.JAVA_SE.toString());
            runtimes = runtimes.stream().filter(r -> StringUtils.equalsIgnoreCase((CharSequence)r.getContainerUserText(), (CharSequence)WebAppRuntime.JAVA_SE.toString())).collect(Collectors.toList());
            if (runtimes.isEmpty()) {
                throw new AzureToolkitRuntimeException("No valid runtime found, please check your configuration and try again.");
            }
            return (WebAppRuntime)runtimes.get(0);
        }
        runtimes = runtimes.stream().filter(r -> StringUtils.equalsIgnoreCase((CharSequence)r.getJavaVersionUserText(), (CharSequence)javaVersionUserInput)).collect(Collectors.toList());
        runtimes = runtimes.stream().filter(r -> !StringUtils.equalsIgnoreCase((CharSequence)r.getContainerName(), (CharSequence)"java")).collect(Collectors.toList());
        if (Utils.isEarPackagingProject((String)this.project.getPackaging())) {
            runtimes = runtimes.stream().filter(r -> StringUtils.startsWithIgnoreCase((CharSequence)r.getContainerName(), (CharSequence)"JBoss")).collect(Collectors.toList());
        }
        List validContainerUserTexts = runtimes.stream().map(WebAppRuntime::getContainerUserText).distinct().collect(Collectors.toList());
        String defaultContainer = configuration.getWebContainer();
        if (StringUtils.isBlank((CharSequence)defaultContainer) || !validContainerUserTexts.contains(defaultContainer)) {
            if (updating && StringUtils.isNotBlank((CharSequence)defaultContainer)) {
                log.warn(String.format("'%s' may not be a valid web container. Refer to %s please.", defaultContainer, WEB_APP_STACKS_API));
            }
            if (validContainerUserTexts.isEmpty()) {
                String message = String.format("No valid runtime found for '%s' + '%s', please check your java version and try again.", os, javaVersionUserInput);
                throw new AzureToolkitRuntimeException(message);
            }
            defaultContainer = (String)validContainerUserTexts.get(0);
        }
        if (!validContainerUserTexts.contains(containerUserInput = this.queryer.assureInputFromUser(WEB_CONTAINER, defaultContainer, validContainerUserTexts, String.format(COMMON_PROMPT, WEB_CONTAINER, defaultContainer)))) {
            String message = String.format("'%s' may not be a valid web container, recommended values are %s. Refer to %s please", containerUserInput, String.join((CharSequence)", ", validContainerUserTexts), WEB_APP_STACKS_API);
            throw new AzureToolkitRuntimeException(message);
        }
        builder.webContainer(containerUserInput);
        runtimes = runtimes.stream().filter(r -> StringUtils.equalsIgnoreCase((CharSequence)r.getContainerUserText(), (CharSequence)containerUserInput)).collect(Collectors.toList());
        if (runtimes.isEmpty()) {
            String message = String.format("No valid runtime found for '%s' + '%s' + '%s', please check your configuration and try again.", os, javaVersionUserInput, containerUserInput);
            throw new AzureToolkitRuntimeException(message);
        }
        return (WebAppRuntime)runtimes.get(0);
    }

    private WebAppDockerRuntime setupRuntimeForDocker(WebAppConfiguration.WebAppConfigurationBuilder<?, ?> builder, WebAppConfiguration configuration) {
        String image = this.queryer.assureInputFromUser("image", configuration.image, NOT_EMPTY_REGEX, null, null);
        String serverId = this.queryer.assureInputFromUser("serverId", configuration.serverId, null, null, null);
        String registryUrl = this.queryer.assureInputFromUser("registryUrl", configuration.registryUrl, null, null, null);
        ((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)builder.image(image)).serverId(serverId)).registryUrl(registryUrl);
        return WebAppDockerRuntime.INSTANCE;
    }

    private String getDefaultValue(String defaultValue, String fallBack, String pattern) {
        return StringUtils.isNotEmpty((CharSequence)defaultValue) && defaultValue.matches(pattern) ? defaultValue : fallBack;
    }

    private WebAppConfiguration getWebAppConfiguration() throws AzureExecutionException {
        this.validateConfiguration(message -> AzureMessager.getMessager().warning(message.getMessage()), false);
        return this.getConfigParser().getWebAppConfiguration();
    }

    private WebAppConfiguration chooseExistingWebappForConfiguration() throws AzureAuthFailureException {
        try {
            AzureAppService az = this.initAzureAppServiceClient();
            if (Objects.isNull(az)) {
                return null;
            }
            log.info(LONG_LOADING_HINT);
            ((WebAppServiceSubscription)Objects.requireNonNull((AppServiceServiceSubscription)((AzureWebApp)Azure.az(AzureWebApp.class)).get(this.subscriptionId, null), "You are not signed-in")).loadRuntimes();
            List apps = ((Stream)az.list().stream().flatMap(m -> m.webApps().list().stream()).parallel()).filter(webApp -> webApp.getRuntime() != null).filter(webApp -> {
                WebAppRuntime runtime = webApp.getRuntime();
                if (Utils.isJarPackagingProject((String)this.project.getPackaging())) {
                    return runtime.isJavaSE();
                }
                if (Utils.isWarPackagingProject((String)this.project.getPackaging())) {
                    return runtime.isTomcat() || runtime.isJBoss();
                }
                if (Utils.isEarPackagingProject((String)this.project.getPackaging())) {
                    return runtime.isJBoss();
                }
                return runtime.isDocker();
            }).collect(Collectors.toList());
            if (apps.isEmpty()) {
                log.warn(NO_JAVA_WEB_APPS);
                return null;
            }
            List appNames = apps.stream().map(app -> String.format("%s (%s)", app.getName(), app.getRuntime().getDisplayName())).collect(Collectors.toList());
            String appText = this.queryer.assureInputFromUser("webApp", (String)appNames.get(0), appNames, String.format("select a Azure Web App: [%s]", appNames.get(0)));
            String[] parts = appText.split(" \\(", 2);
            WebApp webapp = apps.stream().filter(app -> app.getName().equalsIgnoreCase(parts[0].trim())).findFirst().orElse(null);
            if (webapp == null) {
                return null;
            }
            this.subscriptionId = webapp.getSubscriptionId();
            WebAppConfiguration.WebAppConfigurationBuilder<?, ?> builder = WebAppConfiguration.builder();
            if (!AppServiceUtils.isDockerAppService((AppServiceAppBase)webapp)) {
                builder.resources(Deployment.getDefaultDeploymentConfiguration(this.getProject().getPackaging()).getResources());
            }
            return this.getConfigurationFromExisting(webapp, builder);
        }
        catch (AzureToolkitAuthenticationException ex) {
            this.getLog().warn((CharSequence)String.format("Cannot authenticate due to error: %s, select existing webapp is skipped.", ex.getMessage()));
            return null;
        }
    }

    private WebAppConfiguration getConfigurationFromExisting(WebApp webapp, WebAppConfiguration.WebAppConfigurationBuilder<?, ?> builder) {
        AppServiceConfig appServiceConfig = AppServiceConfigUtils.fromAppService((AppServiceAppBase)webapp, (AppServicePlan)webapp.getAppServicePlan());
        ((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)builder.appName(appServiceConfig.appName())).resourceGroup(appServiceConfig.resourceGroup())).subscriptionId(appServiceConfig.subscriptionId())).region(appServiceConfig.region());
        builder.os(appServiceConfig.runtime().os());
        if (AppServiceUtils.isDockerAppService((AppServiceAppBase)webapp)) {
            Map settings = webapp.getAppSettings();
            builder.image(appServiceConfig.runtime().image());
            builder.registryUrl(appServiceConfig.runtime().registryUrl());
            String dockerUsernameSetting = (String)settings.get(SETTING_REGISTRY_USERNAME);
            if (StringUtils.isNotBlank((CharSequence)dockerUsernameSetting)) {
                builder.serverId(String.format(SERVER_ID_TEMPLATE, dockerUsernameSetting));
            }
        } else {
            WebAppRuntime runtime = webapp.getRuntime();
            if (runtime != null) {
                builder.webContainer(runtime.getContainerUserText());
                builder.javaVersion(runtime.getJavaVersionUserText());
            }
        }
        builder.servicePlanName(appServiceConfig.servicePlanName());
        builder.servicePlanResourceGroup(appServiceConfig.servicePlanResourceGroup());
        builder.pricingTier(Objects.toString(appServiceConfig.pricingTier()));
        return builder.build();
    }

    static {
        ConfigMojo.ajc$preClinit();
        log = LoggerFactory.getLogger(ConfigMojo.class);
        configTypes = new String[]{"Application", "Runtime", "DeploymentSlot"};
        WEB_APP_PROPERTIES = Arrays.asList("resourceGroup", "appName", "runtime", "deployment", "region", "appServicePlanResourceGroup", "appServicePlanName", "deploymentSlot");
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ConfigMojo.java", ConfigMojo.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "doExecute", "com.microsoft.azure.maven.webapp.ConfigMojo", "", "", "", "void"), 92);
    }
}

