/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsMapper;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsSchema;
import com.microsoft.azure.maven.model.DeploymentResource;
import com.microsoft.azure.maven.webapp.AbstractWebAppMojo;
import com.microsoft.azure.maven.webapp.task.DeployExternalResourcesTask;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceAppBase;
import com.microsoft.azure.toolkit.lib.appservice.config.AppServiceConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion;
import com.microsoft.azure.toolkit.lib.appservice.model.PricingTier;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.model.WebAppArtifact;
import com.microsoft.azure.toolkit.lib.appservice.model.WebContainer;
import com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.task.CreateOrUpdateWebAppTask;
import com.microsoft.azure.toolkit.lib.appservice.task.DeployWebAppTask;
import com.microsoft.azure.toolkit.lib.appservice.task.StreamingLogTask;
import com.microsoft.azure.toolkit.lib.appservice.utils.AppServiceConfigUtils;
import com.microsoft.azure.toolkit.lib.appservice.webapp.AzureWebApp;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebApp;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebAppBase;
import com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.DEPLOY)
public class DeployMojo
extends AbstractWebAppMojo {
    @Parameter(property="webapp.waitDeploymentComplete")
    protected Boolean waitDeploymentComplete;
    @Parameter(property="webapp.deploymentStatusRefreshInterval")
    protected Long deploymentStatusRefreshInterval;
    @Parameter(property="webapp.deploymentStatusMaxRefreshTimes")
    protected Long deploymentStatusMaxRefreshTimes;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @AzureOperation(name="user/webapp.deploy_app")
    protected void doExecute() throws AzureExecutionException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            this.mergeCommandLineConfig();
            this.doValidate();
            this.az = this.initAzureAppServiceClient();
            AppServiceConfig appServiceConfig = this.getConfigParser().getAppServiceConfig();
            WebApp app = (WebApp)((AzureWebApp)Azure.az(AzureWebApp.class)).webApps(appServiceConfig.subscriptionId()).getOrDraft(appServiceConfig.appName(), appServiceConfig.resourceGroup());
            try {
                WebAppBase<?, ?, ?> target = this.createOrUpdateResource((WebAppBase<?, ?, ?>)app);
                this.deployExternalResources(target, this.getConfigParser().getExternalArtifacts());
                this.deploy(target, this.getConfigParser().getArtifacts());
            }
            catch (Exception e) {
                new StreamingLogTask((AppServiceAppBase)app).execute();
                throw new AzureToolkitRuntimeException((Throwable)e);
            }
            this.updateTelemetryProperties();
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private void doValidate() throws AzureExecutionException {
        this.validateConfiguration(message -> AzureMessager.getMessager().error(message.getMessage()), true);
        this.validateArtifactCompileVersion();
    }

    private void validateArtifactCompileVersion() throws AzureExecutionException {
        Runtime runtime = this.getConfigParser().getRuntime();
        List artifacts = Optional.ofNullable(this.getConfigParser().getArtifacts()).orElse(Collections.emptyList());
        if (Objects.isNull(runtime) || runtime.isDocker() || CollectionUtils.isEmpty(artifacts)) {
            return;
        }
        String javaVersion = Optional.ofNullable(runtime.getJavaVersion()).map(JavaVersion::getValue).orElse("");
        artifacts.stream().map(WebAppArtifact::getFile).filter(Objects::nonNull).forEach(artifact -> DeployMojo.validateArtifactCompileVersion((String)javaVersion, (File)artifact, (boolean)this.getFailsOnRuntimeValidationError()));
    }

    private void mergeCommandLineConfig() {
        try {
            JavaPropsMapper mapper = new JavaPropsMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            DeployMojo commandLineConfig = (DeployMojo)((Object)mapper.readSystemPropertiesAs(JavaPropsSchema.emptySchema(), DeployMojo.class));
            Utils.copyProperties((Object)((Object)this), (Object)((Object)commandLineConfig), (boolean)false);
        }
        catch (IOException | IllegalAccessException e) {
            throw new AzureToolkitRuntimeException("failed to merge command line configuration", (Throwable)e);
        }
    }

    private WebAppBase<?, ?, ?> createOrUpdateResource(WebAppBase<?, ?, ?> app) throws AzureExecutionException {
        boolean skipCreate = this.skipAzureResourceCreate != false || BooleanUtils.isTrue((Boolean)this.skipCreateAzureResource);
        AppServiceConfig appServiceConfig = this.getConfigParser().getAppServiceConfig();
        AppServiceConfig defaultConfig = app.exists() ? AppServiceConfigUtils.fromAppService(app, (AppServicePlan)Objects.requireNonNull(app.getAppServicePlan())) : this.buildDefaultConfig(appServiceConfig.subscriptionId(), appServiceConfig.resourceGroup(), appServiceConfig.appName());
        AppServiceConfigUtils.mergeAppServiceConfig((AppServiceConfig)appServiceConfig, (AppServiceConfig)defaultConfig);
        if (appServiceConfig.pricingTier() == null) {
            appServiceConfig.pricingTier(appServiceConfig.runtime().webContainer() == WebContainer.JBOSS_7 ? PricingTier.PREMIUM_P1V3 : PricingTier.PREMIUM_P1V2);
        }
        CreateOrUpdateWebAppTask task = new CreateOrUpdateWebAppTask(appServiceConfig);
        task.setSkipCreateAzureResource(skipCreate);
        return task.doExecute();
    }

    private AppServiceConfig buildDefaultConfig(String subscriptionId, String resourceGroup, String appName) {
        return AppServiceConfigUtils.buildDefaultWebAppConfig((String)subscriptionId, (String)resourceGroup, (String)appName, (String)this.project.getPackaging(), (JavaVersion)JavaVersion.JAVA_17);
    }

    private void deploy(WebAppBase<?, ?, ?> target, List<WebAppArtifact> artifacts) {
        DeployWebAppTask deployWebAppTask = new DeployWebAppTask(target, artifacts, this.getRestartSite().booleanValue(), this.getWaitDeploymentComplete(), true);
        Optional.ofNullable(this.getDeploymentStatusRefreshInterval()).ifPresent(arg_0 -> ((DeployWebAppTask)deployWebAppTask).setDeploymentStatusRefreshInterval(arg_0));
        Optional.ofNullable(this.getDeploymentStatusMaxRefreshTimes()).ifPresent(arg_0 -> ((DeployWebAppTask)deployWebAppTask).setDeploymentStatusMaxRefreshTimes(arg_0));
        deployWebAppTask.doExecute();
    }

    private void deployExternalResources(WebAppBase<?, ?, ?> target, List<DeploymentResource> resources) {
        new DeployExternalResourcesTask(target, resources).doExecute();
    }

    public Boolean getWaitDeploymentComplete() {
        return this.waitDeploymentComplete;
    }

    public Long getDeploymentStatusRefreshInterval() {
        return this.deploymentStatusRefreshInterval;
    }

    public Long getDeploymentStatusMaxRefreshTimes() {
        return this.deploymentStatusMaxRefreshTimes;
    }

    static {
        DeployMojo.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DeployMojo.java", DeployMojo.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "doExecute", "com.microsoft.azure.maven.webapp.DeployMojo", "", "", "com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException", "void"), 82);
    }
}

