/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.parser;

import com.microsoft.azure.management.appservice.JavaVersion;
import com.microsoft.azure.management.appservice.RuntimeStack;
import com.microsoft.azure.management.appservice.WebContainer;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.maven.webapp.AbstractWebAppMojo;
import com.microsoft.azure.maven.webapp.configuration.ContainerSetting;
import com.microsoft.azure.maven.webapp.configuration.OperatingSystemEnum;
import com.microsoft.azure.maven.webapp.parser.ConfigurationParser;
import com.microsoft.azure.maven.webapp.utils.RuntimeStackUtils;
import com.microsoft.azure.maven.webapp.validator.AbstractConfigurationValidator;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.StringUtils;

public class V1ConfigurationParser
extends ConfigurationParser {
    private static final String RUNTIME_NOT_EXIST = "The configuration of <linuxRuntime> in pom.xml is not correct. Please refer https://aka.ms/maven_webapp_runtime_v1 for more information";

    public V1ConfigurationParser(AbstractWebAppMojo mojo, AbstractConfigurationValidator validator) {
        super(mojo, validator);
    }

    @Override
    public OperatingSystemEnum getOs() throws MojoExecutionException {
        this.validate(this.validator.validateOs());
        String linuxRuntime = this.mojo.getLinuxRuntime();
        String javaVersion = this.mojo.getJavaVersion();
        ContainerSetting containerSetting = this.mojo.getContainerSettings();
        boolean isContainerSettingEmpty = containerSetting == null || containerSetting.isEmpty();
        ArrayList<OperatingSystemEnum> osList = new ArrayList<OperatingSystemEnum>();
        if (javaVersion != null) {
            osList.add(OperatingSystemEnum.Windows);
        }
        if (linuxRuntime != null) {
            osList.add(OperatingSystemEnum.Linux);
        }
        if (!isContainerSettingEmpty) {
            osList.add(OperatingSystemEnum.Docker);
        }
        return osList.size() > 0 ? (OperatingSystemEnum)((Object)osList.get(0)) : null;
    }

    @Override
    protected Region getRegion() throws MojoExecutionException {
        this.validate(this.validator.validateRegion());
        if (StringUtils.isEmpty((String)this.mojo.getRegion())) {
            return Region.EUROPE_WEST;
        }
        return Region.fromName((String)this.mojo.getRegion());
    }

    @Override
    public RuntimeStack getRuntimeStack() throws MojoExecutionException {
        this.validate(this.validator.validateRuntimeStack());
        String linuxRuntime = this.mojo.getLinuxRuntime();
        RuntimeStack javaSERuntimeStack = RuntimeStackUtils.getRuntimeStack(linuxRuntime);
        if (javaSERuntimeStack != null) {
            return javaSERuntimeStack;
        }
        List<RuntimeStack> runtimeStacks = RuntimeStackUtils.getValidRuntimeStacks();
        for (RuntimeStack runtimeStack : runtimeStacks) {
            if (!runtimeStack.toString().equalsIgnoreCase(this.mojo.getLinuxRuntime())) continue;
            return runtimeStack;
        }
        throw new MojoExecutionException(RUNTIME_NOT_EXIST);
    }

    @Override
    public String getImage() throws MojoExecutionException {
        this.validate(this.validator.validateImage());
        ContainerSetting containerSetting = this.mojo.getContainerSettings();
        return containerSetting.getImageName();
    }

    @Override
    public String getServerId() {
        ContainerSetting containerSetting = this.mojo.getContainerSettings();
        if (containerSetting == null) {
            return null;
        }
        return containerSetting.getServerId();
    }

    @Override
    public String getRegistryUrl() {
        ContainerSetting containerSetting = this.mojo.getContainerSettings();
        if (containerSetting == null) {
            return null;
        }
        return containerSetting.getRegistryUrl();
    }

    @Override
    protected String getSchemaVersion() {
        return "V1";
    }

    @Override
    public WebContainer getWebContainer() throws MojoExecutionException {
        this.validate(this.validator.validateWebContainer());
        return this.mojo.getJavaWebContainer();
    }

    @Override
    public JavaVersion getJavaVersion() throws MojoExecutionException {
        this.validate(this.validator.validateJavaVersion());
        return JavaVersion.fromString((String)this.mojo.getJavaVersion());
    }

    @Override
    public List<Resource> getResources() {
        return this.mojo.getResources();
    }
}

