/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.handlers.runtime;

import com.microsoft.azure.management.appservice.AppServicePlan;
import com.microsoft.azure.management.appservice.OperatingSystem;
import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.maven.Utils;
import com.microsoft.azure.maven.webapp.handlers.runtime.BaseRuntimeHandler;
import com.microsoft.azure.maven.webapp.utils.WebAppUtils;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;

public class PrivateRegistryRuntimeHandlerImpl
extends BaseRuntimeHandler {
    private PrivateRegistryRuntimeHandlerImpl(Builder builder) {
        super(builder);
    }

    @Override
    public WebApp.DefinitionStages.WithCreate defineAppWithRuntime() throws Exception {
        Server server = Utils.getServer((Settings)this.settings, (String)this.serverId);
        Utils.assureServerExist((Server)server, (String)this.serverId);
        AppServicePlan plan = this.createOrGetAppServicePlan();
        return WebAppUtils.defineLinuxApp(this.resourceGroup, this.appName, this.azure, plan).withPrivateRegistryImage(this.image, this.registryUrl).withCredentials(server.getUsername(), server.getPassword());
    }

    @Override
    public WebApp.Update updateAppRuntime(WebApp app) throws Exception {
        WebAppUtils.assureLinuxWebApp(app);
        WebAppUtils.clearTags(app);
        Server server = Utils.getServer((Settings)this.settings, (String)this.serverId);
        Utils.assureServerExist((Server)server, (String)this.serverId);
        return ((WebApp.Update)app.update()).withPrivateRegistryImage(this.image, this.registryUrl).withCredentials(server.getUsername(), server.getPassword());
    }

    @Override
    protected OperatingSystem getAppServicePlatform() {
        return OperatingSystem.LINUX;
    }

    public static class Builder
    extends BaseRuntimeHandler.Builder<Builder> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PrivateRegistryRuntimeHandlerImpl build() {
            return new PrivateRegistryRuntimeHandlerImpl(this);
        }
    }
}

