/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.handlers.runtime;

import com.microsoft.azure.management.Azure;
import com.microsoft.azure.management.appservice.AppServicePlan;
import com.microsoft.azure.management.appservice.JavaVersion;
import com.microsoft.azure.management.appservice.OperatingSystem;
import com.microsoft.azure.management.appservice.PricingTier;
import com.microsoft.azure.management.appservice.RuntimeStack;
import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.management.appservice.WebContainer;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.maven.webapp.handlers.RuntimeHandler;
import com.microsoft.azure.maven.webapp.utils.WebAppUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.StringUtils;

public abstract class BaseRuntimeHandler
implements RuntimeHandler {
    protected RuntimeStack runtime;
    protected JavaVersion javaVersion;
    protected WebContainer webContainer;
    protected String appName;
    protected String resourceGroup;
    protected Region region;
    protected PricingTier pricingTier;
    protected String servicePlanName;
    protected String servicePlanResourceGroup;
    protected Azure azure;
    protected Settings settings;
    protected String image;
    protected String serverId;
    protected String registryUrl;
    protected Log log;

    @Override
    public AppServicePlan updateAppServicePlan(WebApp app) throws Exception {
        AppServicePlan appServicePlan = WebAppUtils.getAppServicePlanByWebApp(app);
        if (StringUtils.isNotEmpty((String)this.servicePlanName) && !this.servicePlanName.equals(appServicePlan.name()) || StringUtils.isNotEmpty((String)this.servicePlanResourceGroup) && !this.servicePlanResourceGroup.equals(appServicePlan.resourceGroupName())) {
            AppServicePlan newAppServicePlan = this.createOrGetAppServicePlan();
            ((WebApp.Update)app.update()).withExistingAppServicePlan(newAppServicePlan).apply();
            return WebAppUtils.updateAppServicePlan(newAppServicePlan, this.pricingTier, this.log);
        }
        return WebAppUtils.updateAppServicePlan(appServicePlan, this.pricingTier, this.log);
    }

    protected abstract OperatingSystem getAppServicePlatform();

    protected BaseRuntimeHandler(Builder<?> builder) {
        this.runtime = ((Builder)builder).runtime;
        this.javaVersion = builder.javaVersion;
        this.webContainer = builder.webContainer;
        this.appName = ((Builder)builder).appName;
        this.resourceGroup = ((Builder)builder).resourceGroup;
        this.region = ((Builder)builder).region;
        this.pricingTier = ((Builder)builder).pricingTier;
        this.servicePlanName = ((Builder)builder).servicePlanName;
        this.servicePlanResourceGroup = ((Builder)builder).servicePlanResourceGroup;
        this.azure = ((Builder)builder).azure;
        this.settings = ((Builder)builder).settings;
        this.image = builder.image;
        this.serverId = builder.serverId;
        this.registryUrl = builder.registryUrl;
        this.log = ((Builder)builder).log;
    }

    protected AppServicePlan createOrGetAppServicePlan() throws MojoExecutionException {
        return WebAppUtils.createOrGetAppServicePlan(this.servicePlanName, this.resourceGroup, this.azure, this.servicePlanResourceGroup, this.region, this.pricingTier, this.log, this.getAppServicePlatform());
    }

    public static abstract class Builder<T extends Builder<T>> {
        private RuntimeStack runtime;
        protected JavaVersion javaVersion;
        protected WebContainer webContainer;
        private String appName;
        private String resourceGroup;
        private Region region;
        private PricingTier pricingTier;
        private String servicePlanName;
        private String servicePlanResourceGroup;
        private Azure azure;
        private Settings settings;
        protected String image;
        protected String serverId;
        protected String registryUrl;
        private Log log;

        public T runtime(RuntimeStack value) {
            this.runtime = value;
            return this.self();
        }

        public T appName(String value) {
            this.appName = value;
            return this.self();
        }

        public T resourceGroup(String value) {
            this.resourceGroup = value;
            return this.self();
        }

        public T region(Region value) {
            this.region = value;
            return this.self();
        }

        public T pricingTier(PricingTier value) {
            this.pricingTier = value;
            return this.self();
        }

        public T servicePlanName(String value) {
            this.servicePlanName = value;
            return this.self();
        }

        public T servicePlanResourceGroup(String value) {
            this.servicePlanResourceGroup = value;
            return this.self();
        }

        public T azure(Azure value) {
            this.azure = value;
            return this.self();
        }

        public T mavenSettings(Settings value) {
            this.settings = value;
            return this.self();
        }

        public T log(Log value) {
            this.log = value;
            return this.self();
        }

        public T image(String value) {
            this.image = value;
            return this.self();
        }

        public T serverId(String value) {
            this.serverId = value;
            return this.self();
        }

        public T registryUrl(String value) {
            this.registryUrl = value;
            return this.self();
        }

        public T javaVersion(JavaVersion value) {
            this.javaVersion = value;
            return this.self();
        }

        public T webContainer(WebContainer value) {
            this.webContainer = value;
            return this.self();
        }

        public abstract BaseRuntimeHandler build();

        protected abstract T self();
    }
}

