/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.handlers.artifact;

import com.google.common.io.Files;
import com.microsoft.azure.maven.deploytarget.DeployTarget;
import com.microsoft.azure.maven.webapp.deploytarget.DeploymentSlotDeployTarget;
import com.microsoft.azure.maven.webapp.deploytarget.WebAppDeployTarget;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.StringUtils;

public class ArtifactHandlerUtils {
    public static Runnable getRealWarDeployExecutor(final DeployTarget target, final File war, final String path) throws MojoExecutionException {
        if (target instanceof WebAppDeployTarget) {
            return new Runnable(){

                @Override
                public void run() {
                    ((WebAppDeployTarget)target).warDeploy(war, path);
                }
            };
        }
        if (target instanceof DeploymentSlotDeployTarget) {
            return new Runnable(){

                @Override
                public void run() {
                    ((DeploymentSlotDeployTarget)target).warDeploy(war, path);
                }
            };
        }
        throw new MojoExecutionException("The type of deploy target is unknown, supported types are WebApp and DeploymentSlot.");
    }

    public static boolean performActionWithRetry(Runnable runnable, int maxRetryTimes, Log log) {
        for (int retryCount = 0; retryCount < maxRetryTimes; ++retryCount) {
            try {
                runnable.run();
                return true;
            }
            catch (Exception e) {
                log.info((CharSequence)String.format("Exception occurred during deployment: %s, retry immediately(%d/%d)...", e.getMessage(), retryCount, maxRetryTimes));
                continue;
            }
        }
        return false;
    }

    public static String getContextPathFromFileName(String stagingDirectoryPath, String filePath) throws MojoExecutionException {
        if (StringUtils.isEmpty((String)stagingDirectoryPath)) {
            throw new MojoExecutionException("Can not get the context path because the staging directory path is null or empty. .");
        }
        if (StringUtils.isEmpty((String)filePath)) {
            throw new MojoExecutionException("Can not get the context path because the file path is null or empty");
        }
        return Paths.get(stagingDirectoryPath, new String[0]).relativize(Paths.get(filePath, new String[0]).getParent()).toString();
    }

    public static List<File> getArtifactsRecursively(File directory) {
        ArrayList<File> files = new ArrayList<File>();
        if (directory.isDirectory()) {
            File[] subDirectories = directory.listFiles();
            if (subDirectories != null) {
                for (File f : subDirectories) {
                    files.addAll(ArtifactHandlerUtils.getArtifactsRecursively(f));
                }
            }
        } else {
            files.add(directory);
        }
        return files;
    }

    public static boolean areAllWarFiles(List<File> allArtifacts) {
        for (File artifacts : allArtifacts) {
            if ("war".equalsIgnoreCase(Files.getFileExtension((String)artifacts.getName()))) continue;
            return false;
        }
        return true;
    }

    public static boolean hasWarFiles(List<File> allArtifacts) {
        for (File artifacts : allArtifacts) {
            if (!"war".equalsIgnoreCase(Files.getFileExtension((String)artifacts.getName()))) continue;
            return true;
        }
        return false;
    }
}

