/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.handlers.artifact;

import com.microsoft.azure.maven.artifacthandler.ArtifactHandlerBase;
import com.microsoft.azure.maven.deploytarget.DeployTarget;
import com.microsoft.azure.maven.webapp.configuration.OperatingSystemEnum;
import com.microsoft.azure.maven.webapp.configuration.RuntimeSetting;
import com.microsoft.azure.maven.webapp.handlers.artifact.ArtifactHandlerUtils;
import com.microsoft.azure.maven.webapp.utils.WebAppUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Scanner;
import org.apache.maven.plugin.MojoExecutionException;
import org.zeroturnaround.zip.ZipUtil;

public class ArtifactHandlerImplV2
extends ArtifactHandlerBase {
    private static final int MAX_RETRY_TIMES = 3;
    private static final String ALWAYS_DEPLOY_PROPERTY = "alwaysDeploy";
    public static final String DEFAULT_LINUX_JAR_NAME = "app.jar";
    public static final String RENAMING_MESSAGE = "Renaming %s to %s";
    private RuntimeSetting runtimeSetting;

    protected ArtifactHandlerImplV2(Builder builder) {
        super((ArtifactHandlerBase.Builder)builder);
        this.runtimeSetting = builder.getRuntimeSetting();
    }

    public void publish(DeployTarget target) throws MojoExecutionException, IOException {
        if (this.resources == null || this.resources.size() < 1) {
            this.log.warn((CharSequence)"No <resources> is found in <deployment> element in pom.xml, skip deployment.");
            return;
        }
        this.copyArtifactsToStagingDirectory();
        List<File> allArtifacts = this.getAllArtifacts(this.stagingDirectoryPath);
        if (allArtifacts.size() == 0) {
            String absolutePath = new File(this.stagingDirectoryPath).getAbsolutePath();
            throw new MojoExecutionException(String.format("There is no artifact to deploy in staging directory: '%s'", absolutePath));
        }
        this.log.info((CharSequence)String.format("Trying to deploy artifact to %s...", target.getName()));
        if (ArtifactHandlerUtils.areAllWarFiles(allArtifacts)) {
            this.publishArtifactsViaWarDeploy(target, this.stagingDirectoryPath, allArtifacts);
            this.log.info((CharSequence)String.format("Successfully deployed the artifact to https://%s", target.getDefaultHostName()));
            return;
        }
        if (!ArtifactHandlerUtils.hasWarFiles(allArtifacts)) {
            this.publishArtifactsViaZipDeploy(target, this.stagingDirectoryPath);
            this.log.info((CharSequence)String.format("Successfully deployed the artifact to https://%s", target.getDefaultHostName()));
            return;
        }
        if (this.isDeployMixedArtifactsConfirmed()) {
            this.publishArtifactsViaZipDeploy(target, this.stagingDirectoryPath);
            this.log.info((CharSequence)String.format("Successfully deployed the artifact to https://%s", target.getDefaultHostName()));
        } else {
            this.log.info((CharSequence)"Deployment is aborted.");
        }
    }

    protected boolean isDeployMixedArtifactsConfirmed() {
        String input;
        if ("true".equalsIgnoreCase(System.getProperty(ALWAYS_DEPLOY_PROPERTY))) {
            return true;
        }
        this.log.info((CharSequence)String.format("To get rid of the following message, set the property %s to true to always proceed with the deploy.", ALWAYS_DEPLOY_PROPERTY));
        Scanner scanner = new Scanner(System.in, "UTF-8");
        do {
            this.log.warn((CharSequence)"Deploying war along with other kinds of artifacts might make the web app inaccessible, are you sure to proceed (y/n)?");
            input = scanner.nextLine();
            if (!"y".equalsIgnoreCase(input)) continue;
            return true;
        } while (!"n".equalsIgnoreCase(input));
        return false;
    }

    protected List<File> getAllArtifacts(String stagingDirectoryPath) {
        File stagingDirectory = new File(stagingDirectoryPath);
        return ArtifactHandlerUtils.getArtifactsRecursively(stagingDirectory);
    }

    protected void copyArtifactsToStagingDirectory() throws IOException, MojoExecutionException {
        this.prepareResources();
        this.assureStagingDirectoryNotEmpty();
    }

    protected void publishArtifactsViaZipDeploy(final DeployTarget target, String stagingDirectoryPath) throws MojoExecutionException {
        if (this.isJavaSERuntime()) {
            this.prepareJavaSERuntime(this.getAllArtifacts(stagingDirectoryPath), target);
        }
        File stagingDirectory = new File(stagingDirectoryPath);
        final File zipFile = new File(stagingDirectoryPath + ".zip");
        ZipUtil.pack((File)stagingDirectory, (File)zipFile);
        this.log.info((CharSequence)String.format("Deploying the zip package %s...", zipFile.getName()));
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                target.zipDeploy(zipFile);
            }
        };
        boolean deploySuccess = ArtifactHandlerUtils.performActionWithRetry(runnable, 3, this.log);
        if (!deploySuccess) {
            throw new MojoExecutionException(String.format("The zip deploy failed after %d times of retry.", 4));
        }
    }

    protected void publishArtifactsViaWarDeploy(DeployTarget target, String stagingDirectoryPath, List<File> warArtifacts) throws MojoExecutionException {
        if (warArtifacts == null || warArtifacts.size() == 0) {
            throw new MojoExecutionException(String.format("There is no war artifacts to deploy in staging path %s.", stagingDirectoryPath));
        }
        for (File warArtifact : warArtifacts) {
            String contextPath = ArtifactHandlerUtils.getContextPathFromFileName(stagingDirectoryPath, warArtifact.getAbsolutePath());
            this.publishWarArtifact(target, warArtifact, contextPath);
        }
    }

    public void publishWarArtifact(DeployTarget target, File warArtifact, String contextPath) throws MojoExecutionException {
        Runnable executor = ArtifactHandlerUtils.getRealWarDeployExecutor(target, warArtifact, contextPath);
        this.log.info((CharSequence)String.format("Deploying the war file %s...", warArtifact.getName()));
        boolean deploySuccess = ArtifactHandlerUtils.performActionWithRetry(executor, 3, this.log);
        if (!deploySuccess) {
            throw new MojoExecutionException(String.format("Failed to deploy war file after %d times of retry.", 3));
        }
    }

    private boolean isJavaSERuntime() throws MojoExecutionException {
        return this.runtimeSetting != null && (this.runtimeSetting.getOsEnum() == OperatingSystemEnum.Windows && this.project.getPackaging().equals("jar") || this.runtimeSetting.getOsEnum() == OperatingSystemEnum.Linux && this.runtimeSetting.getLinuxRuntime().stack().equalsIgnoreCase("JAVA"));
    }

    private File getProjectJarArtifact(List<File> artifacts) {
        String finalName = this.project.getBuild().getFinalName();
        String fileName = String.format("%s.%s", finalName, this.project.getPackaging());
        for (File file : artifacts) {
            if (!file.getName().equals(fileName)) continue;
            return file;
        }
        return null;
    }

    private void prepareJavaSERuntime(List<File> artifacts, DeployTarget target) throws MojoExecutionException {
        File artifact = this.getProjectJarArtifact(artifacts);
        if (artifact == null) {
            return;
        }
        switch (this.runtimeSetting.getOsEnum()) {
            case Windows: {
                try {
                    WebAppUtils.generateWebConfigFile(target, artifact.getName(), this.stagingDirectoryPath, this.log);
                    break;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to generate web.config file");
                }
            }
            case Linux: {
                this.log.info((CharSequence)String.format(RENAMING_MESSAGE, artifact.getAbsolutePath(), DEFAULT_LINUX_JAR_NAME));
                artifact.renameTo(new File(artifact.getParent(), DEFAULT_LINUX_JAR_NAME));
                break;
            }
            default: {
                return;
            }
        }
    }

    public static class Builder
    extends ArtifactHandlerBase.Builder<Builder> {
        private RuntimeSetting runtimeSetting;

        public RuntimeSetting getRuntimeSetting() {
            return this.runtimeSetting;
        }

        protected Builder self() {
            return this;
        }

        public Builder runtime(RuntimeSetting runtimeSetting) {
            this.runtimeSetting = runtimeSetting;
            return this.self();
        }

        public ArtifactHandlerImplV2 build() {
            return new ArtifactHandlerImplV2(this);
        }
    }
}

