/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.serializer;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.StringUtils;
import com.microsoft.azure.maven.webapp.WebAppConfiguration;
import com.microsoft.azure.maven.webapp.utils.XMLUtils;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoFailureException;
import org.dom4j.Element;
import org.dom4j.dom.DOMElement;

public abstract class ConfigurationSerializer {
    final WebAppConfiguration newConfigs;
    final WebAppConfiguration oldConfigs;

    public ConfigurationSerializer(WebAppConfiguration newConfigs, WebAppConfiguration oldConfigs) {
        this.newConfigs = newConfigs;
        this.oldConfigs = oldConfigs == null ? new WebAppConfiguration.Builder().build() : oldConfigs;
    }

    public abstract void saveToXML(Element var1) throws MojoFailureException;

    protected DOMElement createResourcesNode(List<Resource> resources) {
        DOMElement resourceRootNode = new DOMElement("resources");
        for (Resource resource : resources) {
            DOMElement resourceNode = new DOMElement("resource");
            XMLUtils.addNotEmptyElement((Element)resourceNode, "filtering", resource.getFiltering());
            XMLUtils.addNotEmptyElement((Element)resourceNode, "mergeId", resource.getMergeId());
            XMLUtils.addNotEmptyElement((Element)resourceNode, "targetPath", resource.getTargetPath());
            XMLUtils.addNotEmptyElement((Element)resourceNode, "directory", resource.getDirectory());
            XMLUtils.addNotEmptyListElement((Element)resourceNode, "includes", "include", resource.getIncludes());
            XMLUtils.addNotEmptyListElement((Element)resourceNode, "excludes", "exclude", resource.getExcludes());
            resourceRootNode.add((Element)resourceNode);
        }
        return resourceRootNode;
    }

    protected void createOrUpdateAttribute(String attribute, String value, String oldValue, Element element) {
        if (value == null || StringUtils.equals((CharSequence)value, (CharSequence)oldValue)) {
            return;
        }
        XMLUtils.setChildValue(attribute, value, element);
    }
}

