/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.parser;

import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.maven.MavenDockerCredentialProvider;
import com.microsoft.azure.maven.webapp.AbstractWebAppMojo;
import com.microsoft.azure.maven.webapp.configuration.MavenRuntimeConfig;
import com.microsoft.azure.maven.webapp.parser.AbstractConfigParser;
import com.microsoft.azure.maven.webapp.validator.AbstractConfigurationValidator;
import com.microsoft.azure.toolkits.appservice.model.DockerConfiguration;
import com.microsoft.azure.toolkits.appservice.model.JavaVersion;
import com.microsoft.azure.toolkits.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkits.appservice.model.Runtime;
import com.microsoft.azure.toolkits.appservice.model.WebAppArtifact;
import com.microsoft.azure.toolkits.appservice.model.WebContainer;
import com.microsoft.azure.tools.common.model.Region;
import java.util.Collections;
import java.util.List;

public class V2ConfigParser
extends AbstractConfigParser {
    public V2ConfigParser(AbstractWebAppMojo mojo, AbstractConfigurationValidator validator) {
        super(mojo, validator);
    }

    @Override
    public Region getRegion() throws AzureExecutionException {
        this.validate(this.validator::validateRegion);
        return Region.fromName((String)this.mojo.getRegion());
    }

    @Override
    public DockerConfiguration getDockerConfiguration() throws AzureExecutionException {
        MavenRuntimeConfig runtime = this.mojo.getRuntime();
        if (runtime == null) {
            return null;
        }
        OperatingSystem os = this.getOs(runtime);
        if (os != OperatingSystem.DOCKER) {
            return null;
        }
        this.validate(this.validator::validateImage);
        MavenDockerCredentialProvider credentialProvider = this.getDockerCredential(runtime.getServerId());
        return DockerConfiguration.builder().registryUrl(runtime.getRegistryUrl()).image(runtime.getImage()).userName(credentialProvider.getUsername()).password(credentialProvider.getPassword()).build();
    }

    @Override
    public List<WebAppArtifact> getMavenArtifacts() throws AzureExecutionException {
        if (this.mojo.getDeployment() == null || this.mojo.getDeployment().getResources() == null) {
            return Collections.EMPTY_LIST;
        }
        return V2ConfigParser.parseArtifactsFromResources(this.mojo.getDeployment().getResources());
    }

    @Override
    public Runtime getRuntime() throws AzureExecutionException {
        MavenRuntimeConfig runtime = this.mojo.getRuntime();
        if (runtime == null || runtime.isEmpty()) {
            return null;
        }
        OperatingSystem os = this.getOs(runtime);
        if (os == OperatingSystem.DOCKER) {
            return Runtime.DOCKER;
        }
        this.validate(this.validator::validateJavaVersion);
        this.validate(this.validator::validateWebContainer);
        this.validate(this.validator::validateRuntimeStack);
        JavaVersion javaVersion = JavaVersion.fromString((String)runtime.getJavaVersionRaw());
        WebContainer webContainer = WebContainer.fromString((String)runtime.getWebContainerRaw());
        return Runtime.getRuntime((OperatingSystem)os, (WebContainer)webContainer, (JavaVersion)javaVersion);
    }

    private OperatingSystem getOs(MavenRuntimeConfig runtime) throws AzureExecutionException {
        this.validate(this.validator::validateOs);
        return OperatingSystem.fromString((String)runtime.getOs());
    }
}

