/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp;

import com.microsoft.azure.common.appservice.DeploymentSlotSetting;
import com.microsoft.azure.common.appservice.OperatingSystemEnum;
import com.microsoft.azure.common.utils.AppServiceUtils;
import com.microsoft.azure.management.appservice.JavaVersion;
import com.microsoft.azure.management.appservice.PricingTier;
import com.microsoft.azure.management.appservice.RuntimeStack;
import com.microsoft.azure.management.appservice.WebContainer;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.maven.webapp.models.JavaVersionEnum;
import com.microsoft.azure.maven.webapp.utils.JavaVersionUtils;
import com.microsoft.azure.maven.webapp.utils.RuntimeStackUtils;
import com.microsoft.azure.maven.webapp.utils.WebContainerUtils;
import java.util.List;
import java.util.Objects;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;

public class WebAppConfiguration {
    public static final Region DEFAULT_REGION = Region.EUROPE_WEST;
    public static final PricingTier DEFAULT_PRICINGTIER = PricingTier.PREMIUM_P1V2;
    public static final JavaVersion DEFAULT_WINDOWS_JAVA_VERSION = JavaVersion.JAVA_8_NEWEST;
    public static final WebContainer DEFAULT_WINDOWS_WEB_CONTAINER = WebContainer.TOMCAT_8_5_NEWEST;
    public static final String DEFAULT_LINUX_JAVA_VERSION = JavaVersionEnum.JAVA_8.toString();
    public static final String DEFAULT_LINUX_WEB_CONTAINER = WebContainerUtils.formatWebContainer(WebContainer.TOMCAT_8_5_NEWEST);
    protected String subscriptionId;
    protected String appName;
    protected DeploymentSlotSetting deploymentSlotSetting;
    protected String resourceGroup;
    protected Region region;
    protected PricingTier pricingTier;
    protected String servicePlanName;
    protected String servicePlanResourceGroup;
    protected OperatingSystemEnum os;
    protected RuntimeStack runtimeStack;
    protected JavaVersion javaVersion;
    protected WebContainer webContainer;
    protected Settings mavenSettings;
    protected String image;
    protected String serverId;
    protected String registryUrl;
    protected String schemaVersion;
    protected List<Resource> resources;
    protected String stagingDirectoryPath;
    protected String buildDirectoryAbsolutePath;
    protected MavenProject project;
    protected MavenSession session;
    protected MavenResourcesFiltering filtering;

    private WebAppConfiguration(Builder builder) {
        this.appName = builder.appName;
        this.subscriptionId = builder.subscriptionId;
        this.resourceGroup = builder.resourceGroup;
        this.region = builder.region;
        this.pricingTier = builder.pricingTier;
        this.servicePlanName = builder.servicePlanName;
        this.servicePlanResourceGroup = builder.servicePlanResourceGroup;
        this.os = builder.os;
        this.runtimeStack = builder.runtimeStack;
        this.javaVersion = builder.javaVersion;
        this.webContainer = builder.webContainer;
        this.mavenSettings = builder.mavenSettings;
        this.image = builder.image;
        this.serverId = builder.serverId;
        this.registryUrl = builder.registryUrl;
        this.deploymentSlotSetting = builder.deploymentSlotSetting;
        this.schemaVersion = builder.schemaVersion;
        this.resources = builder.resources;
        this.stagingDirectoryPath = builder.stagingDirectoryPath;
        this.buildDirectoryAbsolutePath = builder.buildDirectoryAbsolutePath;
        this.project = builder.project;
        this.session = builder.session;
        this.filtering = builder.filtering;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getResourceGroup() {
        return this.resourceGroup;
    }

    public Region getRegion() {
        return this.region;
    }

    public PricingTier getPricingTier() {
        return this.pricingTier;
    }

    public String getServicePlanName() {
        return this.servicePlanName;
    }

    public String getServicePlanResourceGroup() {
        return this.servicePlanResourceGroup;
    }

    public OperatingSystemEnum getOs() {
        return this.os;
    }

    public RuntimeStack getRuntimeStack() {
        return this.runtimeStack;
    }

    public JavaVersion getJavaVersion() {
        return this.javaVersion;
    }

    public WebContainer getWebContainer() {
        return this.webContainer;
    }

    public Settings getMavenSettings() {
        return this.mavenSettings;
    }

    public String getImage() {
        return this.image;
    }

    public String getServerId() {
        return this.serverId;
    }

    public String getRegistryUrl() {
        return this.registryUrl;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public String getStagingDirectoryPath() {
        return this.stagingDirectoryPath;
    }

    public String getBuildDirectoryAbsolutePath() {
        return this.buildDirectoryAbsolutePath;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public MavenSession getSession() {
        return this.session;
    }

    public MavenResourcesFiltering getFiltering() {
        return this.filtering;
    }

    public DeploymentSlotSetting getDeploymentSlotSetting() {
        return this.deploymentSlotSetting;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public Builder getBuilderFromConfiguration() {
        return new Builder().appName(this.appName).subscriptionId(this.subscriptionId).resourceGroup(this.resourceGroup).region(this.region).pricingTier(this.pricingTier).servicePlanName(this.servicePlanName).servicePlanResourceGroup(this.servicePlanResourceGroup).os(this.os).runtimeStack(this.runtimeStack).javaVersion(this.javaVersion).webContainer(this.webContainer).mavenSettings(this.mavenSettings).image(this.image).serverId(this.serverId).registryUrl(this.registryUrl).resources(this.resources).stagingDirectoryPath(this.stagingDirectoryPath).buildDirectoryAbsolutePath(this.buildDirectoryAbsolutePath).project(this.project).session(this.session).filtering(this.filtering).schemaVersion(this.schemaVersion).deploymentSlotSetting(this.deploymentSlotSetting);
    }

    public String getRegionOrDefault() {
        return this.region != null ? this.region.toString() : DEFAULT_REGION.toString();
    }

    public String getPricingTierOrDefault() {
        return AppServiceUtils.convertPricingTierToString((PricingTier)(this.pricingTier != null ? this.pricingTier : DEFAULT_PRICINGTIER));
    }

    public String getLinuxJavaVersionOrDefault() {
        return this.runtimeStack == null ? DEFAULT_LINUX_JAVA_VERSION : RuntimeStackUtils.getJavaVersionFromRuntimeStack(this.runtimeStack);
    }

    public String getLinuxRuntimeStackOrDefault() {
        return this.runtimeStack == null ? DEFAULT_LINUX_WEB_CONTAINER : RuntimeStackUtils.getWebContainerFromRuntimeStack(this.runtimeStack);
    }

    public String getJavaVersionOrDefault() {
        return JavaVersionUtils.formatJavaVersion(Objects.nonNull(this.javaVersion) ? this.javaVersion : DEFAULT_WINDOWS_JAVA_VERSION);
    }

    public String getWebContainerOrDefault() {
        return WebContainerUtils.formatWebContainer(Objects.nonNull(this.webContainer) ? this.webContainer : DEFAULT_WINDOWS_WEB_CONTAINER);
    }

    public static class Builder {
        private String subscriptionId;
        private String appName;
        private String resourceGroup;
        private Region region;
        private PricingTier pricingTier;
        private String servicePlanName;
        private String servicePlanResourceGroup;
        private OperatingSystemEnum os;
        private RuntimeStack runtimeStack;
        private JavaVersion javaVersion;
        private WebContainer webContainer;
        private Settings mavenSettings;
        private String image;
        private String serverId;
        private String registryUrl;
        private List<Resource> resources;
        private String stagingDirectoryPath;
        private String buildDirectoryAbsolutePath;
        private MavenProject project;
        private MavenSession session;
        private MavenResourcesFiltering filtering;
        private DeploymentSlotSetting deploymentSlotSetting;
        private String schemaVersion;

        protected Builder self() {
            return this;
        }

        public WebAppConfiguration build() {
            return new WebAppConfiguration(this);
        }

        public Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this.self();
        }

        public Builder appName(String value) {
            this.appName = value;
            return this.self();
        }

        public Builder resourceGroup(String value) {
            this.resourceGroup = value;
            return this.self();
        }

        public Builder region(Region value) {
            this.region = value;
            return this.self();
        }

        public Builder pricingTier(PricingTier value) {
            this.pricingTier = value;
            return this.self();
        }

        public Builder servicePlanName(String value) {
            this.servicePlanName = value;
            return this.self();
        }

        public Builder servicePlanResourceGroup(String value) {
            this.servicePlanResourceGroup = value;
            return this.self();
        }

        public Builder os(OperatingSystemEnum value) {
            this.os = value;
            return this.self();
        }

        public Builder runtimeStack(RuntimeStack value) {
            this.runtimeStack = value;
            return this.self();
        }

        public Builder javaVersion(JavaVersion value) {
            this.javaVersion = value;
            return this.self();
        }

        public Builder webContainer(WebContainer value) {
            this.webContainer = value;
            return this.self();
        }

        public Builder mavenSettings(Settings value) {
            this.mavenSettings = value;
            return this.self();
        }

        public Builder image(String value) {
            this.image = value;
            return this.self();
        }

        public Builder serverId(String value) {
            this.serverId = value;
            return this.self();
        }

        public Builder registryUrl(String value) {
            this.registryUrl = value;
            return this.self();
        }

        public Builder resources(List<Resource> values) {
            this.resources = values;
            return this.self();
        }

        public Builder stagingDirectoryPath(String value) {
            this.stagingDirectoryPath = value;
            return this.self();
        }

        public Builder buildDirectoryAbsolutePath(String value) {
            this.buildDirectoryAbsolutePath = value;
            return this.self();
        }

        public Builder project(MavenProject value) {
            this.project = value;
            return this.self();
        }

        public Builder session(MavenSession value) {
            this.session = value;
            return this.self();
        }

        public Builder filtering(MavenResourcesFiltering value) {
            this.filtering = value;
            return this.self();
        }

        public Builder deploymentSlotSetting(DeploymentSlotSetting value) {
            this.deploymentSlotSetting = value;
            return this.self();
        }

        public Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this.self();
        }
    }
}

