/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.storage.share;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.paging.ContinuablePage;
import com.azure.core.util.paging.ContinuablePagedIterable;
import com.azure.storage.file.share.ShareDirectoryClient;
import com.azure.storage.file.share.models.ShareFileItem;
import com.microsoft.azure.toolkit.lib.common.model.AbstractEmulatableAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.storage.share.IShareFile;
import com.microsoft.azure.toolkit.lib.storage.share.ShareFile;
import com.microsoft.azure.toolkit.lib.storage.share.ShareFileDraft;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class ShareFileModule
extends AbstractEmulatableAzResourceModule<ShareFile, IShareFile, ShareFileItem> {
    public static final String NAME = "file";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public ShareFileModule(@Nonnull IShareFile parent) {
        super(NAME, (AzResource)parent);
    }

    @Nullable
    protected ShareDirectoryClient getClient() {
        return (ShareDirectoryClient)((IShareFile)this.parent).getClient();
    }

    @Nonnull
    protected Iterator<? extends ContinuablePage<String, ShareFileItem>> loadResourcePagesFromAzure() {
        return Optional.ofNullable(this.getClient()).map(ShareDirectoryClient::listFilesAndDirectories).map(p -> p.streamByPage(ShareFileModule.getPageSize()).iterator()).orElse(Collections.emptyIterator());
    }

    @Nullable
    protected ShareFileItem loadResourceFromAzure(@Nonnull String name, @Nullable String resourceGroup) {
        return Optional.ofNullable(this.getClient()).map(ShareDirectoryClient::listFilesAndDirectories).map(ContinuablePagedIterable::stream).orElse(Stream.empty()).filter(r -> r.getName().equals(name)).findAny().orElse(null);
    }

    @AzureOperation(name="azure/storage.delete_share_file.file", params={"nameFromResourceId(resourceId)"})
    protected void deleteResourceFromAzure(@Nonnull String resourceId) {
        String string = resourceId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)string);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            ShareFile shareFile = (ShareFile)this.get(resourceId);
            if (shareFile != null && shareFile.exists()) {
                if (shareFile.isDirectory()) {
                    this.deleteDirectory((ShareDirectoryClient)Objects.requireNonNull(shareFile.getClient()));
                } else {
                    Objects.requireNonNull(this.getClient()).deleteFileIfExists(shareFile.getName());
                }
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private void deleteDirectory(ShareDirectoryClient client) {
        PagedIterable files = client.listFilesAndDirectories();
        for (ShareFileItem file : files) {
            if (file.isDirectory()) {
                this.deleteDirectory(client.getSubdirectoryClient(file.getName()));
                continue;
            }
            client.getFileClient(file.getName()).delete();
        }
        client.deleteIfExists();
    }

    @Nonnull
    protected AzResource.Draft<ShareFile, ShareFileItem> newDraftForCreate(@Nonnull String name, @Nullable String rgName) {
        return new ShareFileDraft(name, this);
    }

    @Nonnull
    protected AzResource.Draft<ShareFile, ShareFileItem> newDraftForUpdate(@Nonnull ShareFile shareFile) {
        return new ShareFileDraft(shareFile);
    }

    @Nonnull
    protected ShareFile newResource(@Nonnull ShareFileItem item) {
        return new ShareFile(item.getName(), this);
    }

    @Nonnull
    protected ShareFile newResource(@Nonnull String name, @Nullable String resourceGroupName) {
        return new ShareFile(name, this);
    }

    @Nonnull
    public String getResourceTypeName() {
        return "File";
    }

    static {
        ShareFileModule.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ShareFileModule.java", ShareFileModule.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "deleteResourceFromAzure", "com.microsoft.azure.toolkit.lib.storage.share.ShareFileModule", "java.lang.String", "resourceId", "", "void"), 59);
    }
}

