/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.storage.model;

import com.microsoft.azure.toolkit.lib.common.action.Action;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public interface StorageFile
extends AzResource {
    public static final Action.Id<StorageFile> OPEN_FILE = Action.Id.of((String)"user/storage.open_file.file");
    public static final Action.Id<StorageFile> CREATE_FILE = Action.Id.of((String)"user/storage.create_file.file");
    public static final Action.Id<StorageFile> CREATE_DIRECTORY = Action.Id.of((String)"user/storage.create_directory.dir");
    public static final Action.Id<StorageFile> UPLOAD_FILES = Action.Id.of((String)"user/storage.upload_files.dir");

    public AbstractAzResourceModule<? extends StorageFile, ? extends StorageFile, ?> getSubFileModule();

    @Nullable
    public Object getClient();

    public boolean isDirectory();

    public String getPath();

    public String getUrl();

    public String getSasUrl();

    default public long getSize() {
        if (this.isDirectory()) {
            return -1L;
        }
        throw new AzureToolkitRuntimeException("Not implemented.");
    }

    @Nullable
    public OffsetDateTime getLastModified();

    @Nullable
    default public OffsetDateTime getCreationTime() {
        return null;
    }

    public void download(OutputStream var1);

    public void download(Path var1);

    @Nullable
    default public StorageFile getFile(String relativePath) {
        if (StringUtils.isEmpty((CharSequence)relativePath) || StringUtils.equals((CharSequence)relativePath.trim(), (CharSequence)".")) {
            return this;
        }
        Path path = Paths.get(relativePath, new String[0]);
        StorageFile current = this;
        for (int i = 0; i < path.getNameCount(); ++i) {
            String name = path.getName(i).toString();
            if (!Objects.isNull(current = (StorageFile)current.getSubFileModule().get(name, null))) continue;
            return null;
        }
        return current;
    }

    public static interface Draft<T extends StorageFile, R>
    extends AzResource.Draft<T, R> {
        public void setDirectory(Boolean var1);

        public void setSourceFile(Path var1);
    }
}

