/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.storage.blob;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.paging.ContinuablePage;
import com.azure.core.util.paging.ContinuablePagedIterable;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.specialized.BlobClientBase;
import com.microsoft.azure.toolkit.lib.common.model.AbstractEmulatableAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.storage.blob.BlobFile;
import com.microsoft.azure.toolkit.lib.storage.blob.BlobFileDraft;
import com.microsoft.azure.toolkit.lib.storage.blob.IBlobFile;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.BooleanUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class BlobFileModule
extends AbstractEmulatableAzResourceModule<BlobFile, IBlobFile, BlobItem> {
    public static final String NAME = "file";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public BlobFileModule(@Nonnull IBlobFile parent) {
        super(NAME, (AzResource)parent);
    }

    @Nullable
    protected BlobContainerClient getClient() {
        return ((IBlobFile)this.parent).getClient();
    }

    @Nonnull
    protected Iterator<? extends ContinuablePage<String, BlobItem>> loadResourcePagesFromAzure() {
        return Optional.ofNullable(this.getClient()).map(c -> c.listBlobsByHierarchy(((IBlobFile)this.parent).getPath()).iterableByPage(BlobFileModule.getPageSize()).iterator()).orElse(Collections.emptyIterator());
    }

    @Nullable
    protected BlobItem loadResourceFromAzure(@Nonnull String name, @Nullable String resourceGroup) {
        Stream<BlobItem> resources = Optional.ofNullable(this.getClient()).map(c -> c.listBlobsByHierarchy(((IBlobFile)this.parent).getPath())).map(ContinuablePagedIterable::stream).orElse(Stream.empty());
        return resources.filter(r -> Objects.equals(Paths.get(r.getName(), new String[0]).getFileName().toString(), name)).findAny().orElse(null);
    }

    @AzureOperation(name="azure/storage.delete_blob.blob", params={"nameFromResourceId(resourceId)"})
    protected void deleteResourceFromAzure(@Nonnull String resourceId) {
        String string = resourceId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)string);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            BlobFile file = (BlobFile)this.get(resourceId);
            if (file != null) {
                if (BooleanUtils.isTrue((Boolean)file.isDirectory())) {
                    this.deleteDirectory(Objects.requireNonNull((BlobItem)file.getRemote()));
                } else {
                    Optional.ofNullable(this.getClient()).map(c -> c.getBlobClient(file.getPath())).ifPresent(BlobClientBase::delete);
                }
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private void deleteDirectory(BlobItem current) {
        BlobContainerClient containerClient = this.getClient();
        if (Objects.isNull(containerClient)) {
            return;
        }
        PagedIterable files = containerClient.listBlobsByHierarchy(current.getName());
        for (BlobItem file : files) {
            if (BooleanUtils.isTrue((Boolean)file.isPrefix())) {
                this.deleteDirectory(file);
                continue;
            }
            containerClient.getBlobClient(file.getName()).deleteIfExists();
        }
        containerClient.getBlobClient(current.getName()).deleteIfExists();
    }

    @Nonnull
    protected AzResource.Draft<BlobFile, BlobItem> newDraftForCreate(@Nonnull String name, @Nullable String rgName) {
        return new BlobFileDraft(name, this);
    }

    @Nonnull
    protected AzResource.Draft<BlobFile, BlobItem> newDraftForUpdate(@Nonnull BlobFile blobFile) {
        return new BlobFileDraft(blobFile);
    }

    @Nonnull
    protected BlobFile newResource(@Nonnull BlobItem item) {
        String name = Paths.get(item.getName(), new String[0]).getFileName().toString();
        return new BlobFile(name, this);
    }

    @Nonnull
    protected BlobFile newResource(@Nonnull String name, @Nullable String resourceGroupName) {
        return new BlobFile(name, this);
    }

    @Nonnull
    public String getResourceTypeName() {
        return "File";
    }

    static {
        BlobFileModule.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("BlobFileModule.java", BlobFileModule.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "deleteResourceFromAzure", "com.microsoft.azure.toolkit.lib.storage.blob.BlobFileModule", "java.lang.String", "resourceId", "", "void"), 61);
    }
}

