/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.storage.blob;

import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.models.BlobItemProperties;
import com.azure.storage.blob.specialized.BlobClientBase;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AbstractEmulatableAzResource;
import com.microsoft.azure.toolkit.lib.common.model.Deletable;
import com.microsoft.azure.toolkit.lib.storage.blob.BlobContainer;
import com.microsoft.azure.toolkit.lib.storage.blob.BlobFileModule;
import com.microsoft.azure.toolkit.lib.storage.blob.IBlobFile;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.BooleanUtils;

public class BlobFile
extends AbstractEmulatableAzResource<BlobFile, IBlobFile, BlobItem>
implements Deletable,
IBlobFile {
    private final BlobFileModule subFileModule;

    protected BlobFile(@Nonnull String name, @Nonnull BlobFileModule module) {
        super(name, (AbstractAzResourceModule)module);
        this.subFileModule = new BlobFileModule(this);
    }

    public BlobFile(@Nonnull BlobFile origin) {
        super((AbstractAzResource)origin);
        this.subFileModule = origin.subFileModule;
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
        return this.isDirectory() ? Collections.singletonList(this.subFileModule) : Collections.emptyList();
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, ?, ?>> getCachedSubModules() {
        return Objects.nonNull((Object)this.subFileModule) ? Collections.singletonList(this.subFileModule) : Collections.emptyList();
    }

    @Nonnull
    protected String loadStatus(@Nonnull BlobItem remote) {
        return "OK";
    }

    @Override
    public long getSize() {
        if (!this.isDirectory()) {
            return this.remoteOptional().map(r -> r.getProperties().getContentLength()).orElse(-1L);
        }
        return -1L;
    }

    @Override
    @Nullable
    public OffsetDateTime getLastModified() {
        if (!this.isDirectory()) {
            return this.remoteOptional().map(BlobItem::getProperties).map(BlobItemProperties::getLastModified).orElse(null);
        }
        return null;
    }

    @Override
    @Nullable
    public OffsetDateTime getCreationTime() {
        if (!this.isDirectory()) {
            return this.remoteOptional().map(BlobItem::getProperties).map(BlobItemProperties::getCreationTime).orElse(null);
        }
        return null;
    }

    @Override
    public void download(OutputStream output) {
        Optional.ofNullable(this.getClient()).map(c -> c.getBlobClient(this.getPath())).ifPresent(client -> client.downloadStream(output));
    }

    @Override
    public void download(Path dest) {
        Optional.ofNullable(this.getClient()).map(c -> c.getBlobClient(this.getPath())).ifPresent(client -> client.downloadToFile(dest.toAbsolutePath().toString()));
    }

    @Override
    @Nullable
    public BlobContainerClient getClient() {
        return ((IBlobFile)this.getParent()).getClient();
    }

    @Override
    public String getPath() {
        return this.remoteOptional().map(BlobItem::getName).orElse(Paths.get(((IBlobFile)this.getParent()).getPath(), this.getName()).toString());
    }

    @Override
    public String getUrl() {
        return Optional.ofNullable(this.getClient()).map(c -> c.getBlobClient(this.getPath())).map(BlobClientBase::getBlobUrl).orElse("");
    }

    @Override
    public BlobContainer getContainer() {
        return ((IBlobFile)this.getParent()).getContainer();
    }

    @Override
    public boolean isDirectory() {
        return this.remoteOptional().map(r -> BooleanUtils.isTrue((Boolean)r.isPrefix())).orElse(false);
    }

    @Nonnull
    public String getResourceTypeName() {
        return this.isDirectory() ? "Directory" : super.getResourceTypeName();
    }

    public BlobFileModule getSubFileModule() {
        return this.subFileModule;
    }
}

