/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.storage;

import com.azure.core.http.policy.FixedDelayOptions;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.util.paging.ContinuablePage;
import com.azure.data.tables.TableServiceClient;
import com.azure.data.tables.TableServiceClientBuilder;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.queue.QueueServiceClient;
import com.azure.storage.queue.QueueServiceClientBuilder;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import com.microsoft.azure.toolkit.lib.storage.AzureStorageAccount;
import com.microsoft.azure.toolkit.lib.storage.StorageAccount;
import com.microsoft.azure.toolkit.lib.storage.StorageAccountModule;
import com.microsoft.azure.toolkit.lib.storage.StorageServiceSubscription;
import com.microsoft.azure.toolkit.lib.storage.model.AccessTier;
import com.microsoft.azure.toolkit.lib.storage.model.Kind;
import com.microsoft.azure.toolkit.lib.storage.model.Performance;
import com.microsoft.azure.toolkit.lib.storage.model.Redundancy;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AzuriteStorageAccount
extends StorageAccount {
    public static final String AZURITE_RESOURCE_ID = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/azurite/providers/Microsoft.Storage/storageAccounts/azurite";
    public static final String AZURITE = "azurite";
    public static final AzuriteStorageAccount AZURITE_STORAGE_ACCOUNT = new AzuriteStorageAccount(AzuriteStorageAccountModule.access$000());
    public static final String AZURITE_CONNECTION_STRING = "DefaultEndpointsProtocol=http;AccountName=devstoreaccount1;AccountKey=Eby8vdM02xNOcqFlqUwJPLlmEtlCDXJ1OUzFT50uSRZ6IFsuFq2UVErCz4I6tq/K1SZFPTOtr/KBHBeksoGMGw==;BlobEndpoint=http://127.0.0.1:10000/devstoreaccount1;QueueEndpoint=http://127.0.0.1:10001/devstoreaccount1;TableEndpoint=http://127.0.0.1:10002/devstoreaccount1;";
    public static final String AZURITE_KEY = "Eby8vdM02xNOcqFlqUwJPLlmEtlCDXJ1OUzFT50uSRZ6IFsuFq2UVErCz4I6tq/K1SZFPTOtr/KBHBeksoGMGw==";
    private static final String CONNECTION_NAME = "devstoreaccount1";
    private static final String BLOBS_URI = "http://127.0.0.1:10000/devstoreaccount1";
    private static final String QUEUES_URI = "http://127.0.0.1:10001/devstoreaccount1";
    private static final String TABLES_URI = "http://127.0.0.1:10002/devstoreaccount1";
    private static final RetryOptions TEST_CONNECTION_RETRY_OPTIONS = new RetryOptions(new FixedDelayOptions(0, Duration.ofSeconds(1L)));

    protected AzuriteStorageAccount(@Nonnull StorageAccountModule module) {
        super(AZURITE, AZURITE, module);
    }

    protected void updateAdditionalProperties(@javax.annotation.Nullable com.azure.resourcemanager.storage.models.StorageAccount newRemote, @javax.annotation.Nullable com.azure.resourcemanager.storage.models.StorageAccount oldRemote) {
        this.subModules.clear();
        if (Objects.nonNull(newRemote)) {
            if (this.canHaveBlobs()) {
                this.subModules.add(this.blobContainerModule);
            }
            if (this.canHaveShares()) {
                this.subModules.add(this.shareModule);
            }
            if (this.canHaveQueues()) {
                this.subModules.add(this.queueModule);
            }
            if (this.canHaveTables()) {
                this.subModules.add(this.tableModule);
            }
        }
        super.updateAdditionalProperties((Object)newRemote, (Object)oldRemote);
    }

    @Nonnull
    public String getStatus() {
        boolean isAzuriteAccessible = CollectionUtils.isNotEmpty((Collection)this.subModules);
        return isAzuriteAccessible ? "Running" : "Stopped";
    }

    public void refresh() {
        Optional.ofNullable(this.subModules).ifPresent(List::clear);
        super.refresh();
    }

    public boolean exists() {
        return true;
    }

    @Override
    @Nonnull
    protected String loadStatus(@javax.annotation.Nullable com.azure.resourcemanager.storage.models.StorageAccount remote) {
        return this.getStatus();
    }

    @Nonnull
    public String getId() {
        return AZURITE_RESOURCE_ID;
    }

    @Override
    @Nonnull
    public String getConnectionString() {
        return AZURITE_CONNECTION_STRING;
    }

    @Override
    @Nonnull
    public String getKey() {
        return AZURITE_KEY;
    }

    @Override
    @javax.annotation.Nullable
    public Region getRegion() {
        return null;
    }

    @Override
    @javax.annotation.Nullable
    public Performance getPerformance() {
        return null;
    }

    @Override
    public boolean canHaveQueues() {
        try {
            QueueServiceClient client = new QueueServiceClientBuilder().retryOptions(TEST_CONNECTION_RETRY_OPTIONS).connectionString(AZURITE_CONNECTION_STRING).buildClient();
            client.getProperties();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean canHaveTables() {
        try {
            TableServiceClient client = new TableServiceClientBuilder().retryOptions(TEST_CONNECTION_RETRY_OPTIONS).connectionString(AZURITE_CONNECTION_STRING).buildClient();
            client.getProperties();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean canHaveBlobs() {
        try {
            BlobServiceClient client = new BlobServiceClientBuilder().retryOptions(TEST_CONNECTION_RETRY_OPTIONS).connectionString(AZURITE_CONNECTION_STRING).buildClient();
            client.getProperties();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean canHaveShares() {
        return false;
    }

    @Override
    @javax.annotation.Nullable
    public Redundancy getRedundancy() {
        return null;
    }

    @Override
    @javax.annotation.Nullable
    public Kind getKind() {
        return null;
    }

    @Override
    @javax.annotation.Nullable
    public AccessTier getAccessTier() {
        return null;
    }

    public boolean isEmulatorResource() {
        return true;
    }

    @NotNull
    public Subscription getSubscription() {
        return Subscription.NONE;
    }

    static class AzuriteStorageAccountModule
    extends StorageAccountModule {
        private static final AzuriteStorageAccountModule AZURITE_STORAGE_ACCOUNT_MODULE = new AzuriteStorageAccountModule(new StorageServiceSubscription("", (AzureStorageAccount)Azure.az(AzureStorageAccount.class)));

        public AzuriteStorageAccountModule(@Nonnull StorageServiceSubscription parent) {
            super(parent);
        }

        @Nonnull
        public List<StorageAccount> list() {
            return Arrays.asList(new StorageAccount[]{AZURITE_STORAGE_ACCOUNT});
        }

        @Nonnull
        protected Iterator<? extends ContinuablePage<String, com.azure.resourcemanager.storage.models.StorageAccount>> loadResourcePagesFromAzure() {
            return Collections.emptyIterator();
        }

        @javax.annotation.Nullable
        protected com.azure.resourcemanager.storage.models.StorageAccount loadResourceFromAzure(@Nonnull String name, @Nullable String resourceGroup) {
            return null;
        }

        @Override
        @Nonnull
        protected StorageAccount newResource(@Nonnull com.azure.resourcemanager.storage.models.StorageAccount storageAccount) {
            throw new AzureToolkitRuntimeException("not supported");
        }

        @Override
        @Nonnull
        protected StorageAccount newResource(@Nonnull String name, @javax.annotation.Nullable String resourceGroupName) {
            throw new AzureToolkitRuntimeException("not supported");
        }

        static /* synthetic */ AzuriteStorageAccountModule access$000() {
            return AZURITE_STORAGE_ACCOUNT_MODULE;
        }
    }
}

