/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.resource;

import com.azure.resourcemanager.resources.ResourceManager;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.Deletable;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.resource.ResourceDeploymentModule;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroupManager;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroupModule;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ResourceGroup
extends AbstractAzResource<ResourceGroup, ResourceGroupManager, com.azure.resourcemanager.resources.models.ResourceGroup>
implements Deletable {
    private final ResourceDeploymentModule deploymentModule;

    protected ResourceGroup(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull ResourceGroupModule module) {
        super(name, resourceGroupName, (AbstractAzResourceModule)module);
        this.deploymentModule = new ResourceDeploymentModule(this);
    }

    protected ResourceGroup(@Nonnull ResourceGroup origin) {
        super((AbstractAzResource)origin);
        this.deploymentModule = origin.deploymentModule;
    }

    protected ResourceGroup(@Nonnull com.azure.resourcemanager.resources.models.ResourceGroup remote, @Nonnull ResourceGroupModule module) {
        super(remote.name(), remote.name(), (AbstractAzResourceModule)module);
        this.deploymentModule = new ResourceDeploymentModule(this);
        this.setRemote(remote);
    }

    @Nonnull
    protected com.azure.resourcemanager.resources.models.ResourceGroup refreshRemote(@Nonnull com.azure.resourcemanager.resources.models.ResourceGroup remote) {
        ResourceManager manager = Objects.requireNonNull((ResourceManager)((ResourceGroupManager)this.getParent()).getRemote());
        return (com.azure.resourcemanager.resources.models.ResourceGroup)manager.resourceGroups().getByName(this.getName());
    }

    @Nonnull
    public List<AzResourceModule<?, ResourceGroup, ?>> getSubModules() {
        return Collections.singletonList(this.deploymentModule);
    }

    public ResourceDeploymentModule deployments() {
        return this.deploymentModule;
    }

    @Nonnull
    public String loadStatus(@Nonnull com.azure.resourcemanager.resources.models.ResourceGroup remote) {
        return remote.provisioningState();
    }

    @Nullable
    public Region getRegion() {
        return this.remoteOptional().map(remote -> Region.fromName((String)remote.regionName())).orElse(null);
    }

    @Nullable
    public String getType() {
        return this.remoteOptional().map(Resource::type).orElse(null);
    }

    @Nonnull
    public com.microsoft.azure.toolkit.lib.common.model.ResourceGroup toPojo() {
        return com.microsoft.azure.toolkit.lib.common.model.ResourceGroup.builder().subscriptionId(this.getSubscriptionId()).id(this.getId()).name(this.getName()).region(Objects.requireNonNull(this.getRegion()).getName()).build();
    }
}

