/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.resource;

import com.azure.resourcemanager.resources.ResourceManager;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceManager;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzService;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroup;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroupManager;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroupModule;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureResources
extends AbstractAzService<ResourceGroupManager, ResourceManager> {
    private static final Logger log = LoggerFactory.getLogger(AzureResources.class);

    public AzureResources() {
        super("Microsoft.Resources");
    }

    @Nonnull
    public ResourceGroupModule groups(@Nonnull String subscriptionId) {
        ResourceGroupManager rm = (ResourceGroupManager)this.get(subscriptionId, null);
        assert (rm != null);
        return rm.getGroupModule();
    }

    @Nonnull
    protected ResourceManager loadResourceFromAzure(@Nonnull String subscriptionId, String resourceGroup) {
        return AbstractAzResourceManager.getResourceManager((String)subscriptionId);
    }

    @Nonnull
    protected ResourceGroupManager newResource(@Nonnull ResourceManager remote) {
        return new ResourceGroupManager(remote, this);
    }

    @Nullable
    public <E> E getById(@Nonnull String id) {
        ResourceId resourceId = ResourceId.fromString((String)id);
        String resourceGroup = resourceId.resourceGroupName();
        if (resourceId.resourceType().equals("deployments")) {
            ResourceGroupManager manager = Objects.requireNonNull((ResourceGroupManager)this.getOrDraft(resourceId.subscriptionId(), resourceGroup));
            ResourceGroup group = (ResourceGroup)manager.resourceGroups().getOrDraft(resourceGroup, resourceGroup);
            return (E)group.deployments().get(resourceId.name(), resourceGroup);
        }
        return (E)super.getById(id);
    }

    @Nonnull
    public String getResourceTypeName() {
        return "Resource groups";
    }
}

