/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.utils;

import com.microsoft.azure.toolkit.lib.common.utils.NetUtils;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class InstallationIdUtils {
    private static final Pattern HASHED_MAC_PATTERN = Pattern.compile("[0-9a-f]{64}");
    private static final String INVALID_HASHED_MAC_ADDRESS = "6c9d2bc8f91b89624add29c0abeae7fb42bf539fa1cdb2e3e57cd668fa9bcead";

    public static boolean isValidHashMac(String hashMac) {
        return InstallationIdUtils.isValidHash(hashMac) && !InstallationIdUtils.isDepreciatedHashMac(hashMac);
    }

    @Nullable
    public static String getHashMac() {
        String mac = NetUtils.getMac();
        return StringUtils.isNotBlank((CharSequence)mac) ? InstallationIdUtils.hash(mac) : null;
    }

    public static String hash(String mac) {
        String ret;
        if (StringUtils.isEmpty((CharSequence)mac)) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] bytes = mac.getBytes(StandardCharsets.UTF_8);
            md.update(bytes);
            byte[] bytesAfterDigest = md.digest();
            StringBuilder sb = new StringBuilder();
            for (byte b : bytesAfterDigest) {
                sb.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
            }
            ret = sb.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            return null;
        }
        return ret;
    }

    private static boolean isValidHash(String hashMac) {
        if (StringUtils.isBlank((CharSequence)hashMac)) {
            return false;
        }
        Matcher matcher = HASHED_MAC_PATTERN.matcher(hashMac);
        return matcher.matches();
    }

    private static boolean isDepreciatedHashMac(String hashMac) {
        return StringUtils.containsIgnoreCase((CharSequence)System.getProperty("os.name"), (CharSequence)"mac") && StringUtils.equalsIgnoreCase((CharSequence)INVALID_HASHED_MAC_ADDRESS, (CharSequence)hashMac);
    }
}

