/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.operation;

import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.AzResourceModule;
import com.microsoft.azure.toolkit.lib.common.operation.Operation;
import com.microsoft.azure.toolkit.lib.common.operation.OperationContext;
import com.microsoft.azure.toolkit.lib.common.utils.Utils;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public abstract class OperationBase
implements Operation {
    private Operation parent;
    private OperationContext context;
    private Id idObject;

    @Override
    @Nonnull
    public String getExecutionId() {
        return Utils.getId(this);
    }

    @Override
    public synchronized OperationContext getContext() {
        if (Objects.isNull(this.context)) {
            this.context = new OperationContext(this);
        }
        return this.context;
    }

    private synchronized Id getIdObject() {
        if (Objects.isNull(this.idObject)) {
            this.idObject = new Id(this.getId());
        }
        return this.idObject;
    }

    @Override
    @Nonnull
    public String getType() {
        return this.getIdObject().getType();
    }

    @Override
    @Nonnull
    public final String getServiceName() {
        String serviceName = this.getIdObject().getService();
        if (serviceName.contains("$")) {
            Operation actionParent;
            Object source = this.getSource();
            if (source instanceof AzResourceModule) {
                return ((AzResourceModule)source).getServiceNameForTelemetry();
            }
            if (source instanceof AzResource) {
                return ((AzResource)source).getModule().getServiceNameForTelemetry();
            }
            String serviceNameFromContext = this.context.getProperty("serviceName");
            if (StringUtils.isBlank((CharSequence)serviceNameFromContext) && (actionParent = this.getActionParent()) != null && actionParent != this) {
                serviceNameFromContext = actionParent.getServiceName();
            }
            if (StringUtils.isNotBlank((CharSequence)serviceNameFromContext)) {
                return serviceNameFromContext;
            }
        }
        return serviceName;
    }

    @Override
    @Nonnull
    public final String getOperationName() {
        return this.getIdObject().getOperation();
    }

    @Override
    public Operation getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Operation parent) {
        this.parent = parent;
    }

    public static class Id {
        private final String id;
        private String type;
        private String service;
        private String operation;

        public Id(String id) {
            this.id = id;
            try {
                String[] parts = id.split("\\.");
                String[] typeAndService = parts[0].split("/");
                this.type = typeAndService[0];
                this.service = typeAndService[1];
                this.operation = parts[1];
            }
            catch (Exception e) {
                this.type = "unknown";
                this.service = "unknown";
                this.operation = "unknown";
            }
        }

        public String toString() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }

        public String getService() {
            return this.service;
        }

        public String getOperation() {
            return this.operation;
        }
    }
}

