/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.messager;

import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessage;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessage;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IAzureMessager {
    public static final String DEFAULT_TITLE = "Azure";

    default public void success(@Nonnull String message, Object ... actions) {
        this.show(this.buildMessage(IAzureMessage.Type.SUCCESS, AzureString.fromString(message), null, actions, null));
    }

    default public IAzureMessage buildSuccessMessage(@Nonnull String message, Object ... actions) {
        return this.buildMessage(IAzureMessage.Type.SUCCESS, AzureString.fromString(message), null, actions, null);
    }

    default public void success(@Nonnull String message, String title, Object ... actions) {
        this.show(this.buildMessage(IAzureMessage.Type.SUCCESS, AzureString.fromString(message), title, actions, null));
    }

    default public IAzureMessage buildSuccessMessage(@Nonnull String message, String title, Object ... actions) {
        return this.buildMessage(IAzureMessage.Type.SUCCESS, AzureString.fromString(message), title, actions, null);
    }

    default public void success(@Nonnull AzureString message, Object ... actions) {
        this.show(this.buildMessage(IAzureMessage.Type.SUCCESS, message, null, actions, null));
    }

    default public IAzureMessage buildSuccessMessage(@Nonnull AzureString message, Object ... actions) {
        return this.buildMessage(IAzureMessage.Type.SUCCESS, message, null, actions, null);
    }

    default public void success(@Nonnull AzureString message, String title, Object ... actions) {
        this.show(this.buildMessage(IAzureMessage.Type.SUCCESS, message, title, actions, null));
    }

    default public IAzureMessage buildSuccessMessage(@Nonnull AzureString message, String title, Object ... actions) {
        return this.buildMessage(IAzureMessage.Type.SUCCESS, message, title, actions, null);
    }

    default public void info(@Nonnull String message, Object ... actions) {
        this.show(this.buildMessage(IAzureMessage.Type.INFO, AzureString.fromString(message), null, actions, null));
    }

    default public IAzureMessage buildInfoMessage(@Nonnull String message, Object ... actions) {
        return this.buildMessage(IAzureMessage.Type.INFO, AzureString.fromString(message), null, actions, null);
    }

    default public void info(@Nonnull String message, String title, Object ... actions) {
        this.show(this.buildMessage(IAzureMessage.Type.INFO, AzureString.fromString(message), title, actions, null));
    }

    default public IAzureMessage buildInfoMessage(@Nonnull String message, String title, Object ... actions) {
        return this.buildMessage(IAzureMessage.Type.INFO, AzureString.fromString(message), title, actions, null);
    }

    default public void info(@Nonnull AzureString message, Object ... actions) {
        this.show(this.buildMessage(IAzureMessage.Type.INFO, message, null, actions, null));
    }

    default public IAzureMessage buildInfoMessage(@Nonnull AzureString message, Object ... actions) {
        return this.buildMessage(IAzureMessage.Type.INFO, message, null, actions, null);
    }

    default public void info(@Nonnull AzureString message, String title, Object ... actions) {
        this.show(this.buildMessage(IAzureMessage.Type.INFO, message, title, actions, null));
    }

    default public IAzureMessage buildInfoMessage(@Nonnull AzureString message, String title, Object ... actions) {
        return this.buildMessage(IAzureMessage.Type.INFO, message, title, actions, null);
    }

    default public void warning(@Nonnull String message, Object ... actions) {
        this.show(this.buildMessage(IAzureMessage.Type.WARNING, AzureString.fromString(message), null, actions, null));
    }

    default public IAzureMessage buildWarningMessage(@Nonnull String message, Object ... actions) {
        return this.buildMessage(IAzureMessage.Type.WARNING, AzureString.fromString(message), null, actions, null);
    }

    default public void warning(@Nonnull String message, String title, Object ... actions) {
        this.show(this.buildMessage(IAzureMessage.Type.WARNING, AzureString.fromString(message), title, actions, null));
    }

    default public IAzureMessage buildWarningMessage(@Nonnull String message, String title, Object ... actions) {
        return this.buildMessage(IAzureMessage.Type.WARNING, AzureString.fromString(message), title, actions, null);
    }

    default public void warning(@Nonnull AzureString message, Object ... actions) {
        this.show(this.buildMessage(IAzureMessage.Type.WARNING, message, null, actions, null));
    }

    default public IAzureMessage buildWarningMessage(@Nonnull AzureString message, Object ... actions) {
        return this.buildMessage(IAzureMessage.Type.WARNING, message, null, actions, null);
    }

    default public void warning(@Nonnull AzureString message, String title, Object ... actions) {
        this.show(this.buildMessage(IAzureMessage.Type.WARNING, message, title, actions, null));
    }

    default public IAzureMessage buildWarningMessage(@Nonnull AzureString message, String title, Object ... actions) {
        return this.buildMessage(IAzureMessage.Type.WARNING, message, title, actions, null);
    }

    default public void error(@Nonnull String message, Object ... actions) {
        this.show(this.buildMessage(IAzureMessage.Type.ERROR, AzureString.fromString(message), null, actions, null));
    }

    default public IAzureMessage buildErrorMessage(@Nonnull String message, Object ... actions) {
        return this.buildMessage(IAzureMessage.Type.ERROR, AzureString.fromString(message), null, actions, null);
    }

    default public void error(@Nonnull String message, String title, Object ... actions) {
        this.show(this.buildMessage(IAzureMessage.Type.ERROR, AzureString.fromString(message), title, actions, null));
    }

    default public IAzureMessage buildErrorMessage(@Nonnull String message, String title, Object ... actions) {
        return this.buildMessage(IAzureMessage.Type.ERROR, AzureString.fromString(message), title, actions, null);
    }

    default public void error(@Nonnull AzureString message, Object ... actions) {
        this.show(this.buildMessage(IAzureMessage.Type.ERROR, message, null, actions, null));
    }

    default public IAzureMessage buildErrorMessage(@Nonnull AzureString message, Object ... actions) {
        return this.buildMessage(IAzureMessage.Type.ERROR, message, null, actions, null);
    }

    default public void error(@Nonnull AzureString message, String title, Object ... actions) {
        this.show(this.buildMessage(IAzureMessage.Type.ERROR, message, title, actions, null));
    }

    default public IAzureMessage buildErrorMessage(@Nonnull AzureString message, String title, Object ... actions) {
        return this.buildMessage(IAzureMessage.Type.ERROR, message, title, actions, null);
    }

    default public void error(@Nonnull Throwable throwable, Object ... actions) {
        String message = Optional.ofNullable(throwable.getMessage()).orElse(throwable.getClass().getSimpleName());
        this.show(this.buildMessage(IAzureMessage.Type.ERROR, AzureString.fromString(message), null, actions, throwable));
    }

    default public IAzureMessage buildErrorMessage(@Nonnull Throwable throwable, Object ... actions) {
        String message = Optional.ofNullable(throwable.getMessage()).orElse(throwable.getClass().getSimpleName());
        return this.buildMessage(IAzureMessage.Type.ERROR, AzureString.fromString(message), null, actions, throwable);
    }

    default public void error(@Nonnull Throwable throwable, String title, Object ... actions) {
        String message = Optional.ofNullable(throwable.getMessage()).orElse(throwable.getClass().getSimpleName());
        this.show(this.buildMessage(IAzureMessage.Type.ERROR, AzureString.fromString(message), title, actions, throwable));
    }

    default public IAzureMessage buildErrorMessage(@Nonnull Throwable throwable, String title, Object ... actions) {
        String message = Optional.ofNullable(throwable.getMessage()).orElse(throwable.getClass().getSimpleName());
        return this.buildMessage(IAzureMessage.Type.ERROR, AzureString.fromString(message), title, actions, throwable);
    }

    default public void debug(@Nonnull String message, Object ... actions) {
        this.show(this.buildMessage(IAzureMessage.Type.DEBUG, AzureString.fromString(message), null, actions, null));
    }

    default public IAzureMessage buildDebugMessage(@Nonnull String message, Object ... actions) {
        return this.buildMessage(IAzureMessage.Type.DEBUG, AzureString.fromString(message), null, actions, null);
    }

    default public void debug(@Nonnull String message, String title, Object ... actions) {
        this.show(this.buildMessage(IAzureMessage.Type.DEBUG, AzureString.fromString(message), title, actions, null));
    }

    default public IAzureMessage buildDebugMessage(@Nonnull String message, String title, Object ... actions) {
        return this.buildMessage(IAzureMessage.Type.DEBUG, AzureString.fromString(message), title, actions, null);
    }

    default public void debug(@Nonnull AzureString message, Object ... actions) {
        this.show(this.buildMessage(IAzureMessage.Type.DEBUG, message, null, actions, null));
    }

    default public IAzureMessage buildDebugMessage(@Nonnull AzureString message, Object ... actions) {
        return this.buildMessage(IAzureMessage.Type.DEBUG, message, null, actions, null);
    }

    default public void debug(@Nonnull AzureString message, String title, Object ... actions) {
        this.show(this.buildMessage(IAzureMessage.Type.DEBUG, message, title, actions, null));
    }

    default public IAzureMessage buildDebugMessage(@Nonnull AzureString message, String title, Object ... actions) {
        return this.buildMessage(IAzureMessage.Type.DEBUG, message, title, actions, null);
    }

    default public boolean confirm(@Nonnull String message, String title) {
        return this.show(this.buildMessage(IAzureMessage.Type.CONFIRM, AzureString.fromString(message), title, null, null));
    }

    default public IAzureMessage buildConfirmMessage(@Nonnull String message, String title) {
        return this.buildMessage(IAzureMessage.Type.CONFIRM, AzureString.fromString(message), title, null, null);
    }

    default public boolean confirm(@Nonnull AzureString message, String title) {
        return this.show(this.buildMessage(IAzureMessage.Type.CONFIRM, message, title, null, null));
    }

    default public IAzureMessage buildConfirmMessage(@Nonnull AzureString message, String title) {
        return this.buildMessage(IAzureMessage.Type.CONFIRM, message, title, null, null);
    }

    default public void alert(@Nonnull String message, String title) {
        this.show(this.buildMessage(IAzureMessage.Type.ALERT, AzureString.fromString(message), title, null, null));
    }

    default public IAzureMessage buildAlertMessage(@Nonnull String message, String title) {
        return this.buildMessage(IAzureMessage.Type.ALERT, AzureString.fromString(message), title, null, null);
    }

    default public void alert(@Nonnull AzureString message, String title) {
        this.show(this.buildMessage(IAzureMessage.Type.ALERT, message, title, null, null));
    }

    default public IAzureMessage buildAlertMessage(@Nonnull AzureString message, String title) {
        return this.buildMessage(IAzureMessage.Type.ALERT, message, title, null, null);
    }

    default public boolean confirm(@Nonnull String message) {
        return this.confirm(message, null);
    }

    default public boolean confirm(@Nonnull AzureString message) {
        return this.confirm(message, null);
    }

    default public void alert(@Nonnull String message) {
        this.alert(message, null);
    }

    default public void alert(@Nonnull AzureString message) {
        this.alert(message, null);
    }

    default public void success(@Nonnull String message) {
        this.success(message, (Object[])null);
    }

    default public void success(@Nonnull AzureString message) {
        this.success(message, (Object[])null);
    }

    default public void info(@Nonnull String message) {
        this.info(message, (Object[])null);
    }

    default public void info(@Nonnull AzureString message) {
        this.info(message, (Object[])null);
    }

    default public void warning(@Nonnull String message) {
        this.warning(message, (Object[])null);
    }

    default public void warning(@Nonnull AzureString message) {
        this.warning(message, (Object[])null);
    }

    default public void error(@Nonnull String message) {
        this.error(message, (Object[])null);
    }

    default public void error(@Nonnull AzureString message) {
        this.error(message, (Object[])null);
    }

    default public void error(@Nonnull Throwable throwable) {
        this.error(throwable, (Object[])null);
    }

    default public void debug(@Nonnull String message) {
        this.debug(message, (Object[])null);
    }

    default public void debug(@Nonnull AzureString message) {
        this.debug(message, (Object[])null);
    }

    default public AzureMessage buildMessage(@Nonnull IAzureMessage.Type type, @Nonnull AzureString content, @Nullable String title, @Nullable Object[] actions, @Nullable Object payload) {
        AzureMessage message = new AzureMessage(type, content).setPayload(payload).setActions(actions).setTitle(title);
        if (this instanceof IAzureMessage.ValueDecorator) {
            message.setValueDecorator((IAzureMessage.ValueDecorator)((Object)this));
        }
        return message;
    }

    public boolean show(IAzureMessage var1);
}

