/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.model;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpResponse;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.account.IAzureAccount;
import com.microsoft.azure.toolkit.lib.common.cache.Cache1;
import com.microsoft.azure.toolkit.lib.common.event.AzureEventBus;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzServiceSubscription;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.AzResourceModule;
import com.microsoft.azure.toolkit.lib.common.task.AzureTaskManager;
import com.microsoft.azure.toolkit.lib.common.utils.Debouncer;
import com.microsoft.azure.toolkit.lib.common.utils.TailingDebouncer;
import com.microsoft.azure.toolkit.lib.resource.AzureResources;
import com.microsoft.azure.toolkit.lib.resource.GenericResourceModule;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroup;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAzResource<T extends AbstractAzResource<T, P, R>, P extends AzResource, R>
implements AzResource {
    private static final Logger log = LoggerFactory.getLogger(AbstractAzResource.class);
    @Nonnull
    private final String name;
    @Nonnull
    private final String resourceGroupName;
    @Nonnull
    private final AbstractAzResourceModule<T, P, R> module;
    @Nonnull
    private final Cache1<R> cache;
    @Nonnull
    private final AtomicReference<String> status;
    @Nonnull
    private final Debouncer fireEvents = new TailingDebouncer(this::fireStatusChangedEvent, 300);

    protected AbstractAzResource(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull AbstractAzResourceModule<T, P, R> module) {
        this.name = name;
        this.resourceGroupName = resourceGroupName;
        this.module = module;
        this.cache = new Cache1<Object>(this::loadRemoteFromAzure).onValueChanged(this::onRemoteUpdated).onStatusChanged(s -> this.fireEvents.debounce());
        this.status = new AtomicReference<String>("Unknown");
    }

    protected AbstractAzResource(@Nonnull String name, @Nonnull AbstractAzResourceModule<T, P, R> module) {
        this(name, module.getParent().getResourceGroupName(), module);
    }

    protected AbstractAzResource(@Nonnull AbstractAzResource<T, P, R> origin) {
        this.name = origin.getName();
        this.resourceGroupName = origin.getResourceGroupName();
        this.module = origin.getModule();
        this.cache = origin.cache;
        this.status = origin.status;
    }

    @Override
    public boolean exists() {
        P parent = this.getParent();
        if (StringUtils.equals((CharSequence)this.status.get(), (CharSequence)"Deleted")) {
            return false;
        }
        if (parent == AzResource.NONE || this instanceof AbstractAzServiceSubscription || this instanceof ResourceGroup) {
            return this.remoteOptional().isPresent();
        }
        ResourceGroup rg = this.getResourceGroup();
        return Objects.nonNull(rg) && rg.exists() && parent.exists() && this.remoteOptional().isPresent();
    }

    @Override
    public void refresh() {
        log.debug("[{}:{}]:refresh()", (Object)this.module.getName(), (Object)this.getName());
        this.invalidateCache();
        AzureEventBus.emit("resource.refreshed.resource", this);
    }

    public void invalidateCache() {
        log.debug("[{}:{}]:invalidateCache->subModules.invalidateCache()", (Object)this.module.getName(), (Object)this.getName());
        this.getCachedSubModules().forEach(AbstractAzResourceModule::invalidateCache);
        log.debug("[{}]:invalidateCache()", (Object)this.name);
        this.cache.invalidate();
    }

    @Nullable
    protected final R loadRemoteFromAzure() {
        log.debug("[{}:{}]:loadRemote()", (Object)this.module.getName(), (Object)this.getName());
        try {
            return ((AbstractAzResourceModule)this.getModule()).loadResourceFromAzure(this.getName(), this.getResourceGroupName());
        }
        catch (Exception e) {
            log.debug("[{}:{}]:loadRemote()=EXCEPTION", new Object[]{this.module.getName(), this.getName(), e});
            if (AbstractAzResource.isNotFoundException(e)) {
                return null;
            }
            throw e;
        }
    }

    @Nullable
    public final R getRemote() {
        log.debug("[{}:{}]:getRemote()", (Object)this.module.getName(), (Object)this.getName());
        if (this.isAuthRequired()) {
            Azure.az(IAzureAccount.class).account();
        }
        if (this.isDraftForCreating()) {
            log.debug("[{}:{}]:getRemote->this.isDraftForCreating()=true", (Object)this.module.getName(), (Object)this.getName());
            return null;
        }
        return this.cache.get();
    }

    protected void setRemote(R remote) {
        this.cache.update(() -> remote, "Updating");
    }

    @Nonnull
    protected Optional<R> remoteOptional() {
        return Optional.ofNullable(this.getRemote());
    }

    protected void onRemoteUpdated(@Nullable R newRemote, R oldRemote) {
        log.debug("[{}:{}]:setRemote({})", new Object[]{this.module.getName(), this.getName(), newRemote});
        if (oldRemote == null || newRemote == null) {
            log.debug("[{}:{}]:setRemote->subModules.invalidateCache()", (Object)this.module.getName(), (Object)this.getName());
            this.getCachedSubModules().forEach(AbstractAzResourceModule::invalidateCache);
        }
        log.debug("[{}:{}]:setRemote->this.remoteRef.set({})", new Object[]{this.module.getName(), this.getName(), newRemote});
        if (Objects.nonNull(newRemote)) {
            log.debug("[{}:{}]:setRemote->setStatus(LOADING)", (Object)this.module.getName(), (Object)this.getName());
            log.debug("[{}:{}]:setRemote->this.loadStatus", (Object)this.module.getName(), (Object)this.getName());
            this.updateAdditionalProperties(newRemote, oldRemote);
            AzureTaskManager.getInstance().runOnPooledThread(() -> Optional.of(newRemote).map(this::loadStatus).ifPresent(this::setStatus));
        } else {
            log.debug("[{}:{}]:setRemote->this.setStatus(DISCONNECTED)", (Object)this.module.getName(), (Object)this.getName());
            this.deleteFromCache();
            this.updateAdditionalProperties(null, oldRemote);
            this.getCachedSubModules().stream().flatMap(m -> m.listCachedResources().stream()).forEach(r -> r.setRemote(null));
        }
    }

    protected void updateAdditionalProperties(@Nullable R newRemote, @Nullable R oldRemote) {
    }

    @Override
    @Nonnull
    public String getStatus() {
        if (this.isDraftForCreating()) {
            return "Creating";
        }
        String cacheStatus = this.cache.getStatus();
        if (StringUtils.isBlank((CharSequence)cacheStatus)) {
            R remote = this.cache.getIfPresent(true);
            cacheStatus = Optional.ofNullable(this.cache.getStatus()).orElse("Loading");
        }
        return "OK".equalsIgnoreCase(cacheStatus) ? Optional.ofNullable(this.status.get()).orElse("Loading") : cacheStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(@Nonnull String status) {
        AtomicReference<String> atomicReference = this.status;
        synchronized (atomicReference) {
            log.debug("[{}:{}]:setStatus({})", new Object[]{this.module.getName(), this.getName(), status});
            String oldStatus = this.status.get();
            if (!Objects.equals(oldStatus, status)) {
                this.status.set(status);
                this.fireEvents.debounce();
                if (StringUtils.equalsAny((CharSequence)status, (CharSequence[])new CharSequence[]{"Deleting", "Deleted"})) {
                    this.getCachedSubModules().stream().flatMap(m -> m.listCachedResources().stream()).forEach(r -> r.setStatus(status));
                }
            }
        }
    }

    @Nonnull
    protected abstract String loadStatus(@Nonnull R var1);

    private void fireStatusChangedEvent() {
        log.debug("[{}]:fireStatusChangedEvent()", (Object)this.getName());
        AzureEventBus.emit("resource.status_changed.resource", this);
    }

    @Override
    public void delete() {
        log.debug("[{}:{}]:delete()", (Object)this.module.getName(), (Object)this.getName());
        this.doModify(() -> {
            if (this.exists()) {
                this.deleteFromAzure();
            }
            return null;
        }, "Deleting");
        this.deleteFromCache();
    }

    private void deleteFromAzure() {
        log.debug("[{}:{}]:delete->module.deleteResourceFromAzure({})", new Object[]{this.module.getName(), this.getName(), this.getId()});
        try {
            ((AbstractAzResourceModule)this.getModule()).deleteResourceFromAzure(this.getId());
        }
        catch (Exception e) {
            if (AbstractAzResource.isNotFoundException(e)) {
                log.debug("[{}]:delete()->deleteResourceFromAzure()=SC_NOT_FOUND", (Object)this.name, (Object)e);
            }
            this.getCachedSubModules().stream().flatMap(m -> m.listCachedResources().stream()).forEach(r -> r.setStatus("Unknown"));
            throw e;
        }
    }

    void deleteFromCache() {
        log.debug("[{}:{}]:delete->this.setStatus(DELETED)", (Object)this.module.getName(), (Object)this.getName());
        this.setStatus("Deleted");
        log.debug("[{}:{}]:delete->module.deleteResourceFromLocal({})", new Object[]{this.module.getName(), this.getName(), this.getName()});
        ((AbstractAzResourceModule)this.getModule()).deleteResourceFromLocal(this.getId(), new boolean[0]);
        ResourceId id = ResourceId.fromString((String)this.getId());
        ResourceGroup resourceGroup = this.getResourceGroup();
        if (Objects.isNull(id.parent()) && Objects.nonNull(resourceGroup)) {
            GenericResourceModule genericResourceModule = resourceGroup.genericResources();
            genericResourceModule.deleteResourceFromLocal(this.getId(), new boolean[0]);
        }
        this.getCachedSubModules().stream().flatMap(m -> m.listCachedResources().stream()).forEach(AbstractAzResource::deleteFromCache);
    }

    @Nonnull
    public AzResource.Draft<T, R> update() {
        log.debug("[{}:{}]:update()", (Object)this.module.getName(), (Object)this.getName());
        log.debug("[{}:{}]:update->module.update(this)", (Object)this.module.getName(), (Object)this.getName());
        return ((AbstractAzResourceModule)this.getModule()).update((AbstractAzResource)this.cast(this));
    }

    protected void doModify(@Nonnull Runnable body, @Nullable String status) {
        this.cache.update(body, status);
    }

    @Nullable
    protected R doModify(@Nonnull Callable<R> body, @Nullable String status) {
        return this.cache.update(body, status);
    }

    @Nonnull
    private <D> D cast(@Nonnull Object origin) {
        return (D)origin;
    }

    @Override
    @Nonnull
    public String getId() {
        return ((AbstractAzResourceModule)this.getModule()).toResourceId(this.getName(), this.getResourceGroupName());
    }

    @Nonnull
    public abstract List<AbstractAzResourceModule<?, ?, ?>> getSubModules();

    @Nonnull
    protected List<AbstractAzResourceModule<?, ?, ?>> getCachedSubModules() {
        return this.getSubModules();
    }

    @Nullable
    public AbstractAzResourceModule<?, ?, ?> getSubModule(String moduleName) {
        return this.getSubModules().stream().filter(m -> m.getName().equalsIgnoreCase(moduleName)).findAny().orElse(null);
    }

    @Nullable
    public ResourceGroup getResourceGroup() {
        boolean isResourceGroupSet;
        String rgName = this.getResourceGroupName();
        String sid = this.getSubscriptionId();
        boolean isSubscriptionSet = StringUtils.isNotBlank((CharSequence)sid) && !StringUtils.equalsAnyIgnoreCase((CharSequence)sid, (CharSequence[])new CharSequence[]{"<none>", NONE.getName()});
        boolean bl = isResourceGroupSet = StringUtils.isNotBlank((CharSequence)rgName) && !StringUtils.equalsAnyIgnoreCase((CharSequence)rgName, (CharSequence[])new CharSequence[]{"<none>", NONE.getName(), "${rg}"});
        if (!isResourceGroupSet || !isSubscriptionSet) {
            return null;
        }
        return (ResourceGroup)Azure.az(AzureResources.class).groups(this.getSubscriptionId()).get(rgName, rgName);
    }

    @Nonnull
    public P getParent() {
        return ((AbstractAzResourceModule)this.getModule()).getParent();
    }

    public boolean isDraft() {
        return this.isDraftForCreating() || this.isDraftForUpdating();
    }

    public boolean isDraftForCreating() {
        return this instanceof AzResource.Draft && Objects.isNull(((AzResource.Draft)((Object)this)).getOrigin()) && Objects.isNull(this.cache.getIfPresent()) && !StringUtils.equalsIgnoreCase((CharSequence)this.status.get(), (CharSequence)"Deleted") && !StringUtils.equalsIgnoreCase((CharSequence)this.status.get(), (CharSequence)"Error");
    }

    public boolean isDraftForUpdating() {
        return this instanceof AzResource.Draft && Objects.nonNull(((AzResource.Draft)((Object)this)).getOrigin());
    }

    protected boolean isAuthRequired() {
        return true;
    }

    public static boolean isNotFoundException(Throwable t) {
        Throwable cause = t instanceof HttpResponseException ? t : ExceptionUtils.getRootCause((Throwable)t);
        return Optional.ofNullable(cause).filter(c -> cause instanceof HttpResponseException).map(c -> (HttpResponseException)c).map(HttpResponseException::getResponse).map(HttpResponse::getStatusCode).filter(c -> c == 404).isPresent();
    }

    public String toString() {
        return "AbstractAzResource(name=" + this.getName() + ", resourceGroupName=" + this.getResourceGroupName() + ", status=" + this.getStatus() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractAzResource)) {
            return false;
        }
        AbstractAzResource other = (AbstractAzResource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$resourceGroupName = this.getResourceGroupName();
        String other$resourceGroupName = other.getResourceGroupName();
        if (this$resourceGroupName == null ? other$resourceGroupName != null : !this$resourceGroupName.equals(other$resourceGroupName)) {
            return false;
        }
        AzResourceModule this$module = this.getModule();
        AzResourceModule other$module = other.getModule();
        return !(this$module == null ? other$module != null : !this$module.equals(other$module));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractAzResource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $resourceGroupName = this.getResourceGroupName();
        result = result * 59 + ($resourceGroupName == null ? 43 : $resourceGroupName.hashCode());
        AzResourceModule $module = this.getModule();
        result = result * 59 + ($module == null ? 43 : $module.hashCode());
        return result;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public String getResourceGroupName() {
        return this.resourceGroupName;
    }

    @Nonnull
    public AbstractAzResourceModule<T, P, R> getModule() {
        return this.module;
    }
}

