/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.resource;

import com.azure.core.util.paging.ContinuablePage;
import com.azure.resourcemanager.resources.ResourceManager;
import com.azure.resourcemanager.resources.models.Deployment;
import com.azure.resourcemanager.resources.models.Deployments;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.resource.ResourceDeployment;
import com.microsoft.azure.toolkit.lib.resource.ResourceDeploymentDraft;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroup;
import com.microsoft.azure.toolkit.lib.resource.ResourcesServiceSubscription;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class ResourceDeploymentModule
extends AbstractAzResourceModule<ResourceDeployment, ResourceGroup, Deployment> {
    public static final String NAME = "deployments";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public ResourceDeploymentModule(@Nonnull ResourceGroup parent) {
        super(NAME, parent);
    }

    @Nullable
    public Deployments getClient() {
        return Optional.ofNullable((ResourceManager)((ResourcesServiceSubscription)((ResourceGroup)this.parent).getParent()).getRemote(new boolean[0])).map(ResourceManager::deployments).orElse(null);
    }

    @Nonnull
    protected ResourceDeploymentDraft newDraftForCreate(@Nonnull String name, @Nullable String resourceGroupName) {
        assert (resourceGroupName != null) : "'Resource group' is required.";
        return new ResourceDeploymentDraft(name, resourceGroupName, this);
    }

    @Nonnull
    protected ResourceDeploymentDraft newDraftForUpdate(@Nonnull ResourceDeployment origin) {
        return new ResourceDeploymentDraft(origin);
    }

    @Override
    @Nonnull
    protected Iterator<? extends ContinuablePage<String, Deployment>> loadResourcePagesFromAzure() {
        return Optional.ofNullable(this.getClient()).map(c -> c.listByResourceGroup(((ResourceGroup)this.parent).getName()).iterableByPage(ResourceDeploymentModule.getPageSize()).iterator()).orElse(Collections.emptyIterator());
    }

    @Override
    @Nonnull
    @AzureOperation(name="azure/resource.load_resources.type", params={"this.getResourceTypeName()"})
    protected Stream<Deployment> loadResourcesFromAzure() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            Deployments deployments = Objects.requireNonNull(this.getClient());
            Stream stream = deployments.listByResourceGroup(((ResourceGroup)this.parent).getName()).stream();
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return stream;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Override
    @Nonnull
    public String toResourceId(@Nonnull String resourceName, @Nullable String resourceGroup) {
        resourceGroup = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{resourceGroup, ((ResourceGroup)this.getParent()).getResourceGroupName(), "${rg}"});
        return String.format("/subscriptions/%s/resourceGroups/%s/providers/Microsoft.Resources/%s/%s", this.getSubscriptionId(), ((ResourceGroup)this.parent).getResourceGroupName(), this.getName(), resourceName).replace("${rg}", resourceGroup);
    }

    @Override
    @Nonnull
    protected ResourceDeployment newResource(@Nonnull Deployment r) {
        return new ResourceDeployment(r, this);
    }

    @Override
    @Nonnull
    protected ResourceDeployment newResource(@Nonnull String name, @Nullable String resourceGroupName) {
        return new ResourceDeployment(name, Objects.requireNonNull(resourceGroupName), this);
    }

    @Override
    @Nonnull
    public String getResourceTypeName() {
        return "Resource deployment";
    }

    static {
        ResourceDeploymentModule.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ResourceDeploymentModule.java", ResourceDeploymentModule.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "loadResourcesFromAzure", "com.microsoft.azure.toolkit.lib.resource.ResourceDeploymentModule", "", "", "", "java.util.stream.Stream"), 63);
    }
}

