/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.proxy;

import org.jetbrains.annotations.Nullable;

public class ProxyInfo {
    private String source;
    private String host;
    private int port;
    private String username;
    private String password;
    @Nullable
    private String nonProxyHosts;

    protected ProxyInfo(ProxyInfoBuilder<?, ?> b) {
        this.source = ((ProxyInfoBuilder)b).source;
        this.host = ((ProxyInfoBuilder)b).host;
        this.port = ((ProxyInfoBuilder)b).port;
        this.username = ((ProxyInfoBuilder)b).username;
        this.password = ((ProxyInfoBuilder)b).password;
        this.nonProxyHosts = ((ProxyInfoBuilder)b).nonProxyHosts;
    }

    public static ProxyInfoBuilder<?, ?> builder() {
        return new ProxyInfoBuilderImpl();
    }

    public String getSource() {
        return this.source;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    @Nullable
    public String getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    private static final class ProxyInfoBuilderImpl
    extends ProxyInfoBuilder<ProxyInfo, ProxyInfoBuilderImpl> {
        private ProxyInfoBuilderImpl() {
        }

        @Override
        protected ProxyInfoBuilderImpl self() {
            return this;
        }

        @Override
        public ProxyInfo build() {
            return new ProxyInfo(this);
        }
    }

    public static abstract class ProxyInfoBuilder<C extends ProxyInfo, B extends ProxyInfoBuilder<C, B>> {
        private String source;
        private String host;
        private int port;
        private String username;
        private String password;
        private String nonProxyHosts;

        protected abstract B self();

        public abstract C build();

        public B source(String source) {
            this.source = source;
            return this.self();
        }

        public B host(String host) {
            this.host = host;
            return this.self();
        }

        public B port(int port) {
            this.port = port;
            return this.self();
        }

        public B username(String username) {
            this.username = username;
            return this.self();
        }

        public B password(String password) {
            this.password = password;
            return this.self();
        }

        public B nonProxyHosts(@Nullable String nonProxyHosts) {
            this.nonProxyHosts = nonProxyHosts;
            return this.self();
        }

        public String toString() {
            return "ProxyInfo.ProxyInfoBuilder(source=" + this.source + ", host=" + this.host + ", port=" + this.port + ", username=" + this.username + ", password=" + this.password + ", nonProxyHosts=" + this.nonProxyHosts + ")";
        }
    }
}

