/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.model;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.util.paging.ContinuablePage;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.SupportsGettingById;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.SupportsGettingByName;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.SupportsGettingByResourceGroup;
import com.azure.resourcemanager.resources.fluentcore.collection.SupportsDeletingById;
import com.azure.resourcemanager.resources.fluentcore.collection.SupportsListing;
import com.google.common.collect.Sets;
import com.microsoft.azure.toolkit.lib.AzService;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.account.IAzureAccount;
import com.microsoft.azure.toolkit.lib.common.event.AzureEventBus;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzServiceSubscription;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.AzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.page.ItemPage;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.task.AzureTaskManager;
import com.microsoft.azure.toolkit.lib.common.utils.Debouncer;
import com.microsoft.azure.toolkit.lib.common.utils.TailingDebouncer;
import com.microsoft.azure.toolkit.lib.resource.GenericResource;
import com.microsoft.azure.toolkit.lib.resource.GenericResourceModule;
import com.microsoft.azure.toolkit.lib.resource.ResourceDeployment;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroup;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroupModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAzResourceModule<T extends AbstractAzResource<T, P, R>, P extends AzResource, R>
implements AzResourceModule<T> {
    private static final Logger log;
    @Nonnull
    private final String name;
    @Nonnull
    protected final P parent;
    @Nonnull
    private final AtomicLong syncTimeRef = new AtomicLong(-1L);
    @Nonnull
    private final Map<String, Optional<T>> resources = Collections.synchronizedMap(new LinkedHashMap());
    @Nonnull
    private final Debouncer fireEvents = new TailingDebouncer(this::fireChildrenChangedEvent, 300);
    private final Lock lock = new ReentrantLock();
    private Iterator<? extends ContinuablePage<String, R>> pages;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    @Override
    public void refresh() {
        log.debug("[{}]:refresh()", (Object)this.name);
        this.invalidateCache();
        AzureEventBus.emit("module.refreshed.module", this);
        AzureEventBus.emit("resource.children_changed.resource", this.getParent());
    }

    protected void invalidateCache() {
        log.debug("[{}]:invalidateCache()", (Object)this.name);
        if (this.lock.tryLock()) {
            try {
                this.resources.entrySet().removeIf(e -> !((Optional)e.getValue()).isPresent());
                this.syncTimeRef.set(-1L);
            }
            finally {
                this.lock.unlock();
            }
        }
        log.debug("[{}]:invalidateCache->resources.invalidateCache()", (Object)this.name);
        ArrayList<Optional<Optional>> values = new ArrayList<Optional<Optional>>(this.resources.values());
        values.forEach(v -> v.ifPresent(AbstractAzResource::invalidateCache));
    }

    @Override
    @Nonnull
    public List<T> list() {
        log.debug("[{}]:list()", (Object)this.name);
        Azure.az(IAzureAccount.class).account();
        if (this.parent instanceof AbstractAzResource && ((AbstractAzResource)this.parent).isDraftForCreating()) {
            log.debug("[{}]:list->parent.isDraftForCreating()=true", (Object)this.name);
            return Collections.emptyList();
        }
        if (System.currentTimeMillis() - this.syncTimeRef.get() > 1800000L) {
            try {
                this.lock.lock();
                if (this.syncTimeRef.get() != 0L && System.currentTimeMillis() - this.syncTimeRef.get() > 1800000L) {
                    log.debug("[{}]:list->this.reload()", (Object)this.name);
                    this.reloadResources();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        log.debug("[{}]:list->this.resources.values()", (Object)this.name);
        return this.resources.values().stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private void reloadResources() {
        log.debug("[{}]:reloadResources()", (Object)this.name);
        this.syncTimeRef.set(0L);
        try {
            log.debug("[{}]:reloadResources->loadResourcesFromAzure()", (Object)this.name);
            this.pages = this.loadResourcePagesFromAzure();
            ContinuablePage<String, R> page = this.pages.hasNext() ? this.pages.next() : new ContinuablePage<String, R>(this.loadResourcesFromAzure());
            Map<String, Object> loadedResources = page.getElements().stream().collect(Collectors.toMap(r -> ((AbstractAzResource)this.newResource(r)).getId().toLowerCase(), r -> r));
            log.debug("[{}]:reloadResources->setResources(xxx)", (Object)this.name);
            this.setResources(loadedResources);
        }
        catch (Exception e) {
            Throwable cause;
            log.debug("[{}]:reloadResources->setResources([])", (Object)this.name);
            Throwable throwable = cause = e instanceof HttpResponseException ? e : ExceptionUtils.getRootCause((Throwable)e);
            if (cause instanceof HttpResponseException && 404 == ((HttpResponseException)cause).getResponse().getStatusCode()) {
                log.debug("[{}]:reloadResources->loadResourceFromAzure()=SC_NOT_FOUND", (Object)this.name, (Object)e);
                this.setResources(Collections.emptyMap());
            }
            log.debug("[{}]:reloadResources->loadResourcesFromAzure()=EXCEPTION", (Object)this.name, (Object)e);
            this.resources.clear();
            this.syncTimeRef.compareAndSet(0L, System.currentTimeMillis());
            AzureMessager.getMessager().error(e);
            throw e;
        }
    }

    public void loadMoreResources() {
        log.debug("[{}]:loadMoreResources()", (Object)this.name);
        try {
            this.lock.lock();
            if (Objects.isNull(this.pages)) {
                this.reloadResources();
            } else if (this.pages.hasNext()) {
                ContinuablePage<String, R> page = this.pages.next();
                Map<String, Object> loadedResources = page.getElements().stream().collect(Collectors.toMap(r -> ((AbstractAzResource)this.newResource(r)).getId().toLowerCase(), r -> r));
                log.debug("[{}]:loadMoreResources->addResources(xxx)", (Object)this.name);
                this.addResources(loadedResources);
                this.fireEvents.debounce();
            }
        }
        catch (Exception e) {
            AzureMessager.getMessager().error(e);
            throw e;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean hasMoreResources() {
        return Objects.nonNull(this.pages) && this.pages.hasNext();
    }

    private void setResources(Map<String, R> loadedResources) {
        Set localResources = this.resources.values().stream().filter(Optional::isPresent).map(Optional::get).map(AbstractAzResource::getId).map(String::toLowerCase).collect(Collectors.toSet());
        Set creating = this.resources.values().stream().filter(Optional::isPresent).map(Optional::get).filter(AbstractAzResource::isDraftForCreating).map(AbstractAzResource::getId).map(String::toLowerCase).collect(Collectors.toSet());
        log.debug("[{}]:reload().creating={}", (Object)this.name, creating);
        Sets.SetView refreshed = Sets.intersection(localResources, loadedResources.keySet());
        log.debug("[{}]:reload().refreshed={}", (Object)this.name, (Object)refreshed);
        Sets.SetView deleted = Sets.difference((Set)Sets.difference(localResources, loadedResources.keySet()), creating);
        log.debug("[{}]:reload().deleted={}", (Object)this.name, (Object)deleted);
        Sets.SetView added = Sets.difference(loadedResources.keySet(), localResources);
        log.debug("[{}]:reload().added={}", (Object)this.name, (Object)added);
        log.debug("[{}]:reload.deleted->deleteResourceFromLocal", (Object)this.name);
        deleted.forEach(id -> this.resources.getOrDefault(id, Optional.empty()).ifPresent(r -> {
            r.deleteFromCache();
            r.setRemote(null);
        }));
        AzureTaskManager m = AzureTaskManager.getInstance();
        log.debug("[{}]:reload.refreshed->resource.setRemote", (Object)this.name);
        refreshed.forEach(id -> this.resources.getOrDefault(id, Optional.empty()).ifPresent(r -> m.runOnPooledThread(() -> r.setRemote(loadedResources.get(id)))));
        log.debug("[{}]:reload.added->addResourceToLocal", (Object)this.name);
        added.stream().map(loadedResources::get).map(r -> Pair.of((Object)r, this.newResource(r))).sorted(Comparator.comparing(p -> ((AbstractAzResource)p.getValue()).getName())).forEach(p -> {
            Object remote = p.getKey();
            AbstractAzResource resource = (AbstractAzResource)p.getValue();
            m.runOnPooledThread(() -> resource.setRemote(remote));
            this.addResourceToLocal(resource.getId(), resource, true);
        });
        this.syncTimeRef.set(System.currentTimeMillis());
    }

    private void addResources(Map<String, R> loadedResources) {
        Set<String> added = loadedResources.keySet();
        log.debug("[{}]:reload().added={}", (Object)this.name, added);
        loadedResources.values().stream().map(r -> Pair.of((Object)r, this.newResource(r))).sorted(Comparator.comparing(p -> ((AbstractAzResource)p.getValue()).getName())).forEach(p -> {
            Object remote = p.getKey();
            AbstractAzResource resource = (AbstractAzResource)p.getValue();
            AzureTaskManager.getInstance().runOnPooledThread(() -> resource.setRemote(remote));
            this.addResourceToLocal(resource.getId(), resource, true);
        });
        this.syncTimeRef.set(System.currentTimeMillis());
    }

    public void clear() {
        log.debug("[{}]:clear()", (Object)this.name);
        try {
            this.lock.lock();
            this.resources.clear();
            this.syncTimeRef.set(-1L);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @Nullable
    public T get(@Nonnull String name, @Nullable String rgName) {
        String resourceGroup = this.normalizeResourceGroupName(name, rgName);
        log.debug("[{}]:get({}, {})", new Object[]{this.name, name, resourceGroup});
        if (StringUtils.isBlank((CharSequence)name) || this.parent instanceof AbstractAzResource && ((AbstractAzResource)this.parent).isDraftForCreating()) {
            log.debug("[{}]:get->parent.isDraftForCreating()=true||isBlank(name)=true", (Object)this.name);
            return null;
        }
        Azure.az(IAzureAccount.class).account();
        String id = this.toResourceId(name, resourceGroup).toLowerCase();
        if (!this.resources.containsKey(id)) {
            Object remote;
            block6: {
                remote = null;
                try {
                    log.debug("[{}]:get({}, {})->loadResourceFromAzure()", new Object[]{this.name, name, resourceGroup});
                    remote = this.loadResourceFromAzure(name, resourceGroup);
                }
                catch (Exception e) {
                    Throwable cause;
                    log.debug("[{}]:get({}, {})->loadResourceFromAzure()=EXCEPTION", new Object[]{this.name, name, resourceGroup, e});
                    Throwable throwable = cause = e instanceof HttpResponseException ? e : ExceptionUtils.getRootCause((Throwable)e);
                    if (!(cause instanceof HttpResponseException) || 404 == ((HttpResponseException)cause).getResponse().getStatusCode()) break block6;
                    log.debug("[{}]:get({}, {})->loadResourceFromAzure()=SC_NOT_FOUND", new Object[]{this.name, name, resourceGroup, e});
                    throw e;
                }
            }
            if (Objects.isNull(remote)) {
                log.debug("[{}]:get({}, {})->addResourceToLocal({}, null)", new Object[]{this.name, name, resourceGroup, name});
                this.addResourceToLocal(id, null, true);
            } else {
                T resource = this.newResource(remote);
                ((AbstractAzResource)resource).setRemote(remote);
                log.debug("[{}]:get({}, {})->addResourceToLocal({}, resource)", new Object[]{this.name, name, resourceGroup, name});
                this.addResourceToLocal(((AbstractAzResource)resource).getId(), resource, true);
            }
        }
        log.debug("[{}]:get({}, {})->this.resources.get({})", new Object[]{this.name, id, resourceGroup, name});
        return (T)((AbstractAzResource)this.resources.getOrDefault(id, Optional.empty()).orElse(null));
    }

    @Override
    @Nullable
    public T get(@Nonnull String resourceId) {
        ResourceId id = ResourceId.fromString((String)resourceId);
        log.debug("[{}]:get({})", (Object)this.name, (Object)resourceId);
        return (T)this.get(id.name(), id.resourceGroupName());
    }

    @Override
    public boolean exists(@Nonnull String name, @Nullable String rgName) {
        String resourceGroup = this.normalizeResourceGroupName(name, rgName);
        log.debug("[{}]:exists({}, {})", new Object[]{this.name, name, resourceGroup});
        AzResource resource = this.get(name, resourceGroup);
        return Objects.nonNull(resource) && ((AbstractAzResource)resource).exists();
    }

    @Override
    public void delete(@Nonnull String name, @Nullable String rgName) {
        String resourceGroup = this.normalizeResourceGroupName(name, rgName);
        log.debug("[{}]:delete({}, {})", new Object[]{this.name, name, resourceGroup});
        log.debug("[{}]:delete->this.get({}, {})", new Object[]{this.name, name, resourceGroup});
        AzResource resource = this.get(name, resourceGroup);
        if (!Objects.nonNull(resource)) {
            throw new AzureToolkitRuntimeException(String.format("resource \"%s\" doesn't exist", name));
        }
        log.debug("[{}]:delete->resource.delete()", (Object)this.name);
        ((AbstractAzResource)resource).delete();
    }

    @Override
    @Nonnull
    public T getOrDraft(@Nonnull String name, @Nullable String rgName) {
        String resourceGroup = this.normalizeResourceGroupName(name, rgName);
        log.debug("[{}]:getOrDraft({}, {})", new Object[]{this.name, name, resourceGroup});
        return (T)Optional.ofNullable(this.get(name, resourceGroup)).orElseGet(() -> (AbstractAzResource)this.cast(this.newDraftForCreate(name, resourceGroup)));
    }

    @Nonnull
    public T getOrTemp(@Nonnull String name, @Nullable String rgName) {
        String resourceGroup = this.normalizeResourceGroupName(name, rgName);
        log.debug("[{}]:getOrTemp({}, {})", new Object[]{this.name, name, rgName});
        String id = this.toResourceId(name, resourceGroup).toLowerCase();
        return (T)this.resources.getOrDefault(id, Optional.empty()).orElseGet(() -> this.newResource(name, resourceGroup));
    }

    @Nonnull
    public T getOrInit(@Nonnull String name, @Nullable String rgName) {
        String resourceGroup = this.normalizeResourceGroupName(name, rgName);
        log.debug("[{}]:getOrDraft({}, {})", new Object[]{this.name, name, rgName});
        String id = this.toResourceId(name, resourceGroup).toLowerCase();
        return (T)this.resources.getOrDefault(id, Optional.empty()).orElseGet(() -> {
            T resource = this.newResource(name, resourceGroup);
            log.debug("[{}]:get({}, {})->addResourceToLocal({}, resource)", new Object[]{this.name, id, resourceGroup, name});
            this.addResourceToLocal(id, resource, new boolean[0]);
            return resource;
        });
    }

    @Nonnull
    public List<T> listCachedResources() {
        return this.resources.values().stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    @Nonnull
    public List<T> listByResourceGroup(@Nonnull String resourceGroup) {
        log.debug("[{}]:listByResourceGroupName({})", (Object)this.name, (Object)resourceGroup);
        return this.list().stream().filter(r -> r.getResourceGroupName().equalsIgnoreCase(resourceGroup)).collect(Collectors.toList());
    }

    @Nonnull
    public <D extends AzResource.Draft<T, R>> D updateOrCreate(@Nonnull String name, @Nullable String rgName) {
        String resourceGroup = this.normalizeResourceGroupName(name, rgName);
        log.debug("[{}]:updateOrCreate({}, {})", new Object[]{this.name, name, resourceGroup});
        AzResource resource = this.get(name, resourceGroup);
        if (Objects.nonNull(resource)) {
            return (D)((AzResource.Draft)this.cast(this.newDraftForUpdate(resource)));
        }
        return (D)((AzResource.Draft)this.cast(this.newDraftForCreate(name, resourceGroup)));
    }

    @Nonnull
    public <D extends AzResource.Draft<T, R>> D create(@Nonnull String name, @Nullable String rgName) {
        String resourceGroup = this.normalizeResourceGroupName(name, rgName);
        log.debug("[{}]:create({}, {})", new Object[]{this.name, name, resourceGroup});
        log.debug("[{}]:create->newDraftForCreate({}, {})", new Object[]{this.name, name, resourceGroup});
        return (D)((AzResource.Draft)this.cast(this.newDraftForCreate(name, resourceGroup)));
    }

    @Override
    @Nonnull
    public T create(@Nonnull AzResource.Draft<T, ?> d) {
        AzResource.Draft draft = (AzResource.Draft)this.cast(d);
        log.debug("[{}]:create(draft:{})", (Object)this.name, (Object)draft);
        AzResource existing = this.get(draft.getName(), draft.getResourceGroupName());
        if (Objects.isNull(existing)) {
            AbstractAzResource resource = (AbstractAzResource)this.cast(draft);
            log.debug("[{}]:create->addResourceToLocal({})", (Object)this.name, (Object)resource);
            this.addResourceToLocal(resource.getId(), resource, new boolean[0]);
            log.debug("[{}]:create->doModify(draft.createResourceInAzure({}))", (Object)this.name, (Object)resource);
            try {
                resource.doModify(draft::createResourceInAzure, "Creating");
            }
            catch (RuntimeException e) {
                resource.delete();
                throw e;
            }
            AzureEventBus.emit("azure.explorer.highlight_resource", resource);
            return (T)resource;
        }
        throw new AzureToolkitRuntimeException(String.format("resource \"%s\" is existing", ((AbstractAzResource)existing).getName()));
    }

    @Nonnull
    <D extends AzResource.Draft<T, R>> D update(@Nonnull T resource) {
        log.debug("[{}]:update(resource:{})", (Object)this.name, resource);
        if (((AbstractAzResource)resource).isDraftForCreating()) {
            log.warn("[{}]:updating(resource:{}) from a draftForCreating", (Object)this.name, resource);
        }
        if (((AbstractAzResource)resource).isDraftForUpdating()) {
            return (D)((AzResource.Draft)this.cast(resource));
        }
        log.debug("[{}]:update->newDraftForUpdate({})", (Object)this.name, resource);
        AbstractAzResource draft = (AbstractAzResource)this.cast(this.newDraftForUpdate(resource));
        return (D)((AzResource.Draft)this.cast(draft));
    }

    @Override
    @Nonnull
    public T update(@Nonnull AzResource.Draft<T, ?> draft) {
        AzResource.Draft d = (AzResource.Draft)this.cast(draft);
        log.debug("[{}]:update(draft:{})", (Object)this.name, draft);
        AzResource resource = this.get(draft.getName(), draft.getResourceGroupName());
        if (Objects.nonNull(resource) && Objects.nonNull(((AbstractAzResource)resource).getRemote(new boolean[0]))) {
            log.debug("[{}]:update->doModify(draft.updateResourceInAzure({}))", (Object)this.name, ((AbstractAzResource)resource).getRemote(new boolean[0]));
            ((AbstractAzResource)resource).doModify(() -> AbstractAzResourceModule.lambda$update$23(d, (AbstractAzResource)resource), "Updating");
            return (T)resource;
        }
        throw new AzureToolkitRuntimeException(String.format("resource \"%s\" doesn't exist", draft.getName()));
    }

    @Nonnull
    public String toResourceId(@Nonnull String resourceName, @Nullable String resourceGroup) {
        resourceGroup = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{resourceGroup, this.getParent().getResourceGroupName(), "${rg}"});
        return String.format("%s/%s/%s", this.parent.getId(), this.getName(), resourceName).replace("${rg}", resourceGroup);
    }

    protected void deleteResourceFromLocal(@Nonnull String id, boolean ... silent) {
        log.debug("[{}]:deleteResourceFromLocal({})", (Object)this.name, (Object)id);
        log.debug("[{}]:deleteResourceFromLocal->this.resources.remove({})", (Object)this.name, (Object)id);
        id = id.toLowerCase();
        Optional<T> removed = this.resources.remove(id);
        if (Objects.nonNull(removed) && removed.isPresent()) {
            this.deleteResourceFromLocalResourceGroup((AbstractAzResource)removed.get(), silent);
            if (silent.length == 0 || !silent[0]) {
                log.debug("[{}]:deleteResourceFromLocal->fireResourcesChangedEvent()", (Object)this.name);
                this.fireEvents.debounce();
            }
        }
    }

    protected void deleteResourceFromLocalResourceGroup(@Nonnull T resource, boolean ... silent) {
        ResourceId rId = ResourceId.fromString((String)((AbstractAzResource)resource).getId());
        ResourceGroup resourceGroup = ((AbstractAzResource)resource).getResourceGroup();
        if (Objects.isNull(rId.parent()) && Objects.nonNull(resourceGroup) && !(resource instanceof ResourceGroup) && !(resource instanceof ResourceDeployment)) {
            GenericResourceModule genericResourceModule = resourceGroup.genericResources();
            genericResourceModule.deleteResourceFromLocal(((AbstractAzResource)resource).getId(), silent);
        }
    }

    protected void addResourceToLocal(@Nonnull String id, @Nullable T resource, boolean ... silent) {
        log.debug("[{}]:addResourceToLocal({}, {})", new Object[]{this.name, id, resource});
        id = id.toLowerCase();
        Optional oldResource = this.resources.getOrDefault(id, Optional.empty());
        Optional<T> newResource = Optional.ofNullable(resource);
        if (!oldResource.isPresent()) {
            log.debug("[{}]:addResourceToLocal->this.resources.put({}, {})", new Object[]{this.name, id, resource});
            this.resources.put(id, newResource);
            if (newResource.isPresent()) {
                this.addResourceToLocalResourceGroup(id, resource, silent);
                if (silent.length == 0 || !silent[0]) {
                    log.debug("[{}]:addResourceToLocal->fireResourcesChangedEvent()", (Object)this.name);
                    this.fireEvents.debounce();
                }
            }
        }
    }

    protected void addResourceToLocalResourceGroup(@Nonnull String id, @Nonnull T resource, boolean ... silent) {
        ResourceId rId = ResourceId.fromString((String)id);
        ResourceGroup resourceGroup = ((AbstractAzResource)resource).getResourceGroup();
        if (Objects.isNull(rId.parent()) && Objects.nonNull(resourceGroup) && !(resource instanceof ResourceGroup) && !(resource instanceof ResourceDeployment)) {
            GenericResourceModule genericResourceModule = resourceGroup.genericResources();
            GenericResource genericResource = genericResourceModule.newResource((AbstractAzResource<?, ?, ?>)resource);
            genericResourceModule.addResourceToLocal(((AbstractAzResource)resource).getId(), genericResource, silent);
        }
    }

    private void fireChildrenChangedEvent() {
        log.debug("[{}]:fireChildrenChangedEvent()", (Object)this.name);
        if (this.getParent() instanceof AbstractAzServiceSubscription) {
            AzResourceModule<?> service = this.getParent().getModule();
            AzureEventBus.emit("service.children_changed.service", service);
        }
        if (this instanceof AzService) {
            AzureEventBus.emit("service.children_changed.service", this);
        }
        AzureEventBus.emit("resource.children_changed.resource", this.getParent());
        AzureEventBus.emit("module.children_changed.module", this);
    }

    @Nonnull
    @AzureOperation(name="azure/resource.load_resources.type", params={"this.getResourceTypeName()"})
    protected Stream<R> loadResourcesFromAzure() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            Stream stream;
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            log.debug("[{}]:loadResourcesFromAzure()", (Object)this.getName());
            Object client = this.getClient();
            if (!this.parent.exists()) {
                stream = Stream.empty();
            } else if (client instanceof SupportsListing) {
                log.debug("[{}]:loadResourcesFromAzure->client.list()", (Object)this.name);
                stream = ((SupportsListing)this.cast(client)).list().stream();
            } else {
                if (client != null) {
                    log.debug("[{}]:loadResourcesFromAzure->NOT Supported", (Object)this.name);
                    throw new AzureToolkitRuntimeException("not supported");
                }
                stream = Stream.empty();
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return stream;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    @AzureOperation(name="azure/resource.load_resources_by_page.type", params={"this.getResourceTypeName()"})
    protected Iterator<? extends ContinuablePage<String, R>> loadResourcePagesFromAzure() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        try {
            Iterator<Object> iterator;
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            log.debug("[{}]:loadPagedResourcesFromAzure()", (Object)this.getName());
            Object client = this.getClient();
            if (!this.parent.exists()) {
                iterator = Collections.emptyIterator();
            } else if (client instanceof SupportsListing) {
                log.debug("[{}]:loadPagedResourcesFromAzure->client.list()", (Object)this.name);
                iterator = ((SupportsListing)this.cast(client)).list().iterableByPage(AbstractAzResourceModule.getPageSize()).iterator();
            } else {
                log.debug("[{}]:loadPagedResourcesFromAzure->NOT Supported", (Object)this.name);
                iterator = Collections.singletonList(new ItemPage<R>(this.loadResourcesFromAzure())).iterator();
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return iterator;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nullable
    @AzureOperation(name="azure/resource.load_resource.resource|type", params={"name", "this.getResourceTypeName()"})
    protected R loadResourceFromAzure(@Nonnull String name, @Nullable String resourceGroup) {
        String string = name;
        String string2 = resourceGroup;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string, (Object)string2);
        try {
            Object object;
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            log.debug("[{}]:loadResourceFromAzure({}, {})", new Object[]{this.getName(), name, resourceGroup});
            Object client = this.getClient();
            resourceGroup = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{resourceGroup, this.getParent().getResourceGroupName()});
            String string3 = resourceGroup = StringUtils.equals((CharSequence)resourceGroup, (CharSequence)"${rg}") ? null : resourceGroup;
            if (client instanceof SupportsGettingById && StringUtils.isNotEmpty((CharSequence)resourceGroup)) {
                log.debug("[{}]:loadResourceFromAzure->client.getById({}, {})", new Object[]{this.name, resourceGroup, name});
                object = ((SupportsGettingById)this.cast(client)).getById(this.toResourceId(name, resourceGroup));
            } else if (client instanceof SupportsGettingByResourceGroup && StringUtils.isNotEmpty((CharSequence)resourceGroup)) {
                log.debug("[{}]:loadResourceFromAzure->client.getByResourceGroup({}, {})", new Object[]{this.name, resourceGroup, name});
                object = ((SupportsGettingByResourceGroup)this.cast(client)).getByResourceGroup(resourceGroup, name);
            } else if (client instanceof SupportsGettingByName) {
                log.debug("[{}]:loadResourceFromAzure->client.getByName({})", (Object)this.name, (Object)name);
                object = ((SupportsGettingByName)this.cast(client)).getByName(name);
            } else {
                log.debug("[{}]:loadResourceFromAzure->this.list().filter({}).getRemote()", (Object)this.name, (Object)name);
                object = this.list().stream().filter(r -> StringUtils.equals((CharSequence)name, (CharSequence)r.getName())).findAny().map(rec$ -> ((AbstractAzResource)rec$).getRemote(new boolean[0])).orElse(null);
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return (R)object;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="azure/resource.delete_resource.resource|type", params={"nameFromResourceId(resourceId)", "this.getResourceTypeName()"})
    protected void deleteResourceFromAzure(@Nonnull String resourceId) {
        String string = resourceId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            log.debug("[{}]:deleteResourceFromAzure({})", (Object)this.getName(), (Object)resourceId);
            Object client = this.getClient();
            if (client instanceof SupportsDeletingById) {
                log.debug("[{}]:deleteResourceFromAzure->client.deleteById({})", (Object)this.name, (Object)resourceId);
                ((SupportsDeletingById)client).deleteById(resourceId);
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private String normalizeResourceGroupName(String name, @Nullable String rgName) {
        if (StringUtils.isBlank((CharSequence)(rgName = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{rgName, this.getParent().getResourceGroupName()}))) || StringUtils.equalsIgnoreCase((CharSequence)rgName, (CharSequence)"${rg}")) {
            if (this instanceof ResourceGroupModule) {
                return name;
            }
            if (this instanceof AzService) {
                return "${rg}";
            }
            throw new IllegalArgumentException("Resource Group name is required for " + this.getResourceTypeName());
        }
        return rgName;
    }

    @Nonnull
    protected AzResource.Draft<T, R> newDraftForCreate(@Nonnull String name, @Nullable String rgName) {
        throw new AzureToolkitRuntimeException("not supported");
    }

    @Nonnull
    protected AzResource.Draft<T, R> newDraftForUpdate(@Nonnull T t) {
        throw new AzureToolkitRuntimeException("not supported");
    }

    @Nonnull
    protected abstract T newResource(@Nonnull R var1);

    @Nonnull
    protected abstract T newResource(@Nonnull String var1, @Nullable String var2);

    @Nullable
    protected Object getClient() {
        throw new AzureToolkitRuntimeException("not implemented");
    }

    @Override
    @Nonnull
    public String getFullResourceType() {
        return this.getParent().getFullResourceType() + "/" + this.getName();
    }

    @Override
    @Nonnull
    public String getResourceTypeName() {
        return this.getFullResourceType();
    }

    @Override
    @Nonnull
    public String getSubscriptionId() {
        return this.getParent().getSubscriptionId();
    }

    @Nonnull
    protected <D> D cast(@Nonnull Object origin) {
        return (D)origin;
    }

    public static int getPageSize() {
        return Azure.az().config().getPageSize();
    }

    public AbstractAzResourceModule(@Nonnull String name, @Nonnull P parent) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (parent == null) {
            throw new NullPointerException("parent is marked non-null but is null");
        }
        this.name = name;
        this.parent = parent;
    }

    public String toString() {
        return "AbstractAzResourceModule(name=" + this.getName() + ", syncTimeRef=" + this.syncTimeRef + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractAzResourceModule)) {
            return false;
        }
        AbstractAzResourceModule other = (AbstractAzResourceModule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        P this$parent = this.getParent();
        P other$parent = other.getParent();
        return !(this$parent == null ? other$parent != null : !this$parent.equals(other$parent));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractAzResourceModule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        P $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : $parent.hashCode());
        return result;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public P getParent() {
        return this.parent;
    }

    private static /* synthetic */ Object lambda$update$23(AzResource.Draft d, AbstractAzResource resource) throws Exception {
        return d.updateResourceInAzure(Objects.requireNonNull(resource.getRemote(new boolean[0])));
    }

    static {
        AbstractAzResourceModule.ajc$preClinit();
        log = LoggerFactory.getLogger(AbstractAzResourceModule.class);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AbstractAzResourceModule.java", AbstractAzResourceModule.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "loadResourcesFromAzure", "com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule", "", "", "", "java.util.stream.Stream"), 504);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "loadResourcePagesFromAzure", "com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule", "", "", "", "java.util.Iterator"), 521);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "loadResourceFromAzure", "com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule", "java.lang.String:java.lang.String", "name:resourceGroup", "", "java.lang.Object"), 537);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "deleteResourceFromAzure", "com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule", "java.lang.String", "resourceId", "", "void"), 558);
    }
}

